/*
 * Decompiled with CFR 0.152.
 */
package com.cookta2012.dimstructrestrict.mixin;

import com.cookta2012.dimstructrestrict.DimensionalStructureRestrict;
import com.cookta2012.dimstructrestrict.Rule;
import com.cookta2012.dimstructrestrict.mixin.StructureManagerAccessor;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkGenerator.class})
public abstract class ChunkGeneratorMixin {
    @Inject(method={"tryGenerateStructure"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTryGenerateStructure(StructureSet.StructureSelectionEntry entry, StructureManager manager, RegistryAccess registryAccess, RandomState random, StructureTemplateManager templateManager, long seed, ChunkAccess chunk, ChunkPos chunkPos, SectionPos sectionPos, CallbackInfoReturnable<Boolean> cir) {
        Structure structure = (Structure)entry.f_210026_().m_203334_();
        ResourceLocation structureId = registryAccess.m_175515_(Registries.f_256944_).m_7981_((Object)structure);
        LevelAccessor level = ((StructureManagerAccessor)manager).getLevel();
        ResourceLocation dimension = ((WorldGenLevel)level).m_6018_().m_46472_().m_135782_();
        Rule sRule = DimensionalStructureRestrict.STRUCTURE_RULES.get(structureId);
        if (sRule != null && sRule.isRestricted(dimension, true).booleanValue()) {
            cir.setReturnValue((Object)false);
            return;
        }
        Rule dRule = DimensionalStructureRestrict.DIMENSION_RULES.get(dimension);
        if (dRule != null && dRule.isRestricted(structureId, true).booleanValue()) {
            cir.setReturnValue((Object)false);
            return;
        }
    }
}

