/*
 * Decompiled with CFR 0.152.
 */
package com.dark_lion_jp.light_level_2025;

import com.dark_lion_jp.light_level_2025.LightLevel2025;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class LLWorldRenderer {
    private static final int TEXT_COLOR_DANGER = 0xFF4040;
    private static final int TEXT_COLOR_NEUTRAL = 0xFFFFFF;
    private static final int TEXT_COLOR_SAFE = 0x40FF40;
    private static final int TEXT_COLOR_WARNING = 0xFFFF40;
    private static final float TEXT_OFFSET_Y_BASE = 0.1f;
    private static final float TEXT_SCALE_FOR_DEBUG = 0.020833334f;
    private static final float TEXT_SCALE_NORMAL = 0.03125f;
    private static final int RENDER_DISTANCE_HORIZONTAL = 16;
    private static final int RENDER_DISTANCE_VERTICAL = 8;
    private static final List<class_2248> BLOCKS_TO_EXCLUDE_RENDERING = Arrays.asList(class_2246.field_10499, class_2246.field_9987, class_2246.field_10525, class_2246.field_10395, class_2246.field_10263);
    private static final List<class_2248> BLOCKS_BELOW_ALLOWING_SPAWN_EXCEPTION = Arrays.asList(class_2246.field_37576, class_2246.field_10030, class_2246.field_10114);

    private static void drawLightLevelText(class_1937 world, class_4587 matrices, class_327 textRenderer, class_4597.class_4598 bufferSource, class_2338 positionToDrawAt, Quaternionf cameraRotation, int blockLightLevel, int skyLightLevel, boolean shouldShowBothValues, int textColor, float textScale) {
        matrices.method_22903();
        Object textToRender = shouldShowBothValues ? "\u25a0" + blockLightLevel + " \u2600" + skyLightLevel : String.valueOf(blockLightLevel);
        float textWidthScaled = (float)textRenderer.method_1727((String)textToRender) * textScale;
        Objects.requireNonNull(textRenderer);
        float textHeightScaled = 9.0f * textScale;
        class_2680 blockState = world.method_8320(positionToDrawAt);
        class_265 visualShape = blockState.method_26218((class_1922)world, positionToDrawAt);
        float textOffsetY = LLWorldRenderer.getTextOffsetY(visualShape, textWidthScaled, textHeightScaled);
        matrices.method_22904((double)positionToDrawAt.method_10263() + 0.5, (double)((float)positionToDrawAt.method_10264() + textOffsetY), (double)positionToDrawAt.method_10260() + 0.5);
        matrices.method_22907((Quaternionfc)cameraRotation);
        matrices.method_22905(textScale, -textScale, textScale);
        float textWidth = textRenderer.method_1727((String)textToRender);
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        class_2561 class_25612 = class_2561.method_30163((String)textToRender);
        float f = -textWidth / 2.0f;
        Objects.requireNonNull(textRenderer);
        textRenderer.method_27522(class_25612, f, (float)(-9) / 2.0f, textColor, true, positionMatrix, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        matrices.method_22909();
    }

    private static int getTextColor(class_1937 world, int blockLightLevel, int skyLightLevel) {
        if (world == null) {
            return 0xFFFFFF;
        }
        class_2960 currentDimension = world.method_27983().method_29177();
        int textColor = currentDimension.equals((Object)class_1937.field_25179.method_29177()) ? (blockLightLevel > 0 ? 0x40FF40 : (skyLightLevel > 7 ? 0xFFFF40 : 0xFF4040)) : (currentDimension.equals((Object)class_1937.field_25180.method_29177()) ? (blockLightLevel > 11 ? 0x40FF40 : 0xFF4040) : (currentDimension.equals((Object)class_1937.field_25181.method_29177()) ? (blockLightLevel > 0 ? 0x40FF40 : 0xFF4040) : 0xFFFFFF));
        return textColor;
    }

    private static float getTextOffsetY(class_265 visualShape, float textWidthScaled, float textHeightScaled) {
        float textMaxLength;
        class_238 blockBoundingBox;
        boolean textOverlapped;
        float textOffsetY = 0.1f;
        if (!visualShape.method_1110() && (textOverlapped = (blockBoundingBox = visualShape.method_1107()).method_1003((double)(0.5f - (textMaxLength = (float)Math.hypot(textWidthScaled, textHeightScaled)) / 2.0f), 0.0, (double)(0.5f - textMaxLength / 2.0f), (double)(0.5f + textMaxLength / 2.0f), (double)textHeightScaled, (double)(0.5f + textMaxLength / 2.0f)))) {
            textOffsetY += (float)blockBoundingBox.method_17940();
        }
        return textOffsetY;
    }

    public static void render(WorldRenderContext worldRenderContext) {
        if (!LightLevel2025.isEnabled()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null || client.field_1687 == null || client.field_1772 == null) {
            return;
        }
        class_4587 matrices = worldRenderContext.matrixStack();
        if (matrices == null) {
            return;
        }
        class_638 world = client.field_1687;
        class_327 gameTextRenderer = client.field_1772;
        class_4597.class_4598 bufferSource = client.method_22940().method_23000();
        class_4184 camera = worldRenderContext.camera();
        class_243 cameraPosition = camera.method_19326();
        Quaternionf cameraRotation = new Quaternionf((Quaternionfc)camera.method_23767());
        matrices.method_22903();
        matrices.method_22904(-cameraPosition.field_1352, -cameraPosition.field_1351, -cameraPosition.field_1350);
        boolean shouldShowBothValues = client.method_53526().method_53536();
        float textScale = shouldShowBothValues ? 0.020833334f : 0.03125f;
        class_746 player = client.field_1724;
        class_2338 playerPosition = player.method_24515();
        class_2338.class_2339 positionToRenderAt = playerPosition.method_25503();
        int renderRangeHorizontal = 16;
        int renderRangeVertical = 8;
        for (int offsetX = -renderRangeHorizontal; offsetX <= renderRangeHorizontal; ++offsetX) {
            for (int offsetZ = -renderRangeHorizontal; offsetZ <= renderRangeHorizontal; ++offsetZ) {
                for (int offsetY = -renderRangeVertical; offsetY <= renderRangeVertical; ++offsetY) {
                    positionToRenderAt.method_10103(playerPosition.method_10263() + offsetX, playerPosition.method_10264() + offsetY, playerPosition.method_10260() + offsetZ);
                    if (positionToRenderAt.method_10262((class_2382)playerPosition) > (double)(renderRangeHorizontal * renderRangeHorizontal) * 1.5 || !LLWorldRenderer.shouldRenderLightLevel((class_1937)world, (class_2338)positionToRenderAt)) continue;
                    int blockLightLevel = world.method_8314(class_1944.field_9282, (class_2338)positionToRenderAt);
                    int skyLightLevel = world.method_8314(class_1944.field_9284, (class_2338)positionToRenderAt);
                    int textColor = LLWorldRenderer.getTextColor((class_1937)world, blockLightLevel, skyLightLevel);
                    LLWorldRenderer.drawLightLevelText((class_1937)world, matrices, gameTextRenderer, bufferSource, (class_2338)positionToRenderAt, cameraRotation, blockLightLevel, skyLightLevel, shouldShowBothValues, textColor, textScale);
                }
            }
        }
        matrices.method_22909();
    }

    private static boolean shouldRenderLightLevel(class_1937 world, class_2338 positionToCheck) {
        if (world == null) {
            return false;
        }
        class_2680 blockStateAtPositionToCheck = world.method_8320(positionToCheck);
        class_2338 positionBelow = positionToCheck.method_10074();
        class_2680 blockStateBelow = world.method_8320(positionBelow);
        class_2248 blockBelow = blockStateBelow.method_26204();
        if (BLOCKS_TO_EXCLUDE_RENDERING.contains(blockBelow)) {
            return false;
        }
        if (!blockStateBelow.method_26225()) {
            return false;
        }
        if (!blockStateAtPositionToCheck.method_26220((class_1922)world, positionToCheck).method_1110()) {
            return false;
        }
        if (BLOCKS_BELOW_ALLOWING_SPAWN_EXCEPTION.contains(blockBelow)) {
            return true;
        }
        class_265 collisionShapeBelow = blockStateBelow.method_26220((class_1922)world, positionBelow);
        if (!collisionShapeBelow.method_20538(class_2350.field_11036).method_1110()) {
            class_238 upFaceBoundingBox = collisionShapeBelow.method_20538(class_2350.field_11036).method_1107();
            boolean coversFullXZ = class_3532.method_20390((double)upFaceBoundingBox.field_1323, (double)0.0) && class_3532.method_20390((double)upFaceBoundingBox.field_1320, (double)1.0) && class_3532.method_20390((double)upFaceBoundingBox.field_1321, (double)0.0) && class_3532.method_20390((double)upFaceBoundingBox.field_1324, (double)1.0);
            boolean hasSignificantY = upFaceBoundingBox.field_1325 > upFaceBoundingBox.field_1322;
            return coversFullXZ && hasSignificantY;
        }
        return false;
    }
}

