/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.bubble_boots.core;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class BBConfig {
    static final ModConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        Pair clientSpecPair = new ModConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ModConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.ConfigValue<Integer> maxSoapiness;
        public final ModConfigSpec.ConfigValue<Integer> soapRestoreAmt;
        public final ModConfigSpec.ConfigValue<Boolean> soapBlockRestoration;
        public final ModConfigSpec.ConfigValue<Boolean> bootCleaning;
        public final ModConfigSpec.ConfigValue<Boolean> armorerTrade;
        public final ModConfigSpec.ConfigValue<Boolean> slipAndSlide;

        Common(ModConfigSpec.Builder builder) {
            builder.push("items");
            builder.push("bubble_boots");
            this.maxSoapiness = builder.comment("# of bubble blocks that boots may produce before needing a recharge").define("Maximum soapiness", (Object)75);
            this.soapRestoreAmt = builder.comment("Amount of soapiness restored for each bar of soap used on boots").define("Restoration amount", (Object)25);
            this.soapBlockRestoration = builder.comment("Stepping on soap blocks restores soapiness to full.").define("Soap block full restore", true);
            this.bootCleaning = builder.comment("Standing in water or rain causes the boots to un-soap").define("Bubble boots wash off", false);
            this.slipAndSlide = builder.comment("Walking with soapy boats causes the player to slip, as if stepping on soap blocks").define("Slip and slide", false);
            builder.pop();
            builder.push("trading");
            this.armorerTrade = builder.comment("Armorers trade bubble boots in exchange for soap blocks, as an expert-level trade").define("Armorers sell bubble boots", true);
            builder.pop();
            builder.pop();
        }
    }

    public static class Client {
        public final ModConfigSpec.ConfigValue<Boolean> sudsyBoots;
        public final ModConfigSpec.ConfigValue<Integer> soapWarning;

        public Client(ModConfigSpec.Builder builder) {
            builder.push("particles");
            this.sudsyBoots = builder.comment("Do bubble boots emit sudsy particles while soapy").define("Sudsy boots", true);
            this.soapWarning = builder.comment("Boots with soapiness below this number start emitting more suds particles. Set to 0 for no warning threshold").define("Soapiness warning threshold", (Object)15);
            builder.pop();
        }
    }
}

