/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.bubble_boots.core.other;

import com.davigj.bubble_boots.common.item.BubbleBootsItem;
import com.davigj.bubble_boots.common.util.Constants;
import com.davigj.bubble_boots.core.BBConfig;
import com.davigj.bubble_boots.core.other.BBItemTags;
import com.davigj.bubble_boots.core.registry.BBItems;
import com.davigj.bubble_boots.core.registry.BBSounds;
import com.teamabnormals.blueprint.core.util.TradeUtil;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SoapBlock;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;

@EventBusSubscriber(modid="bubble_boots")
public class BBEvents {
    @SubscribeEvent
    public static void playerUse(PlayerInteractEvent.RightClickItem event) {
        int soapiness;
        ItemStack armorStack;
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (stack.is(BBItemTags.BUBBLE_RESTORERS) && (armorStack = player.getItemBySlot(EquipmentSlot.FEET)).getItem() instanceof BubbleBootsItem && (soapiness = armorStack.getDamageValue()) < Constants.MAX_SOAPINESS) {
            armorStack.setDamageValue(Math.min(Constants.MAX_SOAPINESS, soapiness + (Integer)BBConfig.COMMON.soapRestoreAmt.get()));
            ItemStack handStack = player.getItemInHand(event.getHand());
            player.swing(event.getHand());
            if (!player.getAbilities().instabuild) {
                handStack.shrink(1);
            }
            player.level().playSound(player, player.blockPosition(), (SoundEvent)BBSounds.BUBBLES.get(), SoundSource.PLAYERS, 1.0f, 1.0f + (float)(0.3 * (double)player.getRandom().nextFloat()));
            if (player.level().isClientSide && ((Boolean)BBConfig.CLIENT.sudsyBoots.get()).booleanValue()) {
                RandomSource rand = player.getRandom();
                for (int i = 0; i < 8; ++i) {
                    double x = player.getX() - 0.5;
                    double y = player.getY();
                    double z = player.getZ() - 0.5;
                    double d3 = (float)x + rand.nextFloat();
                    double d6 = (float)z + rand.nextFloat();
                    player.level().addParticle((ParticleOptions)ModParticles.SUDS_PARTICLE.get(), d3, y + 0.025, d6, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void villagerTrades(VillagerTradesEvent event) {
        if (((Boolean)BBConfig.COMMON.armorerTrade.get()).booleanValue()) {
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.ARMORER, (int)5, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(new ItemStack((ItemLike)((Block)ModRegistry.SOAP_BLOCK.get()).asItem(), 2), new ItemStack((ItemLike)Items.EMERALD, 26), new ItemStack((ItemLike)BBItems.BUBBLE_BOOTS.get(), 1), 3, 20, 5.0f)});
        }
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (entity2 instanceof Player) {
                return;
            }
            if (entity2.tickCount % 20 == 0 && entity2.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof BubbleBootsItem) {
                ItemStack stack = entity2.getItemBySlot(EquipmentSlot.FEET);
                int soapiness = stack.getDamageValue();
                if (entity2.level().isClientSide && ((Boolean)BBConfig.CLIENT.sudsyBoots.get()).booleanValue() && soapiness > 0) {
                    RandomSource rand = entity2.getRandom();
                    double x = entity2.getX() - 0.5;
                    double y = entity2.getY();
                    double z = entity2.getZ() - 0.5;
                    double d3 = (float)x + rand.nextFloat();
                    double d6 = (float)z + rand.nextFloat();
                    entity2.level().addParticle((ParticleOptions)ModParticles.SUDS_PARTICLE.get(), d3, y + 0.025, d6, 0.0, 0.0, 0.0);
                }
                if (((Boolean)BBConfig.COMMON.slipAndSlide.get()).booleanValue() && soapiness > 0) {
                    ((SoapBlock)ModRegistry.SOAP_BLOCK.get()).stepOn(entity2.level(), entity2.getOnPos(), ((Block)ModRegistry.SOAP_BLOCK.get()).defaultBlockState(), (Entity)entity2);
                }
            }
        }
    }
}

