/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.tillitbreaks.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import me.pajic.tillitbreaks.TIBUtil;
import me.pajic.tillitbreaks.compat.AccessorifyCompat;
import me.pajic.tillitbreaks.compat.CompatFlags;
import me.pajic.tillitbreaks.config.TIBConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.MutableTriple;

public class ItemTextRenderer {
    public static void render(GuiGraphics guiGraphics, Minecraft minecraft, PoseStack pose, Font font, ItemStack stack, int x, int y) {
        if (TIBUtil.shouldRenderText(minecraft.player, stack)) {
            float scale = TIBConfig.textScale * 0.5f;
            pose.pushPose();
            pose.translate((float)x, (float)y, 300.0f);
            pose.scale(scale, scale, 0.0f);
            if (ItemTextRenderer.shouldRenderDurability(stack)) {
                ItemTextRenderer.renderDurability(guiGraphics, font, scale, stack);
            }
            if (ItemTextRenderer.shouldRenderArrowCounter(stack)) {
                ItemTextRenderer.renderArrowCounter(minecraft, guiGraphics, font, scale, stack);
            }
            pose.popPose();
        }
    }

    private static void renderDurability(GuiGraphics guiGraphics, Font font, float scale, ItemStack stack) {
        String durability = String.valueOf(stack.getMaxDamage() - stack.getDamageValue());
        float offset = TIBConfig.showDurabilityBar ? 2.5f / scale : 0.0f;
        int i = stack.getMaxDamage();
        float f = Math.max(0.0f, ((float)i - (float)stack.getDamageValue()) / (float)i);
        int color = TIBConfig.showDurabilityNumberIfFull && stack.getDamageValue() == 0 ? -1 : Mth.hsvToRgb((float)(f / 3.0f), (float)TIBConfig.durabilityNumberColorSaturation, (float)1.0f);
        int n = (int)(16.0f / scale - (float)font.width(durability) + scale * 0.33f);
        float f2 = 16.0f / scale;
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, durability, n, (int)(f2 - 9.0f - offset + scale), color, TIBConfig.textShadow);
    }

    private static void renderArrowCounter(Minecraft minecraft, GuiGraphics guiGraphics, Font font, float scale, ItemStack stack) {
        Inventory inventory = minecraft.player.getInventory();
        MutableTriple arrows = MutableTriple.of((Object)0, (Object)0, (Object)false);
        if (CompatFlags.ACCESSORIFY_LOADED) {
            AccessorifyCompat.addArrowsFromArrowSlots(minecraft.player, (MutableTriple<Integer, Integer, Boolean>)arrows);
        }
        TIBUtil.addArrowsFromContainer((Container)inventory, (MutableTriple<Integer, Integer, Boolean>)arrows);
        int arrowCounter = (Integer)arrows.getLeft();
        int specialArrowCounter = (Integer)arrows.getMiddle();
        boolean hasNormalArrows = (Boolean)arrows.getRight();
        Object totalArrows = String.valueOf(arrowCounter);
        if (TIBUtil.hasInfinity(minecraft.player, stack)) {
            if (CompatFlags.INFINITY_FIX_PRESENT) {
                if (arrowCounter == 0) {
                    totalArrows = "\u221e";
                } else if (arrowCounter > 0) {
                    totalArrows = specialArrowCounter > 0 ? "\u221e+" + specialArrowCounter : "\u221e";
                }
            } else if (arrowCounter > 0 && hasNormalArrows) {
                totalArrows = specialArrowCounter > 0 ? "\u221e+" + specialArrowCounter : "\u221e";
            }
        }
        guiGraphics.drawString(font, (String)totalArrows, (int)(16.0f / scale - (float)font.width((String)totalArrows) + scale * 0.33f), (int)(0.5f / scale), -1, TIBConfig.textShadow);
    }

    private static boolean shouldRenderDurability(ItemStack stack) {
        return TIBConfig.showDurabilityNumber && (TIBConfig.showDurabilityNumberIfFull && !stack.isDamaged() || stack.isDamaged());
    }

    private static boolean shouldRenderArrowCounter(ItemStack stack) {
        return TIBConfig.showArrowCount && (stack.getItem() instanceof BowItem || stack.getItem() instanceof CrossbowItem);
    }
}

