/*
 * Decompiled with CFR 0.152.
 */
package it.escanortargaryen.roadsideshop.classes;

import it.escanortargaryen.roadsideshop.InternalUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class SellingItem {
    private final ItemStack item;
    private final ItemStack withPriceSeller;
    private final ItemStack withPriceBuyer;
    private final ItemStack forNewspaper;
    private final ItemStack withPriceAndSponsorSeller;
    private final ItemStack withPriceAndSponsorBuyer;
    private final int slot;
    private final double price;
    private final UUID playerUUID;

    public SellingItem(@NotNull ItemStack item, int slot, double price, @NotNull UUID playerOwner) {
        Objects.requireNonNull(item);
        Objects.requireNonNull(playerOwner);
        this.item = item;
        this.slot = slot;
        this.price = price;
        this.playerUUID = playerOwner;
        ItemMeta m = item.getItemMeta();
        Objects.requireNonNull(m);
        ArrayList<String> p = new ArrayList<String>();
        if (m.getLore() != null) {
            p.addAll(m.getLore());
        }
        p.addAll(InternalUtil.CONFIGMANAGER.getItemSaleSeller(price));
        m.setLore(p);
        ItemStack h = item.clone();
        h.setItemMeta(m);
        this.withPriceSeller = h;
        m = item.getItemMeta();
        p = new ArrayList();
        if (m.getLore() != null) {
            p.addAll(m.getLore());
        }
        p.addAll(InternalUtil.CONFIGMANAGER.getItemSaleSellerSponsor(price));
        m.setLore(p);
        h = item.clone();
        h.setItemMeta(m);
        this.withPriceAndSponsorSeller = h;
        m = item.getItemMeta();
        p = new ArrayList();
        if (m.getLore() != null) {
            p.addAll(m.getLore());
        }
        p.addAll(InternalUtil.CONFIGMANAGER.getItemSaleBuyer(price));
        m.setLore(p);
        h = item.clone();
        h.setItemMeta(m);
        this.withPriceBuyer = h;
        m = item.getItemMeta();
        p = new ArrayList();
        if (m.getLore() != null) {
            p.addAll(m.getLore());
        }
        p.addAll(InternalUtil.CONFIGMANAGER.getItemSaleBuyerSponsor(price));
        m.setLore(p);
        h = item.clone();
        h.setItemMeta(m);
        this.withPriceAndSponsorBuyer = h;
        String name = Bukkit.getOfflinePlayer((UUID)this.playerUUID).getName();
        m = item.getItemMeta();
        p = new ArrayList();
        if (m.getLore() != null) {
            p.addAll(m.getLore());
        }
        p.addAll(InternalUtil.CONFIGMANAGER.getLoreForNewspaper(price, name));
        m.setLore(p);
        h = item.clone();
        h.setItemMeta(m);
        this.forNewspaper = h;
    }

    public ItemStack getWithPriceBuyer() {
        return this.withPriceBuyer.clone();
    }

    public ItemStack getWithPriceAndSponsorBuyer() {
        return this.withPriceAndSponsorBuyer.clone();
    }

    public ItemStack getWithPriceAndSponsorSeller() {
        return this.withPriceAndSponsorSeller.clone();
    }

    public ItemStack getWithPriceSeller() {
        return this.withPriceSeller.clone();
    }

    public ItemStack getItem() {
        return this.item;
    }

    public ItemStack getForNewspaper() {
        return this.forNewspaper;
    }

    public int getSlot() {
        return this.slot;
    }

    public double getPrice() {
        return this.price;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }
}

