/*
 * Decompiled with CFR 0.152.
 */
package it.escanortargaryen.roadsideshop.db;

import com.google.common.base.Preconditions;
import it.escanortargaryen.roadsideshop.bstat.bukkit.Metrics;
import it.escanortargaryen.roadsideshop.bstat.charts.SingleLineChart;
import it.escanortargaryen.roadsideshop.classes.SellingItem;
import it.escanortargaryen.roadsideshop.classes.Shop;
import it.escanortargaryen.roadsideshop.db.ItemSerializer;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sqlite.SQLiteConfig;

public class DatabaseManager {
    private final Connection connection;
    private int newshops = 0;
    private static final ArrayList<Shop> cachedShops = new ArrayList();

    public DatabaseManager(@NotNull File dbFile, @Nullable Metrics metrics) throws Exception {
        Preconditions.checkNotNull((Object)dbFile, (Object)"Database file is null.");
        if (!dbFile.exists() && !dbFile.createNewFile()) {
            throw new IOException("Cannot create the database file.");
        }
        Class.forName("org.sqlite.JDBC");
        SQLiteConfig config = new SQLiteConfig();
        config.enforceForeignKeys(true);
        config.setEncoding(SQLiteConfig.Encoding.UTF8);
        config.setSynchronous(SQLiteConfig.SynchronousMode.FULL);
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(dbFile), config.toProperties());
        this.setUp();
        if (metrics != null) {
            metrics.addCustomChart(new SingleLineChart("new_shops", () -> {
                int t = this.newshops;
                this.newshops = 0;
                return t;
            }));
        }
    }

    public void setUp() throws SQLException {
        try (Statement statement = this.connection.createStatement();){
            statement.addBatch("CREATE TABLE IF NOT EXISTS `Players` (`UUID` TEXT NOT NULL PRIMARY KEY , `Name` TEXT NOT NULL);");
            statement.addBatch("CREATE TABLE IF NOT EXISTS `Messages` (`Text` TEXT NOT NULL, `Key` INTEGER PRIMARY KEY AUTOINCREMENT, `UUID` TEXT NOT NULL, FOREIGN KEY(`UUID`) REFERENCES `Shop`(`UUID`) ON DELETE CASCADE ON UPDATE CASCADE);");
            statement.addBatch("CREATE TABLE IF NOT EXISTS `Shop` (`UUID` TEXT PRIMARY KEY NOT NULL,`Sponsor` TEXT,`LastSponsor` INT DEFAULT 0 NOT NULL, FOREIGN KEY(`UUID`) REFERENCES `Players`(`UUID`) ON DELETE CASCADE ON UPDATE CASCADE);");
            statement.addBatch("CREATE TABLE IF NOT EXISTS `Items` (`Item` TEXT NOT NULL,`Slot` INT NOT NULL,`Price` REAL NOT NULL,`Shop` INT NOT NULL, PRIMARY KEY(`Shop`,`Slot`), FOREIGN KEY(`Shop`) REFERENCES `Shop`(`UUID`) ON DELETE CASCADE ON UPDATE CASCADE);");
            statement.executeBatch();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Shop getShop(@NotNull UUID player, boolean saveInCache) {
        Objects.requireNonNull(player);
        for (Shop sh : cachedShops) {
            if (!sh.getPlayerUUID().equals(player)) continue;
            return sh;
        }
        if (!this.isRegistered(player)) {
            return null;
        }
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT * FROM `Shop` WHERE `UUID`=?;");){
            ps.setString(1, player.toString());
            ResultSet r = ps.executeQuery();
            if (r.next()) {
                ArrayList<SellingItem> i = this.getItems(player);
                SellingItem sponsor = null;
                String s = r.getString("Sponsor");
                if (s != null) {
                    int slot = Integer.parseInt(s);
                    for (SellingItem ii : i) {
                        if (slot != ii.getSlot()) continue;
                        sponsor = ii;
                    }
                }
                Shop shop3 = new Shop(player, Objects.requireNonNull(this.getPlayerName(player)), this.getOffMessage(player), sponsor, i, r.getLong("LastSponsor"));
                if (saveInCache) {
                    cachedShops.add(shop3);
                }
                Shop shop2 = shop3;
                return shop2;
            }
            this.createShop(player);
            ++this.newshops;
            Shop shop4 = new Shop(player, this.getPlayerName(player));
            if (saveInCache) {
                cachedShops.add(shop4);
            }
            Shop shop = shop4;
            return shop;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static ArrayList<Shop> getCachedShops() {
        return new ArrayList<Shop>(cachedShops);
    }

    public boolean hasShop(@NotNull UUID player) {
        Objects.requireNonNull(player);
        return this.isRegistered(player);
    }

    public ArrayList<Shop> getAllShops() {
        ArrayList<Shop> ret = new ArrayList<Shop>();
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT `UUID` FROM `Shop`;");){
            ResultSet r = ps.executeQuery();
            while (r.next()) {
                ret.add(this.getShop(UUID.fromString(r.getString("UUID")), false));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void updateShop(@NotNull Shop shop) {
        Objects.requireNonNull(shop);
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT * FROM `Shop` WHERE `UUID`=?;");){
            ps.setString(1, shop.getPlayerUUID().toString());
            ResultSet r = ps.executeQuery();
            if (r.next()) {
                String sponsor = null;
                if (shop.getSponsor() != null) {
                    sponsor = "" + shop.getSponsor().getSlot();
                }
                PreparedStatement psInsert = this.connection.prepareStatement("DELETE FROM `Shop` WHERE `UUID`=?;");
                psInsert.setString(1, shop.getPlayerUUID().toString());
                psInsert.executeUpdate();
                psInsert = this.connection.prepareStatement("INSERT INTO `Shop`(`UUID`, `Sponsor`, `LastSponsor`) VALUES(?,?,?);");
                psInsert.setString(1, shop.getPlayerUUID().toString());
                psInsert.setString(2, null);
                psInsert.setLong(3, shop.getLastSponsor());
                psInsert.executeUpdate();
                for (String string : shop.getOffMessages()) {
                    this.addOffMessage(shop.getPlayerUUID(), string);
                }
                for (SellingItem sellingItem : shop.getItems()) {
                    this.addItem(shop.getPlayerUUID(), sellingItem);
                }
                psInsert = this.connection.prepareStatement("UPDATE Shop SET `Sponsor` = ? WHERE `UUID` = ?;");
                psInsert.setString(1, sponsor);
                psInsert.setString(2, shop.getPlayerUUID().toString());
                psInsert.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<SellingItem> getItems(@NotNull UUID player) {
        Objects.requireNonNull(player);
        ArrayList<SellingItem> ret = new ArrayList<SellingItem>();
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT * FROM `Items` WHERE `Shop`=?;");){
            ps.setString(1, player.toString());
            ResultSet r = ps.executeQuery();
            while (r.next()) {
                ret.add(new SellingItem(ItemSerializer.read(r.getString("Item"))[0], r.getInt("Slot"), r.getDouble("Price"), player));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void deleteAllItems(@NotNull UUID player) {
        Objects.requireNonNull(player);
        try (PreparedStatement ps = this.connection.prepareStatement("DELETE FROM `Items` WHERE `Shop`=?;");){
            ps.setString(1, player.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteAllMessages(@NotNull UUID player) {
        Objects.requireNonNull(player);
        try (PreparedStatement ps = this.connection.prepareStatement("DELETE FROM `Messages` WHERE `UUID`=?;");){
            ps.setString(1, player.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<String> getOffMessage(@NotNull UUID player) {
        Objects.requireNonNull(player);
        ArrayList<String> ret = new ArrayList<String>();
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT * FROM `Messages` WHERE `UUID`=?;");){
            ps.setString(1, player.toString());
            ResultSet r = ps.executeQuery();
            while (r.next()) {
                ret.add(r.getString("Text"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private void createShop(@NotNull UUID player) {
        Objects.requireNonNull(player);
        try {
            PreparedStatement psInsert = this.connection.prepareStatement("INSERT INTO `Shop`(`UUID`, `Sponsor`) VALUES(?,?);");
            psInsert.setString(1, player.toString());
            psInsert.setString(2, null);
            psInsert.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void addItem(@NotNull UUID player, @NotNull SellingItem sellingItem) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(sellingItem);
        try {
            PreparedStatement psInsert = this.connection.prepareStatement("INSERT INTO `Items`(`Shop`, `Item`,`Slot`,`Price`) VALUES(?,?,?,?);");
            psInsert.setString(1, player.toString());
            psInsert.setString(2, ItemSerializer.write(sellingItem.getItem()));
            psInsert.setInt(3, sellingItem.getSlot());
            psInsert.setDouble(4, sellingItem.getPrice());
            psInsert.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private void addOffMessage(@NotNull UUID player, @NotNull String text) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(text);
        try {
            PreparedStatement psInsert = this.connection.prepareStatement("INSERT INTO `Messages`(`UUID`, `Text`) VALUES(?,?);");
            psInsert.setString(1, player.toString());
            psInsert.setString(2, text);
            psInsert.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String getPlayerName(@NotNull UUID player) {
        Objects.requireNonNull(player);
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT * FROM `Players` WHERE `UUID`=?;");){
            ps.setString(1, player.toString());
            ResultSet r = ps.executeQuery();
            if (!r.next()) return null;
            String string = r.getString(2);
            return string;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    public boolean isRegistered(@NotNull UUID player) {
        boolean bl;
        block8: {
            Objects.requireNonNull(player);
            PreparedStatement ps = this.connection.prepareStatement("SELECT * FROM `Players` WHERE `UUID`=?;");
            try {
                ps.setString(1, player.toString());
                ResultSet r = ps.executeQuery();
                bl = r.next();
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            ps.close();
        }
        return bl;
    }

    public void addPlayer(@NotNull Player player) {
        Objects.requireNonNull(player);
        try {
            PreparedStatement psInsert = this.connection.prepareStatement("INSERT OR IGNORE INTO `Players`(`UUID`, `Name`) VALUES(?,?);");
            psInsert.setString(1, player.getUniqueId().toString());
            psInsert.setString(2, player.getName());
            psInsert.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void close() throws SQLException {
        this.connection.close();
    }
}

