/*
 * Decompiled with CFR 0.152.
 */
package it.escanortargaryen.roadsideshop.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public final class ItemStackSerializerRefl {
    public static final String completeVersion = Bukkit.getServer().getClass().getName().split("\\.")[3];
    public static final int version = Integer.valueOf(completeVersion.split("_")[1]);
    private static Class<?> nbtTagCompoundClass = ItemStackSerializerRefl.getNMSClass("NBTTagCompound");
    private static Class<?> nmsItemStackClass = ItemStackSerializerRefl.getNMSClass("ItemStack");
    private static Class<?> nbtCompressedStreamToolsClass = ItemStackSerializerRefl.getNMSClass("NBTCompressedStreamTools");
    private static Class<?> craftItemStackClass = ItemStackSerializerRefl.getCBClass("inventory.CraftItemStack");
    private static Constructor<?> nbtTagCompoundConstructor;
    private static Constructor<?> nmsItemStackContructor;
    private static Method aIn;
    private static Method aOut;
    private static Method createStack;
    private static Method asBukkitCopy;
    private static Method asNMSCopy;
    private static Method save;
    private static Method getTitle;
    private static final byte VERSION = 1;

    /*
     * Enabled aggressive exception aggregation
     */
    public static ItemStack deserializeItemStack(String data) {
        if (data == null || data.isEmpty()) {
            return new ItemStack(Material.AIR);
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(new BigInteger(data, 32).toByteArray());){
            ItemStack itemStack;
            try (DataInputStream dataInputStream = new DataInputStream(inputStream);){
                Object nbtTagCompound = aIn.invoke(null, dataInputStream);
                Object craftItemStack = ItemStackSerializerRefl.craftNMSItemStack(nbtTagCompound);
                itemStack = (ItemStack)asBukkitCopy.invoke(null, craftItemStack);
            }
            return itemStack;
        }
        catch (IOException | ReflectiveOperationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ItemStack[] deserializeItemStack(String[] data) {
        Validate.notNull((Object)data, (String)"Data cannot be null");
        ItemStack[] arr = new ItemStack[data.length];
        for (int i = 0; i < data.length; ++i) {
            arr[i] = ItemStackSerializerRefl.deserializeItemStack(data[i]);
        }
        return arr;
    }

    public static List<ItemStack> deserializeItemStack(List<String> data) {
        Validate.notNull(data, (String)"Data cannot be null");
        ArrayList<ItemStack> l = new ArrayList<ItemStack>(data.size());
        for (String s : data) {
            l.add(ItemStackSerializerRefl.deserializeItemStack(s));
        }
        return l;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String serializeItemStack(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return "";
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            try (DataOutputStream dataOutput = new DataOutputStream(outputStream);){
                Object nbtTagCompound = nbtTagCompoundConstructor.newInstance(new Object[0]);
                Object nmsItemStack = asNMSCopy.invoke(null, item);
                save.invoke(nmsItemStack, nbtTagCompound);
                aOut.invoke(null, nbtTagCompound, dataOutput);
                string = new BigInteger(1, outputStream.toByteArray()).toString(32);
            }
            return string;
        }
        catch (IOException | ReflectiveOperationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] serializeItemStack(ItemStack[] items) {
        Validate.notNull((Object)items, (String)"Items cannot be null");
        String[] arr = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            arr[i] = ItemStackSerializerRefl.serializeItemStack(items[i]);
        }
        return arr;
    }

    public static List<String> serializeItemStack(List<ItemStack> items) {
        Validate.notNull(items, (String)"Items cannot be null");
        ArrayList<String> l = new ArrayList<String>(items.size());
        for (ItemStack s : items) {
            l.add(ItemStackSerializerRefl.serializeItemStack(s));
        }
        return l;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String serializeInventory(Inventory inv) {
        Validate.notNull((Object)inv, (String)"Inventory cannot be null");
        Validate.isTrue((inv.getType() == InventoryType.CHEST ? 1 : 0) != 0, (String)("Illegal inventory type " + inv.getType().toString() + "(expected CHEST)."));
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            try (DataOutputStream dataOutput = new DataOutputStream(outputStream);){
                dataOutput.writeByte(1);
                dataOutput.writeByte(inv.getSize());
                if (version < 14) {
                    dataOutput.writeBoolean(true);
                    dataOutput.writeUTF((String)getTitle.invoke((Object)inv, new Object[0]));
                } else {
                    dataOutput.writeBoolean(false);
                }
                for (int i = 0; i < inv.getSize(); ++i) {
                    ItemStack it = inv.getItem(i);
                    if (it == null || it.getType() == Material.AIR) continue;
                    dataOutput.writeByte(i);
                    dataOutput.writeUTF(ItemStackSerializerRefl.serializeItemStack(it));
                }
                dataOutput.writeByte(-1);
                string = new BigInteger(1, outputStream.toByteArray()).toString(32);
            }
            return string;
        }
        catch (IOException | ReflectiveOperationException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static InventoryMap deserializeInventory(String data) {
        Validate.notNull((Object)data, (String)"Data cannot be null");
        Validate.isTrue((!data.isEmpty() ? 1 : 0) != 0, (String)"Data cannot be empty");
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(new BigInteger(data, 32).toByteArray());){
            InventoryMap inventoryMap;
            try (DataInputStream dataInputStream = new DataInputStream(inputStream);){
                byte slot;
                byte version = dataInputStream.readByte();
                if (version != 1) {
                    throw new DeserializationException("Invalid inventory version \"" + version + "\". The only supported version is the  \"1\".");
                }
                byte size = dataInputStream.readByte();
                boolean present = dataInputStream.readBoolean();
                String title = present ? dataInputStream.readUTF() : null;
                InventoryMap map = new InventoryMap(size, size, title);
                while ((slot = dataInputStream.readByte()) != -1 && slot < size) {
                    ItemStack it = ItemStackSerializerRefl.deserializeItemStack(dataInputStream.readUTF());
                    map.put(Integer.valueOf(slot), it);
                }
                inventoryMap = map;
            }
            return inventoryMap;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ItemStack deserializeObject(Object obj) throws DeserializationException {
        if (obj instanceof ItemStack) {
            return (ItemStack)obj;
        }
        if (obj instanceof String) {
            return ItemStackSerializerRefl.deserializeItemStack((String)obj);
        }
        throw new DeserializationException("Couldn't deserialize object");
    }

    private static Class<?> getNMSClass(String name) {
        try {
            return Class.forName("net.minecraft.server." + completeVersion + "." + name);
        }
        catch (ClassNotFoundException var3) {
            var3.printStackTrace();
            return null;
        }
    }

    public static Class<?> getCBClass(String name) {
        try {
            return Class.forName("org.bukkit.craftbukkit." + completeVersion + "." + name);
        }
        catch (ClassNotFoundException var3) {
            var3.printStackTrace();
            return null;
        }
    }

    private static Object craftNMSItemStack(Object nbtTagCompound) throws ReflectiveOperationException {
        switch (version) {
            case 8: 
            case 9: 
            case 10: {
                return createStack.invoke(null, nbtTagCompound);
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return nmsItemStackContructor.newInstance(nbtTagCompound);
            }
        }
        return null;
    }

    static {
        try {
            nbtTagCompoundConstructor = nbtTagCompoundClass.getDeclaredConstructor(new Class[0]);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        try {
            aIn = nbtCompressedStreamToolsClass.getMethod("a", DataInputStream.class);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        try {
            aOut = nbtCompressedStreamToolsClass.getMethod("a", nbtTagCompoundClass, DataOutput.class);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        try {
            switch (version) {
                case 8: 
                case 9: 
                case 10: {
                    createStack = nmsItemStackClass.getMethod("createStack", nbtTagCompoundClass);
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    nmsItemStackContructor = nmsItemStackClass.getDeclaredConstructor(nbtTagCompoundClass);
                    nmsItemStackContructor.setAccessible(true);
                    break;
                }
            }
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        try {
            asBukkitCopy = craftItemStackClass.getMethod("asBukkitCopy", nmsItemStackClass);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        try {
            asNMSCopy = craftItemStackClass.getMethod("asNMSCopy", ItemStack.class);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        try {
            save = nmsItemStackClass.getMethod("save", nbtTagCompoundClass);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        if (version < 14) {
            try {
                getTitle = Inventory.class.getDeclaredMethod("getTitle", new Class[0]);
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }
    }

    public static final class DeserializationException
    extends RuntimeException {
        private static final long serialVersionUID = 5732914764163243723L;

        public DeserializationException() {
        }

        public DeserializationException(String message, Throwable cause) {
            super(message, cause);
        }

        public DeserializationException(String message) {
            super(message);
        }

        public DeserializationException(Throwable cause) {
            super(cause);
        }
    }

    public static final class InventoryMap
    extends HashMap<Integer, ItemStack> {
        private static final long serialVersionUID = -2375620583757374598L;
        private final int inventorySize;
        private String title;

        public void setTitle(String title) {
            Validate.isTrue((version > 13 ? 1 : 0) != 0, (String)"Title cannot be changed in 1.8-1.13");
            this.title = title;
        }

        InventoryMap() {
            throw new UnsupportedOperationException("Illegal use of constructor");
        }

        InventoryMap(int inventorySize, String title) {
            this.inventorySize = inventorySize;
            this.title = title;
        }

        InventoryMap(int initialCapacity, float loadFactor, int inventorySize, String title) {
            super(initialCapacity, loadFactor);
            this.inventorySize = inventorySize;
            this.title = title;
        }

        InventoryMap(int initialCapacity, int inventorySize, String title) {
            super(initialCapacity);
            this.inventorySize = inventorySize;
            this.title = title;
        }

        InventoryMap(InventoryMap m, String title) {
            super(m);
            this.inventorySize = m.getInventorySize();
            this.title = title;
        }

        public int getInventorySize() {
            return this.inventorySize;
        }

        public String getTitle() {
            return this.title;
        }

        public Inventory toInventory(InventoryHolder owner) {
            Inventory inv = this.title != null ? Bukkit.createInventory((InventoryHolder)owner, (int)this.inventorySize, (String)this.title) : Bukkit.createInventory((InventoryHolder)owner, (int)this.inventorySize);
            for (Map.Entry e : this.entrySet()) {
                inv.setItem(((Integer)e.getKey()).intValue(), e.getValue() == null ? null : ((ItemStack)e.getValue()).clone());
            }
            return inv;
        }

        public ItemStack[] getContents() {
            ItemStack[] arr = new ItemStack[this.size()];
            int i = 0;
            for (ItemStack it : this.values()) {
                arr[i++] = it.clone();
            }
            return arr;
        }

        public ItemStack[] getStorageContents() {
            ItemStack[] arr = new ItemStack[this.inventorySize];
            for (int i = 0; i < this.inventorySize; ++i) {
                ItemStack it = (ItemStack)this.get(i);
                arr[i] = it == null ? new ItemStack(Material.AIR) : it.clone();
            }
            return arr;
        }
    }
}

