/*
 * Decompiled with CFR 0.152.
 */
package it.escanortargaryen.roadsideshop.inventory;

import it.escanortargaryen.roadsideshop.InternalUtil;
import it.escanortargaryen.roadsideshop.RoadsideShops;
import it.escanortargaryen.roadsideshop.anvilgui.AnvilGUI;
import it.escanortargaryen.roadsideshop.classes.SellingItem;
import it.escanortargaryen.roadsideshop.classes.Shop;
import it.escanortargaryen.roadsideshop.classes.ViewMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class SaleSettings
implements InventoryHolder,
Listener {
    private final Shop shop;
    private final ItemStack itemToSell;
    private final int slotNumber;
    private boolean isPriceSet = false;
    private boolean isSponsoring = false;
    private boolean settingPrice = false;
    private boolean exit = false;
    private double price = 0.0;

    public SaleSettings(@NotNull Shop shop, @NotNull ItemStack itemToSell, @NotNull Player player, int slotNumber) {
        Objects.requireNonNull(shop);
        Objects.requireNonNull(itemToSell);
        Objects.requireNonNull(player);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)RoadsideShops.INSTANCE);
        this.shop = shop;
        this.slotNumber = slotNumber;
        this.itemToSell = itemToSell.clone();
        player.openInventory(this.getInventory());
    }

    @NotNull
    public Inventory getInventory() {
        ItemStack priceButton;
        ItemStack sellButton;
        Inventory inv = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)InternalUtil.CONFIGMANAGER.getItemSettingsTitle());
        ItemStack item = this.itemToSell.clone();
        inv.setItem(10, item);
        inv.setItem(15, this.shop.generateMapItem(this.isSponsoring, null));
        if (this.isPriceSet) {
            sellButton = new ItemStack(Material.GREEN_WOOL);
            ItemMeta mw = sellButton.getItemMeta();
            Objects.requireNonNull(mw).setDisplayName(InternalUtil.CONFIGMANAGER.getSellButtonTitle());
            mw.setLore(InternalUtil.CONFIGMANAGER.getSellButtonLore());
            sellButton.setItemMeta(mw);
            priceButton = new ItemStack(Material.NAME_TAG);
            mw = priceButton.getItemMeta();
            Objects.requireNonNull(mw).setDisplayName(InternalUtil.CONFIGMANAGER.getPriceButtonTitle(this.price));
            mw.setLore(InternalUtil.CONFIGMANAGER.getPriceButtonLore(this.price));
            priceButton.setItemMeta(mw);
        } else {
            sellButton = new ItemStack(Material.RED_WOOL);
            ItemMeta mw = sellButton.getItemMeta();
            Objects.requireNonNull(mw).setDisplayName(InternalUtil.CONFIGMANAGER.getSellButtonTitleNotSet());
            mw.setLore(InternalUtil.CONFIGMANAGER.getSellButtonLoreNotSet());
            sellButton.setItemMeta(mw);
            priceButton = new ItemStack(Material.NAME_TAG);
            mw = priceButton.getItemMeta();
            Objects.requireNonNull(mw).setDisplayName(InternalUtil.CONFIGMANAGER.getPriceButtonTitleNotSet());
            mw.setLore(InternalUtil.CONFIGMANAGER.getPriceButtonLoreNotSet());
            priceButton.setItemMeta(mw);
        }
        inv.setItem(24, sellButton);
        inv.setItem(6, priceButton);
        return inv;
    }

    @EventHandler
    private void onClick(InventoryClickEvent e) {
        Inventory topInventory = InternalUtil.getTopInventory(e);
        final Player player = (Player)e.getWhoClicked();
        if (topInventory.getHolder() != this) {
            return;
        }
        e.setCancelled(true);
        if (e.getClickedInventory() == null || e.getCurrentItem() == null || e.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        if (e.getClickedInventory().getHolder() != this) {
            return;
        }
        if (e.getSlot() == 6) {
            this.settingPrice = true;
            player.closeInventory();
            new AnvilGUI.Builder().onClose((AnvilGUI.StateSnapshot p) -> {
                this.settingPrice = false;
                new BukkitRunnable((AnvilGUI.StateSnapshot)p){
                    final /* synthetic */ AnvilGUI.StateSnapshot val$p;
                    {
                        this.val$p = stateSnapshot;
                    }

                    public void run() {
                        Player player = this.val$p.getPlayer();
                        player.openInventory(SaleSettings.this.getInventory());
                    }
                }.runTask((Plugin)RoadsideShops.INSTANCE);
            }).onClick((Integer slot, AnvilGUI.StateSnapshot stateSnapshot) -> {
                if (slot != 2) {
                    return Collections.emptyList();
                }
                try {
                    this.price = Double.parseDouble(stateSnapshot.getText());
                    this.isPriceSet = this.price >= 0.0;
                    return List.of(AnvilGUI.ResponseAction.close());
                }
                catch (NumberFormatException ff) {
                    return List.of(AnvilGUI.ResponseAction.replaceInputText(InternalUtil.CONFIGMANAGER.getWrongPrice()));
                }
            }).itemLeft(new ItemStack(Material.GOLD_BLOCK)).text(".").title(InternalUtil.CONFIGMANAGER.getAnvilTitle()).plugin((Plugin)RoadsideShops.INSTANCE).open(player);
        }
        if (e.getSlot() == 15) {
            if (this.shop.canSponsor()) {
                this.isSponsoring = !this.isSponsoring;
            }
            e.getInventory().setItem(15, this.shop.generateMapItem(this.isSponsoring, null));
        }
        if (e.getSlot() == 24 && this.isPriceSet) {
            SellingItem sellingItem = new SellingItem(this.itemToSell, this.slotNumber, this.price, this.shop.getPlayerUUID());
            this.shop.addItem(sellingItem, this.isSponsoring, true, player);
            this.exit = true;
            player.closeInventory();
            new BukkitRunnable(){

                public void run() {
                    SaleSettings.this.shop.openInventory(player, ViewMode.SELLER);
                }
            }.runTask((Plugin)RoadsideShops.INSTANCE);
        }
    }

    @EventHandler
    private void onClose(InventoryCloseEvent e) {
        if (e.getInventory().getHolder() == this) {
            final Player p = (Player)e.getPlayer();
            if (!this.settingPrice) {
                InventoryClickEvent.getHandlerList().unregister((Listener)this);
                InventoryCloseEvent.getHandlerList().unregister((Listener)this);
                p.closeInventory();
                new BukkitRunnable(){

                    public void run() {
                        SaleSettings.this.shop.openInventory(p, ViewMode.SELLER);
                    }
                }.runTask((Plugin)RoadsideShops.INSTANCE);
            }
            if (!this.exit && !this.settingPrice) {
                HashMap i = p.getInventory().addItem(new ItemStack[]{this.itemToSell});
                if (i.size() > 0) {
                    p.sendMessage(InternalUtil.CONFIGMANAGER.getFullInvDrop());
                }
                for (ItemStack t : i.values()) {
                    p.getWorld().dropItemNaturally(p.getLocation(), t);
                }
            }
            if (this.exit) {
                InventoryClickEvent.getHandlerList().unregister((Listener)this);
                InventoryCloseEvent.getHandlerList().unregister((Listener)this);
            }
        }
    }
}

