/*
 * Decompiled with CFR 0.152.
 */
package it.escanortargaryen.roadsideshop.managers;

import it.escanortargaryen.roadsideshop.InternalUtil;
import it.escanortargaryen.roadsideshop.RoadsideShops;
import it.escanortargaryen.roadsideshop.classes.Newspaper;
import it.escanortargaryen.roadsideshop.classes.Shop;
import it.escanortargaryen.roadsideshop.classes.ViewMode;
import it.escanortargaryen.roadsideshop.commandapi.CommandAPI;
import it.escanortargaryen.roadsideshop.commandapi.CommandAPIBukkitConfig;
import it.escanortargaryen.roadsideshop.commandapi.CommandAPICommand;
import it.escanortargaryen.roadsideshop.commandapi.CommandAPIConfig;
import it.escanortargaryen.roadsideshop.commandapi.arguments.AbstractArgument;
import it.escanortargaryen.roadsideshop.commandapi.arguments.Argument;
import it.escanortargaryen.roadsideshop.commandapi.arguments.AsyncPlayerProfileArgument;
import it.escanortargaryen.roadsideshop.commandapi.exceptions.WrapperCommandSyntaxException;
import it.escanortargaryen.roadsideshop.managers.ConfigManager;
import it.escanortargaryen.roadsideshop.managers.LibbyManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Commands {
    private static final String SHOPCOMMAND_PERMISSION = "roadsideshops.shopcommand";
    private static final String ADMIN_EDITSHOPS_PERMISSION = "roadsideshops.admin.editshops";
    private static final String NEWSPAPER_PERMISSION = "roadsideshops.newspapercommand";
    private Plugin plugin;

    public void enableCommands() {
        this.enableNewsPaperCommand();
        this.enableRoadSideCommand();
    }

    public void onLoad(Plugin plugin) {
        CommandAPIBukkitConfig config;
        this.plugin = plugin;
        try {
            if (LibbyManager.isMojangMapped()) {
                Class<?> lifecycleEventOwnerClass = Class.forName("io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner");
                Class<?> paperConfigClass = Class.forName("it.escanortargaryen.roadsideshop.commandapi.CommandAPIPaperConfig");
                config = (CommandAPIBukkitConfig)paperConfigClass.getDeclaredConstructor(lifecycleEventOwnerClass).newInstance(plugin);
            } else {
                Class<?> spigotConfigClass = Class.forName("it.escanortargaryen.roadsideshop.commandapi.CommandAPISpigotConfig");
                config = (CommandAPIBukkitConfig)spigotConfigClass.getDeclaredConstructor(JavaPlugin.class).newInstance(plugin);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Cannot create CommandAPI config", e);
        }
        CommandAPI.onLoad((CommandAPIConfig)((CommandAPIBukkitConfig)((CommandAPIBukkitConfig)config.verboseOutput(false)).silentLogs(true)).setNamespace(plugin.getName().toLowerCase(Locale.ENGLISH)));
        this.enableCommands();
    }

    public void onEnable() {
        CommandAPI.onEnable();
    }

    public void checkPermission(Player player, String permission) throws WrapperCommandSyntaxException {
        if (!player.hasPermission(permission)) {
            throw CommandAPI.failWithString((String)"Permission denied.");
        }
    }

    public String getUniqueIdMethodName() {
        return LibbyManager.isMojangMapped() ? "getId" : "getUniqueId";
    }

    public void manageAsyncPlayerProfileArgument(CompletableFuture<List<?>> profiles, final Player sender, final Consumer<OfflinePlayer> consumer) {
        ((CompletableFuture)profiles.thenAccept(profileList -> {
            final Object pl = profileList.getFirst();
            new BukkitRunnable(){

                public void run() {
                    try {
                        OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)((UUID)pl.getClass().getDeclaredMethod(Commands.this.getUniqueIdMethodName(), new Class[0]).invoke(pl, new Object[0])));
                        consumer.accept(op);
                    }
                    catch (ReflectiveOperationException e) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Error while trying to execute the command.");
                        throw new RuntimeException(e);
                    }
                }
            }.runTask(this.plugin);
        })).exceptionally(throwable -> {
            sender.sendMessage(InternalUtil.CONFIGMANAGER.getNoShop());
            return null;
        });
    }

    private void enableRoadSideCommand() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand(ConfigManager.SHOPCOMMAND).withRequirement(e -> e.hasPermission(SHOPCOMMAND_PERMISSION))).executesPlayer((p, objects) -> {
            this.checkPermission(p, SHOPCOMMAND_PERMISSION);
            Commands.openPersonalShop(p);
        })).register();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand(ConfigManager.SHOPCOMMAND).withRequirement(e -> e.hasPermission(SHOPCOMMAND_PERMISSION))).withArguments((AbstractArgument[])new Argument[]{new AsyncPlayerProfileArgument("shopOwner")})).executesPlayer((p, objects) -> {
            this.checkPermission(p, SHOPCOMMAND_PERMISSION);
            this.manageAsyncPlayerProfileArgument((CompletableFuture)objects.get(0), p, shopOwner -> {
                if (shopOwner != null) {
                    Commands.openPlayerShop(p, shopOwner);
                } else {
                    p.sendMessage(InternalUtil.CONFIGMANAGER.getNoShop());
                }
            });
        })).register();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("roadsideshopsadmin").withRequirement(e -> e.hasPermission(ADMIN_EDITSHOPS_PERMISSION))).withArguments((AbstractArgument[])new Argument[]{new AsyncPlayerProfileArgument("shopOwner")})).executesPlayer((p, objects) -> {
            this.checkPermission(p, ADMIN_EDITSHOPS_PERMISSION);
            this.manageAsyncPlayerProfileArgument((CompletableFuture)objects.get(0), p, shopOwner -> {
                if (shopOwner != null) {
                    Commands.openPlayerShopAsSeller(p, shopOwner);
                } else {
                    p.sendMessage(InternalUtil.CONFIGMANAGER.getNoShop());
                }
            });
        })).register();
    }

    private void enableNewsPaperCommand() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand(ConfigManager.NEWSPAPERCOMMAND).withRequirement(e -> e.hasPermission(NEWSPAPER_PERMISSION))).executesPlayer((player, objects) -> {
            this.checkPermission(player, NEWSPAPER_PERMISSION);
            CompletableFuture.runAsync(() -> {
                final ArrayList<Shop> shops = RoadsideShops.getAllShops();
                new BukkitRunnable(){

                    public void run() {
                        new Newspaper(shops, player);
                    }
                }.runTask((Plugin)RoadsideShops.INSTANCE);
            });
        })).register();
    }

    public static void openPersonalShop(final Player p) {
        CompletableFuture.runAsync(() -> {
            if (!RoadsideShops.hasShop(p.getUniqueId())) {
                RoadsideShops.getShop(p);
            }
            final Shop s = RoadsideShops.getShop(p);
            new BukkitRunnable(){

                public void run() {
                    s.openInventory(p, ViewMode.SELLER);
                }
            }.runTask((Plugin)RoadsideShops.INSTANCE);
        });
    }

    public static void openPlayerShop(final Player p, OfflinePlayer shopOwner) {
        CompletableFuture.runAsync(() -> {
            if (!RoadsideShops.hasShop(shopOwner.getUniqueId())) {
                new BukkitRunnable(){

                    public void run() {
                        p.sendMessage(InternalUtil.CONFIGMANAGER.getNoShop());
                    }
                }.runTask((Plugin)RoadsideShops.INSTANCE);
            } else if (p.getUniqueId().equals(shopOwner.getUniqueId())) {
                final Shop s = RoadsideShops.getShop(shopOwner.getUniqueId());
                new BukkitRunnable(){

                    public void run() {
                        s.openInventory(p, ViewMode.SELLER);
                    }
                }.runTask((Plugin)RoadsideShops.INSTANCE);
            } else {
                final Shop s = RoadsideShops.getShop(shopOwner.getUniqueId());
                new BukkitRunnable(){

                    public void run() {
                        s.openInventory(p, ViewMode.BUYER);
                    }
                }.runTask((Plugin)RoadsideShops.INSTANCE);
            }
        });
    }

    public static void openPlayerShopAsSeller(final Player p, OfflinePlayer shopOwner) {
        CompletableFuture.runAsync(() -> {
            if (!RoadsideShops.hasShop(shopOwner.getUniqueId())) {
                new BukkitRunnable(){

                    public void run() {
                        p.sendMessage(InternalUtil.CONFIGMANAGER.getNoShop());
                    }
                }.runTask((Plugin)RoadsideShops.INSTANCE);
            } else {
                final Shop s = RoadsideShops.getShop(shopOwner.getUniqueId());
                new BukkitRunnable(){

                    public void run() {
                        s.openInventory(p, ViewMode.SELLER);
                    }
                }.runTask((Plugin)RoadsideShops.INSTANCE);
            }
        });
    }
}

