/*
 * Decompiled with CFR 0.152.
 */
package it.escanortargaryen.roadsideshop.managers;

import it.escanortargaryen.libby.BukkitLibraryManager;
import it.escanortargaryen.libby.Library;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class LibbyManager {
    private BukkitLibraryManager bukkitLibraryManager;
    private String mojangMappedArtifactId = "commandapi-paper-shade";
    private String artifactId = "commandapi-spigot-shade";
    private String version = "11.0.0";
    private String checksum = "Fj53byvXMUNTOWVGshgqXxcvCz5Q7K9Ipk9LHlv+FNM=";
    private String checksumMappedArtifactId = "g0vXatzD0v726X589IJRv4LsUaANZsS5s7WQXMvWKds=";
    public static final String MINECRAFT_VERSION = Bukkit.getBukkitVersion().split("-")[0];
    public static final int VERSION = Integer.parseInt(MINECRAFT_VERSION.split("\\.")[1]);
    private static final boolean IS_PAPER = LibbyManager.classExists("io.papermc.paper.advancement.AdvancementDisplay");
    public static final int MINOR_VERSION;

    public static boolean isMojangMapped() {
        return IS_PAPER && (VERSION > 20 || VERSION == 20 && MINOR_VERSION >= 6);
    }

    public static boolean classExists(@NotNull String className) {
        Objects.requireNonNull(className, "ClassName cannot be null.");
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String getArtifactId() {
        String artifactId = LibbyManager.isMojangMapped() ? this.mojangMappedArtifactId : this.artifactId;
        return artifactId;
    }

    public String getChecksum() {
        String checksum = LibbyManager.isMojangMapped() ? this.checksumMappedArtifactId : this.checksum;
        return checksum;
    }

    public LibbyManager(Plugin plugin) {
        this.bukkitLibraryManager = new BukkitLibraryManager(plugin);
        this.bukkitLibraryManager.addMavenCentral();
        Library commandAPILibrary = Library.builder().groupId("dev{}jorel").artifactId(this.getArtifactId()).version(this.version).checksum(this.getChecksum()).relocate("dev{}jorel{}commandapi", "it.escanortargaryen.roadsideshop.commandapi").build();
        System.out.println(commandAPILibrary);
        try {
            this.bukkitLibraryManager.loadLibrary(commandAPILibrary);
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("[RoadsideShops] Can't load library " + commandAPILibrary.toString() + "!");
            e.printStackTrace();
        }
    }

    static {
        String[] splitted = MINECRAFT_VERSION.split("\\.");
        MINOR_VERSION = splitted.length > 2 ? Integer.parseInt(splitted[2]) : 0;
    }
}

