/*
 * Decompiled with CFR 0.152.
 */
package dev.escanortargaryen;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.sqlite.SQLiteConfig;

public class DatabaseManager {
    private Connection connection;

    public DatabaseManager(@NotNull File dbFile) throws Exception {
        Preconditions.checkNotNull((Object)dbFile, (Object)"Database file is null.");
        if (!dbFile.exists() && !dbFile.createNewFile()) {
            throw new IOException("Cannot create the database file.");
        }
        Class.forName("org.sqlite.JDBC");
        SQLiteConfig config = new SQLiteConfig();
        config.enforceForeignKeys(true);
        config.setEncoding(SQLiteConfig.Encoding.UTF8);
        config.setSynchronous(SQLiteConfig.SynchronousMode.FULL);
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(dbFile), config.toProperties());
        this.setUp();
    }

    private void setUp() throws SQLException {
        try (Statement statement = this.connection.createStatement();){
            statement.addBatch("CREATE TABLE IF NOT EXISTS `Players` ( id INTEGER PRIMARY KEY AUTOINCREMENT, uuid TEXT NOT NULL UNIQUE, player_name TEXT NOT NULL, balance REAL NOT NULL DEFAULT 0.0);");
            statement.executeBatch();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsPlayer(OfflinePlayer offlinePlayer) {
        String playerName = offlinePlayer.getName();
        String query = "SELECT COUNT(*) FROM `Players` WHERE player_name = ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);){
            stmt.setString(1, playerName);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return false;
                boolean bl = rs.getInt(1) > 0;
                return bl;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public double getBalance(OfflinePlayer offlinePlayer) {
        String playerName = offlinePlayer.getName();
        double balance = 0.0;
        String query = "SELECT balance FROM `Players` WHERE player_name = ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);){
            stmt.setString(1, playerName);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    balance = rs.getDouble("balance");
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return balance;
    }

    public void setBalance(OfflinePlayer player, double balance) {
        String playerName = player.getName();
        String query = "UPDATE `Players` SET balance = ? WHERE player_name = ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);){
            stmt.setDouble(1, balance);
            stmt.setString(2, playerName);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void addPlayer(OfflinePlayer offlinePlayer) {
        String playerName = offlinePlayer.getName();
        String uuid = offlinePlayer.getUniqueId().toString();
        double initialBalance = 0.0;
        if (!this.containsPlayer(offlinePlayer)) {
            String query = "INSERT INTO `Players` (uuid, player_name, balance) VALUES (?, ?, ?)";
            try (PreparedStatement stmt = this.connection.prepareStatement(query);){
                stmt.setString(1, uuid);
                stmt.setString(2, playerName);
                stmt.setDouble(3, initialBalance);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public List<OfflinePlayer> getPlayerNames() {
        ArrayList<OfflinePlayer> players = new ArrayList<OfflinePlayer>();
        String query = "SELECT player_name FROM `Players`";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                String playerName = rs.getString("player_name");
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
                players.add(offlinePlayer);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return players;
    }
}

