/*
 * Decompiled with CFR 0.152.
 */
package dev.escanortargaryen;

import dev.escanortargaryen.DatabaseManager;
import dev.escanortargaryen.VaultEconomy;
import dev.escanortargaryen.VaultInjector;
import dev.escanortargaryen.commands.BalanceCmd;
import dev.escanortargaryen.commands.EconomyCmd;
import dev.escanortargaryen.commands.PayCmd;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class SimpleEconomy
extends JavaPlugin
implements Listener {
    static SimpleEconomy instance;
    static DatabaseManager database;
    private static VaultEconomy economy;

    public void onEnable() {
        instance = this;
        try {
            new File(this.getDataFolder(), "").mkdirs();
            database = new DatabaseManager(new File(this.getDataFolder(), "database.db"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        economy = new VaultEconomy(database);
        PluginCommand command = Bukkit.getPluginCommand((String)"economy");
        if (command != null) {
            command.setExecutor((CommandExecutor)new EconomyCmd());
            command.setTabCompleter((TabCompleter)new EconomyCmd());
        }
        if ((command = Bukkit.getPluginCommand((String)"balance")) != null) {
            command.setExecutor((CommandExecutor)new BalanceCmd());
            command.setTabCompleter((TabCompleter)new BalanceCmd());
        }
        if ((command = Bukkit.getPluginCommand((String)"pay")) != null) {
            command.setExecutor((CommandExecutor)new PayCmd());
            command.setTabCompleter((TabCompleter)new PayCmd());
        }
        if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
            this.getServer().getServicesManager().register(Economy.class, (Object)new VaultInjector(economy), (Plugin)this, ServicePriority.Highest);
            this.getLogger().info("Hooked into Vault");
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public static VaultEconomy getEconomy() {
        return economy;
    }

    @EventHandler
    private void onJoin(PlayerJoinEvent e) {
        database.addPlayer((OfflinePlayer)e.getPlayer());
    }

    public void onDisable() {
        if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
            this.getServer().getServicesManager().unregister(Economy.class, (Object)this);
            this.getLogger().info("Unhooked from Vault");
        }
    }

    public static void add(OfflinePlayer player, double amount) {
        database.setBalance(player, database.getBalance(player) + amount);
    }

    public static void remove(OfflinePlayer player, double amount) {
        double am = database.getBalance(player) - amount;
        database.setBalance(player, am >= 0.0 ? am : 0.0);
    }

    public static double get(OfflinePlayer player) {
        return database.getBalance(player);
    }

    public static String getWithFormat(OfflinePlayer player) {
        return SimpleEconomy.getEconomy().format(SimpleEconomy.get(player));
    }

    public static boolean has(OfflinePlayer player, double amount) {
        SimpleEconomy.verify(amount);
        return database.getBalance(player) >= amount;
    }

    public static void set(OfflinePlayer player, double amount) {
        database.setBalance(player, amount);
    }

    public static double pay(OfflinePlayer sender, OfflinePlayer reciver, double amount) {
        SimpleEconomy.verify(amount);
        boolean modified = false;
        if (SimpleEconomy.has(sender, amount)) {
            modified = true;
            SimpleEconomy.remove(sender, amount);
            SimpleEconomy.add(reciver, amount);
        }
        return modified ? amount : 0.0;
    }

    public static boolean contains(OfflinePlayer player) {
        return database.containsPlayer(player);
    }

    public static void register(OfflinePlayer player) {
        database.addPlayer(player);
    }

    private static void verify(double d) {
        Validate.isTrue((d >= 0.0 ? 1 : 0) != 0, (String)"Amount must be a positive number");
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static List<OfflinePlayer> getPlayers() {
        return database.getPlayerNames();
    }
}

