/*
 * Decompiled with CFR 0.152.
 */
package dev.escanortargaryen;

import dev.escanortargaryen.DatabaseManager;
import dev.escanortargaryen.SimpleEconomy;
import java.util.ArrayList;
import java.util.List;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class VaultEconomy {
    DatabaseManager table;

    private VaultEconomy() {
    }

    private double apply(String player, double amount) {
        OfflinePlayer p = Bukkit.getOfflinePlayer((String)player);
        return this.apply(p, amount);
    }

    private double apply(OfflinePlayer player, double amount) {
        return amount;
    }

    public VaultEconomy(DatabaseManager table) {
        this.table = table;
    }

    public boolean isEnabled() {
        return SimpleEconomy.instance.isEnabled();
    }

    public String getName() {
        return "SimpleEconomy";
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return 2;
    }

    public String format(double d) {
        return SimpleEconomy.round(d, 2) + " $";
    }

    public String currencyNamePlural() {
        return "Dollars";
    }

    public String currencyNameSingular() {
        return "Dollar";
    }

    @Deprecated
    public boolean hasAccount(String player) {
        return this.table.containsPlayer(Bukkit.getOfflinePlayer((String)player));
    }

    public boolean hasAccount(OfflinePlayer player) {
        return this.table.containsPlayer(player);
    }

    @Deprecated
    public boolean hasAccount(String player, String world) {
        return this.table.containsPlayer(Bukkit.getOfflinePlayer((String)player));
    }

    public boolean hasAccount(OfflinePlayer player, String world) {
        return this.table.containsPlayer(player);
    }

    @Deprecated
    public double getBalance(String player) {
        return this.table.getBalance(Bukkit.getOfflinePlayer((String)player));
    }

    public double getBalance(OfflinePlayer player) {
        return this.table.getBalance(player);
    }

    @Deprecated
    public double getBalance(String player, String world) {
        return this.table.getBalance(Bukkit.getOfflinePlayer((String)player));
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.table.getBalance(player);
    }

    @Deprecated
    public boolean has(String player, double amount) {
        if (amount < 0.0) {
            throw new IllegalArgumentException("Illegal amount value " + amount);
        }
        if (amount == 0.0) {
            return true;
        }
        return this.table.getBalance(Bukkit.getOfflinePlayer((String)player)) >= amount;
    }

    public boolean has(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            throw new IllegalArgumentException("Illegal amount value " + amount);
        }
        if (amount == 0.0) {
            return true;
        }
        return this.table.getBalance(player) >= amount;
    }

    @Deprecated
    public boolean has(String player, String world, double amount) {
        if (amount < 0.0) {
            throw new IllegalArgumentException("Illegal amount value " + amount);
        }
        if (amount == 0.0) {
            return true;
        }
        return this.table.getBalance(Bukkit.getOfflinePlayer((String)player)) >= amount;
    }

    public boolean has(OfflinePlayer player, String world, double amount) {
        if (amount < 0.0) {
            throw new IllegalArgumentException("Illegal amount value " + amount);
        }
        if (amount == 0.0) {
            return true;
        }
        return this.table.getBalance(player) >= amount;
    }

    @Deprecated
    public EconomyResponse withdrawPlayer(String player, double amount) {
        if (amount <= 0.0) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw a negative amount of ");
        }
        double d = this.table.getBalance(Bukkit.getOfflinePlayer((String)player));
        double d1 = d <= amount ? 0.0 : d - amount;
        this.table.setBalance(Bukkit.getOfflinePlayer((String)player), d1);
        return new EconomyResponse(d1, d, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        if (amount <= 0.0) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw a negative amount of ");
        }
        double d = this.table.getBalance(player);
        double d1 = d <= amount ? 0.0 : d - amount;
        this.table.setBalance(player, d1);
        return new EconomyResponse(d1, d, EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Deprecated
    public EconomyResponse withdrawPlayer(String player, String world, double amount) {
        if (amount <= 0.0) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw a negative amount of ");
        }
        double d = this.table.getBalance(Bukkit.getOfflinePlayer((String)player));
        double d1 = d <= amount ? 0.0 : d - amount;
        this.table.setBalance(Bukkit.getOfflinePlayer((String)player), d1);
        return new EconomyResponse(d1, d, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String world, double amount) {
        if (amount <= 0.0) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw a negative amount of ");
        }
        double d = this.table.getBalance(player);
        double d1 = d <= amount ? 0.0 : d - amount;
        this.table.setBalance(player, d1);
        return new EconomyResponse(d1, d, EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Deprecated
    public EconomyResponse depositPlayer(String player, double amount) {
        if (amount <= 0.0) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot deposit a negative amount of ");
        }
        double balance = this.table.getBalance(Bukkit.getOfflinePlayer((String)player));
        this.table.setBalance(Bukkit.getOfflinePlayer((String)player), balance + amount);
        return new EconomyResponse(amount, balance + amount, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        if (amount <= 0.0) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot deposit a negative amount of ");
        }
        double balance = this.table.getBalance(player);
        this.table.setBalance(player, balance + amount);
        return new EconomyResponse(amount, balance + amount, EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Deprecated
    public EconomyResponse depositPlayer(String player, String world, double amount) {
        if (amount <= 0.0) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot deposit a negative amount of ");
        }
        OfflinePlayer p = Bukkit.getOfflinePlayer((String)player);
        double balance = this.table.getBalance(p);
        this.table.setBalance(p, balance + amount);
        return new EconomyResponse(amount, balance + amount, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String world, double amount) {
        if (amount <= 0.0) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot deposit a negative amount of ");
        }
        double balance = this.table.getBalance(player);
        this.table.setBalance(player, balance + amount);
        return new EconomyResponse(amount, balance + amount, EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Deprecated
    public EconomyResponse createBank(String var1, String var2) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "");
    }

    @Deprecated
    public EconomyResponse createBank(String var1, OfflinePlayer var2) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "");
    }

    @Deprecated
    public EconomyResponse deleteBank(String var1) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "");
    }

    @Deprecated
    public EconomyResponse bankBalance(String var1) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "");
    }

    @Deprecated
    public EconomyResponse bankHas(String var1, double var2) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "");
    }

    @Deprecated
    public EconomyResponse bankWithdraw(String var1, double var2) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "");
    }

    @Deprecated
    public EconomyResponse bankDeposit(String var1, double var2) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "");
    }

    @Deprecated
    public EconomyResponse isBankOwner(String var1, String var2) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "");
    }

    @Deprecated
    public EconomyResponse isBankOwner(String var1, OfflinePlayer var2) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "");
    }

    @Deprecated
    public EconomyResponse isBankMember(String var1, String var2) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "");
    }

    @Deprecated
    public EconomyResponse isBankMember(String var1, OfflinePlayer var2) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "");
    }

    @Deprecated
    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    @Deprecated
    public boolean createPlayerAccount(String player) {
        this.table.addPlayer(Bukkit.getOfflinePlayer((String)player));
        return true;
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        this.table.addPlayer(player);
        return true;
    }

    @Deprecated
    public boolean createPlayerAccount(String player, String world) {
        this.table.addPlayer(Bukkit.getOfflinePlayer((String)player));
        return true;
    }

    public boolean createPlayerAccount(OfflinePlayer player, String world) {
        this.table.addPlayer(player);
        return true;
    }
}

