/*
 * Decompiled with CFR 0.152.
 */
package dev.escanortargaryen.commands;

import dev.escanortargaryen.SimpleEconomy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BalanceCmd
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (args.length > 1) {
                sender.sendMessage(p.hasPermission("eco.balance.others") ? "\u00a7cUsage: /balance [playername]" : "\u00a7cUsage /balance");
                return false;
            }
            if (args.length == 1) {
                if (p.hasPermission("eco.balance.others")) {
                    OfflinePlayer pl = Bukkit.getOfflinePlayer((String)args[0]);
                    if (pl == null) {
                        sender.sendMessage("\u00a7cCouldn't find player " + args[0]);
                        return false;
                    }
                    sender.sendMessage("\u00a7aUser \u00a7e" + args[0] + "\u00a7a has \u00a7e" + SimpleEconomy.getWithFormat(pl));
                    return true;
                }
                sender.sendMessage("\u00a7cInsufficient permissions to know other player's balances");
                return false;
            }
            sender.sendMessage("\u00a7eYou\u00a7a have \u00a7e" + SimpleEconomy.getWithFormat((OfflinePlayer)p) + " ");
        } else {
            if (args.length != 1) {
                sender.sendMessage("\u00a7cusage: /balance <playerName>");
                return false;
            }
            OfflinePlayer pl = Bukkit.getOfflinePlayer((String)args[0]);
            if (pl == null) {
                sender.sendMessage("\u00a7cCouldn't find player " + args[0]);
                return false;
            }
            sender.sendMessage("\u00a7aUser \u00a7e" + args[0] + "\u00a7a has \u00a7e" + SimpleEconomy.getWithFormat(pl) + " ");
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1 && sender.hasPermission("eco.balance.others")) {
            ArrayList<String> completions = new ArrayList<String>(Bukkit.getOnlinePlayers().size());
            SimpleEconomy.getPlayers().forEach(p -> completions.add(p.getName()));
            return BalanceCmd.filterTabCompleteOptions(completions, args);
        }
        return new ArrayList<String>();
    }

    public static List<String> filterTabCompleteOptions(Collection<String> options, String[] args) {
        String lastArg = "";
        if (args.length > 0) {
            lastArg = args[args.length - 1].toLowerCase();
        }
        ArrayList<String> Options = new ArrayList<String>(options);
        for (int i = 0; i < Options.size(); ++i) {
            if (((String)Options.get(i)).toLowerCase().startsWith(lastArg)) continue;
            Options.remove(i--);
        }
        return Options;
    }
}

