/*
 * Decompiled with CFR 0.152.
 */
package dev.escanortargaryen.commands;

import dev.escanortargaryen.SimpleEconomy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;

public class EconomyCmd
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("\u00a7cUsage: /eco <give|take|set> ...");
            return false;
        }
        double amount = 0.0;
        if (args.length == 3) {
            try {
                amount = Double.parseDouble(args[2]);
                if (amount < 0.0) {
                    sender.sendMessage("\u00a7cCannot send less then 0 ");
                    return false;
                }
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7c" + args[2] + " is not a valid number");
                return false;
            }
        }
        if (args[0].equalsIgnoreCase("give")) {
            if (args.length != 3) {
                sender.sendMessage("\u00a7cUsage: /eco give <playerName> <amount>");
                return false;
            }
            OfflinePlayer pl = Bukkit.getOfflinePlayer((String)args[1]);
            if (pl == null) {
                sender.sendMessage("\u00a7cCouldn't find player " + args[0]);
                return false;
            }
            try {
                SimpleEconomy.add(pl, amount);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7c" + args[2] + " is not a valid number");
                return false;
            }
            sender.sendMessage("\u00a7aGave \u00a7e" + SimpleEconomy.getEconomy().format(amount) + "\u00a7a to \u00a7e" + args[1]);
            return true;
        }
        if (args[0].equalsIgnoreCase("take")) {
            if (args.length != 3) {
                sender.sendMessage("\u00a7cUsage: /eco take <playerName> <amount>");
                return false;
            }
            OfflinePlayer pl = Bukkit.getOfflinePlayer((String)args[1]);
            if (pl == null) {
                sender.sendMessage("\u00a7cCouldn't find player " + args[0]);
                return false;
            }
            try {
                SimpleEconomy.remove(pl, amount);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7c" + args[2] + " is not a valid number");
                return false;
            }
            sender.sendMessage("\u00a7aTook \u00a7e" + SimpleEconomy.getEconomy().format(amount) + "\u00a7a from \u00a7e" + args[1]);
            return true;
        }
        if (args[0].equalsIgnoreCase("set")) {
            if (args.length != 3) {
                sender.sendMessage("\u00a7cUsage: /eco set <playerName> <amount>");
                return false;
            }
            OfflinePlayer pl = Bukkit.getOfflinePlayer((String)args[1]);
            if (pl == null) {
                sender.sendMessage("\u00a7cCouldn't find player " + args[0]);
                return false;
            }
            try {
                SimpleEconomy.set(pl, amount);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7c" + args[2] + " is not a valid number");
                return false;
            }
            sender.sendMessage("\u00a7aSetted \u00a7e" + SimpleEconomy.getEconomy().format(amount) + "\u00a7a to \u00a7e" + args[1]);
            return true;
        }
        sender.sendMessage("\u00a7cUsage: /eco <give|take|set> ...");
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            return EconomyCmd.filterTabCompleteOptions(Arrays.asList("give", "take", "set"), args);
        }
        if (args.length == 2) {
            LinkedList<String> completions = new LinkedList<String>();
            SimpleEconomy.getPlayers().forEach(p -> completions.add(p.getName()));
            return EconomyCmd.filterTabCompleteOptions(completions, args);
        }
        return new ArrayList<String>();
    }

    public static List<String> filterTabCompleteOptions(Collection<String> options, String[] args) {
        String lastArg = "";
        if (args.length > 0) {
            lastArg = args[args.length - 1].toLowerCase();
        }
        ArrayList<String> Options = new ArrayList<String>(options);
        for (int i = 0; i < Options.size(); ++i) {
            if (((String)Options.get(i)).toLowerCase().startsWith(lastArg)) continue;
            Options.remove(i--);
        }
        return Options;
    }
}

