/*
 * Decompiled with CFR 0.152.
 */
package dev.escanortargaryen.commands;

import dev.escanortargaryen.SimpleEconomy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PayCmd
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        double amount;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cYou must be a player to do /pay");
            return false;
        }
        Player p = (Player)sender;
        if (args.length != 2) {
            sender.sendMessage("\u00a7cUsage: /pay <playerName> <amount>");
            return false;
        }
        try {
            amount = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(args[1] + " is not a valid number");
            return false;
        }
        if (amount == 0.0) {
            sender.sendMessage("\u00a7cCannot send 0 ");
            return false;
        }
        if (p.getName().equalsIgnoreCase(args[0])) {
            p.sendMessage("\u00a7cYou cannot send money to yourself!");
            return false;
        }
        OfflinePlayer pl = Bukkit.getOfflinePlayer((String)args[0]);
        if (pl == null) {
            sender.sendMessage("\u00a7cCouldn't find player " + args[0]);
            return false;
        }
        double d = 0.0;
        try {
            d = SimpleEconomy.pay((OfflinePlayer)p, pl, amount);
        }
        catch (Exception e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + e.getMessage());
            return false;
        }
        p.sendMessage("\u00a7aSent \u00a7e" + SimpleEconomy.getEconomy().format(d) + "\u00a7a to \u00a7e" + args[0]);
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>(Bukkit.getOnlinePlayers().size());
            SimpleEconomy.getPlayers().forEach(p -> {
                if (!sender.getName().equalsIgnoreCase(p.getName())) {
                    completions.add(p.getName());
                }
            });
            return PayCmd.filterTabCompleteOptions(completions, args);
        }
        return new ArrayList<String>();
    }

    public static List<String> filterTabCompleteOptions(Collection<String> options, String[] args) {
        String lastArg = "";
        if (args.length > 0) {
            lastArg = args[args.length - 1].toLowerCase();
        }
        ArrayList<String> Options = new ArrayList<String>(options);
        for (int i = 0; i < Options.size(); ++i) {
            if (((String)Options.get(i)).toLowerCase().startsWith(lastArg)) continue;
            Options.remove(i--);
        }
        return Options;
    }
}

