/*
 * Decompiled with CFR 0.152.
 */
package it.escanortargaryen.roadsideshop;

import it.escanortargaryen.roadsideshop.InternalUtil;
import it.escanortargaryen.roadsideshop.bstat.bukkit.Metrics;
import it.escanortargaryen.roadsideshop.classes.LockedSlot;
import it.escanortargaryen.roadsideshop.classes.LockedSlotCheck;
import it.escanortargaryen.roadsideshop.classes.Shop;
import it.escanortargaryen.roadsideshop.db.DatabaseManager;
import it.escanortargaryen.roadsideshop.managers.Commands;
import it.escanortargaryen.roadsideshop.managers.LibbyManager;
import it.escanortargaryen.roadsideshop.managers.ShopsManager;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class RoadsideShops
extends JavaPlugin
implements Listener {
    public static RoadsideShops INSTANCE;
    private static Economy econ;
    private static DatabaseManager databaseManager;
    private boolean test = false;
    private Commands commandAPI;
    private LibbyManager libbyManager;
    private final ArrayList<LockedSlot> lockedSlots = new ArrayList();

    public static Economy getEconomy() {
        return econ;
    }

    public void onLoad() {
        INSTANCE = this;
        this.saveResource("config.yml", false);
        new InternalUtil();
        this.libbyManager = new LibbyManager((Plugin)this);
        this.commandAPI = new Commands();
        if (!this.test) {
            this.commandAPI.onLoad((Plugin)this);
        }
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return true;
    }

    public static ArrayList<Shop> getAllShops() {
        return databaseManager.getAllShops();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        final Player p = e.getPlayer();
        CompletableFuture.runAsync(() -> {
            databaseManager.addPlayer(p);
            final Shop shop = RoadsideShops.getShop(p, true);
            new BukkitRunnable(){

                public void run() {
                    if (shop != null && shop.getOffMessages().size() > 0) {
                        p.sendMessage(InternalUtil.CONFIGMANAGER.getWhileOffline());
                        for (String s : shop.getOffMessages()) {
                            p.sendMessage(s);
                        }
                        shop.clearMessages();
                    }
                }
            }.runTask((Plugin)INSTANCE);
        });
    }

    public void onDisable() {
        super.onDisable();
        try {
            databaseManager.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void onEnable() {
        if (!this.setupEconomy()) {
            this.getServer().getLogger().info("Disabled due to no Vault economy found!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        Metrics metrics = null;
        if (!this.test) {
            this.commandAPI.onEnable();
            int pluginId = 17468;
            metrics = new Metrics((Plugin)this, pluginId);
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        new ShopsManager(metrics);
        try {
            databaseManager = new DatabaseManager(new File(String.valueOf(this.getDataFolder()) + "/database.db"), metrics);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)INSTANCE);
            return;
        }
        String s = "\u00a77----\u00a7c\u00a7nRoadside\u00a7r \u00a76\u00a7nShops\u00a7r\u00a77----\u00a7r\n\u00a7fby \u00a7eEscanorTargaryen\u00a7r\n\u00a72Enabled version: " + this.getDescription().getVersion() + "\u00a7r\n\u00a77-----------------------\u00a7r";
        Bukkit.getConsoleSender().sendMessage(s);
    }

    public static boolean hasShop(@NotNull UUID player) {
        return databaseManager.hasShop(player);
    }

    public static void saveShop(@NotNull Shop shop) {
        databaseManager.updateShop(shop);
    }

    public static void registerCustomLockedSlot(@NotNull ItemStack itemStack, @NotNull LockedSlotCheck lockedSlotCheck) {
        Objects.requireNonNull(itemStack);
        Objects.requireNonNull(lockedSlotCheck);
        RoadsideShops.INSTANCE.lockedSlots.add(new LockedSlot(itemStack, lockedSlotCheck));
    }

    public ArrayList<LockedSlot> getCustomLockedSlots() {
        return new ArrayList<LockedSlot>(this.lockedSlots);
    }

    public static Shop getShop(@NotNull Player player) {
        Objects.requireNonNull(player);
        return RoadsideShops.getShop(player.getUniqueId(), true);
    }

    public static Shop getShop(@NotNull Player player, boolean saveInCache) {
        Objects.requireNonNull(player);
        return RoadsideShops.getShop(player.getUniqueId(), saveInCache);
    }

    public static Shop getShop(@NotNull UUID player, boolean saveInCache) {
        Objects.requireNonNull(player);
        return databaseManager.getShop(player, saveInCache);
    }

    public static Shop getShop(@NotNull UUID player) {
        Objects.requireNonNull(player);
        return databaseManager.getShop(player, true);
    }

    public RoadsideShops() {
    }

    protected RoadsideShops(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
        this.test = true;
    }

    static {
        econ = null;
        databaseManager = null;
    }
}

