/*
 * Decompiled with CFR 0.152.
 */
package it.escanortargaryen.roadsideshop.classes;

import it.escanortargaryen.roadsideshop.InternalUtil;
import it.escanortargaryen.roadsideshop.RoadsideShops;
import it.escanortargaryen.roadsideshop.classes.SellingItem;
import it.escanortargaryen.roadsideshop.classes.Shop;
import it.escanortargaryen.roadsideshop.managers.Commands;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class Newspaper
implements Listener,
InventoryHolder {
    private ArrayList<SellingItem> items = new ArrayList();
    private int page = 1;
    private boolean duringAnimation = false;
    private final ItemStack glass;
    private BukkitTask animationTaskTimer;

    public Newspaper(@NotNull Collection<Shop> allShops, @NotNull Player player) {
        Objects.requireNonNull(allShops);
        Objects.requireNonNull(player);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)RoadsideShops.INSTANCE);
        this.glass = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta m = this.glass.getItemMeta();
        Objects.requireNonNull(m).setDisplayName(String.valueOf(ChatColor.AQUA));
        this.glass.setItemMeta(m);
        ArrayList<SellingItem> t = new ArrayList<SellingItem>();
        for (Shop s : allShops) {
            if (s.getSponsor() == null || s.getPlayerUUID().equals(player.getUniqueId())) continue;
            t.add(s.getSponsor());
        }
        if (t.size() < 19) {
            this.items = t;
        } else {
            for (int i = 0; i < 18; ++i) {
                int randomNum = ThreadLocalRandom.current().nextInt(0, t.size());
                this.items.add((SellingItem)t.get(randomNum));
                t.remove(randomNum);
            }
        }
        if (this.items.size() == 0) {
            player.sendMessage(InternalUtil.CONFIGMANAGER.getNoAdv());
        } else {
            player.openInventory(this.getInventory());
        }
    }

    @NotNull
    public Inventory getInventory() {
        Inventory inv = Bukkit.createInventory((InventoryHolder)this, (int)45, (String)InternalUtil.CONFIGMANAGER.getNewspaperTitle());
        ItemStack paper = new ItemStack(Material.PAPER);
        for (int i = 0; i < 45; ++i) {
            inv.setItem(i, this.glass.clone());
        }
        if (this.page == 1) {
            inv.setItem(26, InternalUtil.RIGHTARROW);
            inv.setItem(11, this.items.get(0).getForNewspaper());
            if (this.items.size() > 1) {
                inv.setItem(20, this.items.get(1).getForNewspaper());
            } else {
                inv.setItem(20, paper);
            }
            if (this.items.size() > 2) {
                inv.setItem(29, this.items.get(2).getForNewspaper());
            } else {
                inv.setItem(29, paper);
            }
            if (this.items.size() > 3) {
                inv.setItem(15, this.items.get(3).getForNewspaper());
            } else {
                inv.setItem(15, paper);
            }
            if (this.items.size() > 4) {
                inv.setItem(24, this.items.get(4).getForNewspaper());
            } else {
                inv.setItem(24, paper);
            }
            if (this.items.size() > 5) {
                inv.setItem(33, this.items.get(5).getForNewspaper());
            } else {
                inv.setItem(33, paper);
            }
        }
        if (this.page == 2) {
            inv.setItem(26, InternalUtil.RIGHTARROW);
            inv.setItem(18, InternalUtil.LEFTARROW);
            if (this.items.size() > 6) {
                inv.setItem(11, this.items.get(6).getForNewspaper());
            } else {
                inv.setItem(11, paper);
            }
            if (this.items.size() > 7) {
                inv.setItem(20, this.items.get(7).getForNewspaper());
            } else {
                inv.setItem(20, paper);
            }
            if (this.items.size() > 8) {
                inv.setItem(29, this.items.get(8).getForNewspaper());
            } else {
                inv.setItem(29, paper);
            }
            if (this.items.size() > 9) {
                inv.setItem(15, this.items.get(9).getForNewspaper());
            } else {
                inv.setItem(15, paper);
            }
            if (this.items.size() > 10) {
                inv.setItem(24, this.items.get(10).getForNewspaper());
            } else {
                inv.setItem(24, paper);
            }
            if (this.items.size() > 11) {
                inv.setItem(33, this.items.get(11).getForNewspaper());
            } else {
                inv.setItem(33, paper);
            }
        }
        if (this.page == 3) {
            inv.setItem(18, InternalUtil.LEFTARROW);
            if (this.items.size() > 12) {
                inv.setItem(11, this.items.get(12).getForNewspaper());
            } else {
                inv.setItem(11, paper);
            }
            if (this.items.size() > 13) {
                inv.setItem(20, this.items.get(13).getForNewspaper());
            } else {
                inv.setItem(20, paper);
            }
            if (this.items.size() > 14) {
                inv.setItem(29, this.items.get(14).getForNewspaper());
            } else {
                inv.setItem(29, paper);
            }
            if (this.items.size() > 15) {
                inv.setItem(15, this.items.get(15).getForNewspaper());
            } else {
                inv.setItem(15, paper);
            }
            if (this.items.size() > 16) {
                inv.setItem(24, this.items.get(16).getForNewspaper());
            } else {
                inv.setItem(24, paper);
            }
            if (this.items.size() > 17) {
                inv.setItem(33, this.items.get(17).getForNewspaper());
            } else {
                inv.setItem(33, paper);
            }
        }
        inv.setItem(13, new ItemStack(this.glass.clone()));
        inv.setItem(22, new ItemStack(this.glass.clone()));
        inv.setItem(31, new ItemStack(this.glass.clone()));
        inv.setItem(10, paper);
        inv.setItem(12, paper);
        inv.setItem(14, paper);
        inv.setItem(16, paper);
        inv.setItem(19, paper);
        inv.setItem(21, paper);
        inv.setItem(23, paper);
        inv.setItem(25, paper);
        inv.setItem(28, paper);
        inv.setItem(30, paper);
        inv.setItem(32, paper);
        inv.setItem(34, paper);
        return inv;
    }

    @EventHandler
    private void onClick(InventoryClickEvent e) {
        Inventory topInventory = InternalUtil.getTopInventory(e);
        Player player = (Player)e.getWhoClicked();
        if (e.getClickedInventory() == null || e.getCurrentItem() == null || e.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        if (topInventory.getHolder() != this) {
            return;
        }
        if (this.duringAnimation) {
            e.setCancelled(true);
            return;
        }
        e.setCancelled(true);
        if (Objects.requireNonNull(e.getInventory().getItem(e.getSlot())).getType() == Material.ARROW) {
            Inventory p;
            final Inventory inv = InternalUtil.getTopInventory(e);
            if (e.getSlot() == 26) {
                ++this.page;
                p = this.getInventory();
                this.duringAnimation = true;
                this.animationTaskTimer = new BukkitRunnable(){
                    int y = 0;

                    public void run() {
                        int i;
                        for (i = 11; i < 17; ++i) {
                            inv.setItem(i - 1, inv.getItem(i));
                        }
                        for (i = 20; i < 26; ++i) {
                            inv.setItem(i - 1, inv.getItem(i));
                        }
                        for (i = 29; i < 35; ++i) {
                            inv.setItem(i - 1, inv.getItem(i));
                        }
                        inv.setItem(16, p.getItem(10 + this.y));
                        inv.setItem(25, p.getItem(19 + this.y));
                        inv.setItem(34, p.getItem(28 + this.y));
                        ++this.y;
                        if (this.y == 7) {
                            inv.setItem(26, p.getItem(26));
                            inv.setItem(18, p.getItem(18));
                            Newspaper.this.duringAnimation = false;
                            this.cancel();
                        }
                    }
                }.runTaskTimer((Plugin)RoadsideShops.INSTANCE, 0L, 3L);
            }
            if (e.getSlot() == 18) {
                --this.page;
                p = this.getInventory();
                this.duringAnimation = true;
                this.animationTaskTimer = new BukkitRunnable(){
                    int y = 0;

                    public void run() {
                        int i;
                        for (i = 15; i > 9; --i) {
                            inv.setItem(i + 1, inv.getItem(i));
                        }
                        for (i = 24; i > 18; --i) {
                            inv.setItem(i + 1, inv.getItem(i));
                        }
                        for (i = 33; i > 27; --i) {
                            inv.setItem(i + 1, inv.getItem(i));
                        }
                        inv.setItem(10, p.getItem(16 - this.y));
                        inv.setItem(19, p.getItem(25 - this.y));
                        inv.setItem(28, p.getItem(34 - this.y));
                        ++this.y;
                        if (this.y == 7) {
                            inv.setItem(26, p.getItem(26));
                            inv.setItem(18, p.getItem(18));
                            Newspaper.this.duringAnimation = false;
                            this.cancel();
                        }
                    }
                }.runTaskTimer((Plugin)RoadsideShops.INSTANCE, 0L, 3L);
            }
        }
        if (Objects.requireNonNull(e.getInventory().getItem(e.getSlot())).getType() != Material.PAPER) {
            int slot = e.getSlot();
            if (slot == 11) {
                if (this.page == 1) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(0).getPlayerUUID());
                }
                if (this.page == 2) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(6).getPlayerUUID());
                }
                if (this.page == 3) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(12).getPlayerUUID());
                }
            }
            if (slot == 20) {
                if (this.page == 1) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(1).getPlayerUUID());
                }
                if (this.page == 2) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(7).getPlayerUUID());
                }
                if (this.page == 3) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(13).getPlayerUUID());
                }
            }
            if (slot == 29) {
                if (this.page == 1) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(2).getPlayerUUID());
                }
                if (this.page == 2) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(8).getPlayerUUID());
                }
                if (this.page == 3) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(14).getPlayerUUID());
                }
            }
            if (slot == 15) {
                if (this.page == 1) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(3).getPlayerUUID());
                }
                if (this.page == 2) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(9).getPlayerUUID());
                }
                if (this.page == 3) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(15).getPlayerUUID());
                }
            }
            if (slot == 24) {
                if (this.page == 1) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(4).getPlayerUUID());
                }
                if (this.page == 2) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(10).getPlayerUUID());
                }
                if (this.page == 3) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(16).getPlayerUUID());
                }
            }
            if (slot == 33) {
                if (this.page == 1) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(5).getPlayerUUID());
                }
                if (this.page == 2) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(1).getPlayerUUID());
                }
                if (this.page == 3) {
                    this.dispatchShopCommand((HumanEntity)player, this.items.get(17).getPlayerUUID());
                }
            }
        }
    }

    private void dispatchShopCommand(@NotNull HumanEntity humanEntity, @NotNull UUID owner) {
        Objects.requireNonNull(humanEntity);
        Objects.requireNonNull(owner);
        Commands.openPlayerShop((Player)humanEntity, Bukkit.getOfflinePlayer((UUID)owner));
    }

    @EventHandler
    private void onClose(InventoryCloseEvent e) {
        if (e.getInventory().getHolder() == this) {
            if (this.duringAnimation) {
                this.animationTaskTimer.cancel();
            }
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
        }
    }
}

