/*
 * Decompiled with CFR 0.152.
 */
package it.escanortargaryen.roadsideshop.classes;

import it.escanortargaryen.roadsideshop.InternalUtil;
import it.escanortargaryen.roadsideshop.RoadsideShops;
import it.escanortargaryen.roadsideshop.classes.LockedSlot;
import it.escanortargaryen.roadsideshop.classes.SellingItem;
import it.escanortargaryen.roadsideshop.classes.ViewMode;
import it.escanortargaryen.roadsideshop.managers.ConfigManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Shop
implements InventoryHolder {
    private final UUID playerUUID;
    private Inventory invSeller = null;
    private Inventory invBuyer = null;
    private final String playerName;
    private SellingItem sponsor = null;
    private final int unlockedSlotsNumber = InternalUtil.CONFIGMANAGER.getUnlockedSlots();
    private HashMap<Integer, SellingItem> items = new HashMap();
    private ArrayList<String> offMessages = new ArrayList();
    private long lastSponsor = 0L;
    private final InventoryHolder inventoryHolder;
    private HashMap<Player, ViewMode> viewers = new HashMap();

    public Shop(@NotNull UUID player, @NotNull String playerName, @NotNull ArrayList<String> offMessages, @Nullable SellingItem sponsor, @NotNull ArrayList<SellingItem> items, long lastSponsor) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(playerName);
        Objects.requireNonNull(offMessages);
        Objects.requireNonNull(items);
        InternalUtil.INVENTORYHOLDERS.add(this);
        this.playerUUID = player;
        this.playerName = playerName;
        this.offMessages = offMessages;
        this.sponsor = sponsor;
        for (SellingItem i : items) {
            this.items.put(i.getSlot(), i);
        }
        this.lastSponsor = lastSponsor;
        this.inventoryHolder = this;
    }

    public Shop(@NotNull UUID player, @NotNull String playerName) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(playerName);
        InternalUtil.INVENTORYHOLDERS.add(this);
        this.playerUUID = player;
        this.playerName = playerName;
        this.inventoryHolder = this;
    }

    public boolean canSponsor() {
        long time = System.currentTimeMillis();
        Player pl = Bukkit.getPlayer((UUID)this.playerUUID);
        if (pl != null && pl.hasPermission("roadsideshops.admin.sponsortimebypass")) {
            return true;
        }
        return (time - this.lastSponsor) / 1000L > ConfigManager.SPONSORTIME;
    }

    public long getLastSponsor() {
        return this.lastSponsor;
    }

    public long getMissTimeInMins() {
        long time = System.currentTimeMillis();
        long i = (ConfigManager.SPONSORTIME * 1000L - (time - this.lastSponsor)) / 60000L + 1L;
        if (i < 0L) {
            return 0L;
        }
        return i;
    }

    private void applySponsor() {
        this.lastSponsor = System.currentTimeMillis();
    }

    public InventoryHolder getInventoryHolder() {
        return this.inventoryHolder;
    }

    public void openInventory(@NotNull Player player, ViewMode mode) {
        Objects.requireNonNull(player);
        if (mode == ViewMode.SELLER) {
            if (this.invSeller == null) {
                this.invSeller = this.getInventory();
            }
            player.openInventory(this.invSeller);
            this.viewers.put(player, ViewMode.SELLER);
        } else {
            if (this.invBuyer == null) {
                this.invSeller = this.getInventory();
            }
            player.openInventory(this.invBuyer);
            this.viewers.put(player, ViewMode.BUYER);
        }
    }

    public void updateInventory() {
        this.updateInvSeller();
        this.updateInvBuyer();
    }

    @Nullable
    public SellingItem getItemAt(int slot) {
        return this.items.get(slot);
    }

    @NotNull
    public Inventory getInventory() {
        this.invSeller = Bukkit.createInventory((InventoryHolder)this, (int)18, (String)InternalUtil.CONFIGMANAGER.getShopTitle(this.playerName));
        this.invBuyer = Bukkit.createInventory((InventoryHolder)this, (int)18, (String)InternalUtil.CONFIGMANAGER.getShopTitle(this.playerName));
        this.updateInventory();
        return this.invSeller;
    }

    private void updateInvSeller() {
        if (this.invSeller != null) {
            int i;
            ItemStack here = InternalUtil.UNLOCKEDSLOT;
            for (i = 0; i < 18; ++i) {
                this.invSeller.setItem(i, InternalUtil.LOCKEDSLOT);
            }
            for (i = 1; i < this.unlockedSlotsNumber + 1; ++i) {
                if (i > 7) {
                    this.invSeller.setItem(i + 2, here);
                    continue;
                }
                this.invSeller.setItem(i, here);
            }
            this.invSeller.setItem(0, InternalUtil.LOG);
            this.invSeller.setItem(8, InternalUtil.LOG);
            this.invSeller.setItem(9, InternalUtil.LOG);
            this.invSeller.setItem(17, InternalUtil.LOG);
            for (SellingItem s : this.getItems()) {
                if (s.equals(this.sponsor)) {
                    this.invSeller.setItem(s.getSlot(), s.getWithPriceAndSponsorSeller());
                    continue;
                }
                this.invSeller.setItem(s.getSlot(), s.getWithPriceSeller());
            }
            ArrayList<LockedSlot> lo = RoadsideShops.INSTANCE.getCustomLockedSlots();
            Player p = Bukkit.getPlayer((UUID)this.playerUUID);
            if (p != null) {
                int y = 14;
                for (LockedSlot l : lo) {
                    if (!l.isLocked(p) || y <= 0) continue;
                    if (y > 7) {
                        this.invSeller.setItem(y + 2, l.getItemStack());
                    } else {
                        this.invSeller.setItem(y, l.getItemStack());
                    }
                    --y;
                }
            }
        }
    }

    private void updateInvBuyer() {
        if (this.invBuyer != null) {
            ItemStack n = new ItemStack(Material.AIR);
            for (int i = 0; i < 18; ++i) {
                this.invBuyer.setItem(i, n.clone());
            }
            this.invBuyer.setItem(0, InternalUtil.LOG);
            this.invBuyer.setItem(8, InternalUtil.LOG);
            this.invBuyer.setItem(9, InternalUtil.LOG);
            this.invBuyer.setItem(17, InternalUtil.LOG);
            for (SellingItem s : this.getItems()) {
                if (s.equals(this.sponsor)) {
                    this.invBuyer.setItem(s.getSlot(), s.getWithPriceAndSponsorBuyer());
                    continue;
                }
                this.invBuyer.setItem(s.getSlot(), s.getWithPriceBuyer());
            }
        }
    }

    public void addItem(@NotNull SellingItem sellingItem, boolean isSponsoring) {
        this.addItem(sellingItem, isSponsoring, false);
    }

    public void addItem(@NotNull SellingItem sellingItem, boolean isSponsoring, boolean sendMessage) {
        this.addItem(sellingItem, isSponsoring, sendMessage, null);
    }

    public void addItem(@NotNull SellingItem sellingItem, boolean isSponsoring, boolean notifyPlayer, @Nullable Player playerToNotify) {
        Objects.requireNonNull(sellingItem);
        if (playerToNotify == null && notifyPlayer) {
            playerToNotify = Bukkit.getPlayer((UUID)sellingItem.getPlayerUUID());
        }
        this.items.put(sellingItem.getSlot(), sellingItem);
        this.updateInventory();
        if (notifyPlayer && playerToNotify != null) {
            playerToNotify.sendMessage(InternalUtil.CONFIGMANAGER.getPutItem(sellingItem.getPrice(), sellingItem.getItem().getType().toString(), sellingItem.getItem().getAmount()));
        }
        if (isSponsoring) {
            if (notifyPlayer && playerToNotify != null) {
                playerToNotify.sendMessage(InternalUtil.CONFIGMANAGER.getSponsorSet(sellingItem.getPrice(), sellingItem.getItem().getType().toString(), sellingItem.getItem().getAmount()));
            }
            this.setSponsor(sellingItem);
        }
        this.applyChangesDB();
    }

    public void removeItem(int slot) {
        SellingItem i = this.getItemAt(slot);
        if (i != null) {
            this.removeItem(i, true, true, null);
        }
    }

    public void removeItem(@NotNull SellingItem sellingItem, @Nullable Player playerToNotify) {
        this.removeItem(sellingItem, true, true, playerToNotify);
    }

    public void removeItem(int slot, boolean notifyPlayer, boolean giveBack, @Nullable Player playerToNotify) {
        SellingItem i = this.getItemAt(slot);
        if (i != null) {
            this.removeItem(i, notifyPlayer, giveBack, playerToNotify);
        }
    }

    public void removeItem(@NotNull SellingItem sellingItem, boolean notifyPlayer, boolean giveBack, @Nullable Player playerToNotify) {
        Objects.requireNonNull(sellingItem);
        if (playerToNotify == null && notifyPlayer) {
            playerToNotify = Bukkit.getPlayer((UUID)sellingItem.getPlayerUUID());
        }
        if (this.items.remove(sellingItem.getSlot()) != null) {
            if (sellingItem.equals(this.sponsor)) {
                this.sponsor = null;
            }
            this.updateInventory();
            if (giveBack && playerToNotify != null) {
                HashMap r = playerToNotify.getInventory().addItem(new ItemStack[]{sellingItem.getItem()});
                if (r.values().size() > 0) {
                    if (notifyPlayer) {
                        playerToNotify.sendMessage(InternalUtil.CONFIGMANAGER.getFullInvDrop());
                    }
                    for (ItemStack t : r.values()) {
                        playerToNotify.getWorld().dropItemNaturally(playerToNotify.getLocation(), t);
                    }
                } else if (notifyPlayer) {
                    playerToNotify.sendMessage(InternalUtil.CONFIGMANAGER.getRemoveItem(sellingItem.getPrice(), sellingItem.getItem().getType().toString(), sellingItem.getItem().getAmount()));
                }
            }
        }
        this.applyChangesDB();
    }

    public ItemStack generateMapItem(boolean isSponsoring, @Nullable SellingItem sellingItem) {
        ItemStack mapItem;
        if (this.sponsor != null && this.sponsor.equals(sellingItem)) {
            mapItem = new ItemStack(Material.FILLED_MAP);
            ItemMeta m = mapItem.getItemMeta();
            Objects.requireNonNull(m).setDisplayName(InternalUtil.CONFIGMANAGER.getSponsorButtonTitle());
            m.setLore(InternalUtil.CONFIGMANAGER.getSponsoredLore());
            mapItem.setItemMeta(m);
        } else if (this.canSponsor()) {
            if (isSponsoring) {
                mapItem = new ItemStack(Material.FILLED_MAP);
                ItemMeta m = mapItem.getItemMeta();
                Objects.requireNonNull(m).setDisplayName(InternalUtil.CONFIGMANAGER.getSponsorButtonTitle());
                if (this.sponsor != null) {
                    m.setLore(InternalUtil.CONFIGMANAGER.getSponsoringChange());
                } else {
                    m.setLore(InternalUtil.CONFIGMANAGER.getSponsoring());
                }
                mapItem.setItemMeta(m);
            } else {
                mapItem = new ItemStack(Material.PAPER);
                ItemMeta m = mapItem.getItemMeta();
                Objects.requireNonNull(m).setDisplayName(InternalUtil.CONFIGMANAGER.getSponsorButtonTitle());
                if (this.sponsor != null) {
                    m.setLore(InternalUtil.CONFIGMANAGER.getNotSponsoringChange());
                } else {
                    m.setLore(InternalUtil.CONFIGMANAGER.getNotSponsoring());
                }
                mapItem.setItemMeta(m);
            }
        } else {
            mapItem = new ItemStack(Material.FILLED_MAP);
            ItemMeta m = mapItem.getItemMeta();
            Objects.requireNonNull(m).setDisplayName(InternalUtil.CONFIGMANAGER.getSponsorButtonTitle());
            m.setLore(InternalUtil.CONFIGMANAGER.getWaitToSponsor(this.getMissTimeInMins()));
            mapItem.setItemMeta(m);
        }
        return mapItem.clone();
    }

    public void setSponsor(@NotNull SellingItem sellingItem) {
        Objects.requireNonNull(sellingItem);
        if (this.getItems().contains(sellingItem)) {
            this.applySponsor();
            this.sponsor = sellingItem;
            this.updateInventory();
            this.applyChangesDB();
        }
    }

    public void setSponsor(int slot) {
        if (this.getItemAt(slot) != null) {
            this.setSponsor(this.getItemAt(slot));
        }
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void emptyItems() {
        this.items.clear();
        this.applyChangesDB();
    }

    public SellingItem getSponsor() {
        return this.sponsor;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public int getUnlockedSlotsNumber() {
        return this.unlockedSlotsNumber;
    }

    public ArrayList<SellingItem> getItems() {
        return new ArrayList<SellingItem>(this.items.values());
    }

    public ArrayList<String> getOffMessages() {
        return new ArrayList<String>(this.offMessages);
    }

    public void addMessage(@NotNull String message) {
        Objects.requireNonNull(message);
        this.offMessages.add(message);
        this.applyChangesDB();
    }

    public void clearMessages() {
        this.offMessages.clear();
    }

    public void applyChangesDB() {
        RoadsideShops.saveShop(this);
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        if (e.getInventory().getHolder() == this) {
            this.viewers.remove(e.getPlayer());
        }
    }

    public HashMap<Player, ViewMode> getViewers() {
        return this.viewers;
    }
}

