/*
 * Decompiled with CFR 0.152.
 */
package it.escanortargaryen.roadsideshop.inventory;

import it.escanortargaryen.roadsideshop.InternalUtil;
import it.escanortargaryen.roadsideshop.RoadsideShops;
import it.escanortargaryen.roadsideshop.classes.SellingItem;
import it.escanortargaryen.roadsideshop.classes.Shop;
import it.escanortargaryen.roadsideshop.classes.ViewMode;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class ItemSettings
implements InventoryHolder,
Listener {
    private final Shop shop;
    private final SellingItem sellingItem;
    private boolean isSponsoring = false;
    private boolean isInventoryClosing = false;

    public ItemSettings(@NotNull Shop shop, @NotNull SellingItem sellingItem, @NotNull Player player) {
        Objects.requireNonNull(shop);
        Objects.requireNonNull(sellingItem);
        Objects.requireNonNull(player);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)RoadsideShops.INSTANCE);
        this.shop = shop;
        this.sellingItem = sellingItem;
        player.openInventory(this.getInventory());
    }

    @NotNull
    public Inventory getInventory() {
        Inventory inv = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)InternalUtil.CONFIGMANAGER.getItemModify());
        ItemStack t = this.sellingItem.getWithPriceSeller().clone();
        ItemMeta tt = t.getItemMeta();
        List a = Objects.requireNonNull(tt).getLore();
        Objects.requireNonNull(a).remove(a.size() - 1);
        a.remove(a.size() - 1);
        tt.setLore(a);
        t.setItemMeta(tt);
        inv.setItem(4, t);
        inv.setItem(20, InternalUtil.BACKARROW);
        inv.setItem(22, this.shop.generateMapItem(this.isSponsoring, this.sellingItem));
        ItemStack remove = new ItemStack(Material.RED_STAINED_GLASS);
        ItemMeta rem = remove.getItemMeta();
        Objects.requireNonNull(rem).setDisplayName(InternalUtil.CONFIGMANAGER.getRemoveButtonTitle());
        rem.setLore(InternalUtil.CONFIGMANAGER.getRemoveButtonLore());
        remove.setItemMeta(rem);
        inv.setItem(24, remove);
        return inv;
    }

    @EventHandler
    private void onClick(InventoryClickEvent e) {
        Inventory topInventory = InternalUtil.getTopInventory(e);
        final Player player = (Player)e.getWhoClicked();
        if (topInventory.getHolder() != this) {
            return;
        }
        e.setCancelled(true);
        if (e.getClickedInventory() == null || e.getCurrentItem() == null || e.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        if (e.getClickedInventory().getHolder() != this) {
            return;
        }
        if (e.getSlot() == 20) {
            player.closeInventory();
            new BukkitRunnable(){

                public void run() {
                    ItemSettings.this.shop.openInventory(player, ViewMode.SELLER);
                }
            }.runTask((Plugin)RoadsideShops.INSTANCE);
        }
        if (e.getSlot() == 24) {
            this.isInventoryClosing = true;
            this.shop.removeItem(this.sellingItem, player);
            player.closeInventory();
            new BukkitRunnable(){

                public void run() {
                    ItemSettings.this.shop.openInventory(player, ViewMode.SELLER);
                }
            }.runTask((Plugin)RoadsideShops.INSTANCE);
        }
        if (e.getSlot() == 22 && this.shop.canSponsor() && (this.shop.getSponsor() == null || !this.shop.getSponsor().equals(this.sellingItem))) {
            this.isSponsoring = !this.isSponsoring;
            e.getInventory().setItem(22, this.shop.generateMapItem(this.isSponsoring, this.sellingItem));
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        if (e.getInventory().getHolder() == this) {
            if (!(this.isInventoryClosing || this.shop.getSponsor() != null && this.shop.getSponsor().equals(this.sellingItem) || !this.isSponsoring)) {
                e.getPlayer().sendMessage(InternalUtil.CONFIGMANAGER.getSponsorSet(this.sellingItem.getPrice(), this.sellingItem.getItem().getType().toString(), this.sellingItem.getItem().getAmount()));
                this.shop.setSponsor(this.sellingItem);
            }
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
        }
    }
}

