/*
 * Decompiled with CFR 0.152.
 */
package it.escanortargaryen.roadsideshop.managers;

import it.escanortargaryen.roadsideshop.InternalUtil;
import it.escanortargaryen.roadsideshop.RoadsideShops;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.naming.ConfigurationException;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ConfigManager {
    private final YamlConfiguration config;
    private String priceMessage;
    private String unlockedSlotPanelTitle;
    private List<String> unlockedSlotPanelLore;
    private String lockedSlotPanelTitle;
    private List<String> lockedSlotPanelLore;
    private String putItem;
    private String sponsorSet;
    private String noAdv;
    private String removeItem;
    private String boughtMessage;
    private String sellerMessage;
    public static long SPONSORTIME;
    public static String SHOPCOMMAND;
    public static String NEWSPAPERCOMMAND;
    private int unlockedSlots;
    private String sponsorButtonTitle;
    private List<String> sponsoring;
    private List<String> sponsoringChange;
    private List<String> notSponsoring;
    private List<String> notSponsoringChange;
    private List<String> waitToSponsor;
    private String whileOffline;
    private String leftArrowTitle;
    private String rightArrowTitle;
    private String newspaperTitle;
    private String shopTitle;
    private String itemSettingsTitle;
    private String sellButtonTitle;
    private String priceButtonTitle;
    private String sellButtonTitleNotSet;
    private String priceButtonTitleNotSet;
    private String wrongPrice;
    private String anvilTitle;
    private String itemModify;
    private String backButtonTitle;
    private String removeButtonTitle;
    private String fullInvDrop;
    private String fullInvNoDrop;
    private String noShop;
    private String noMoney;
    private List<String> sponsoredLore;
    private List<String> leftArrowLore;
    private List<String> rightArrowLore;
    private List<String> itemSaleSeller;
    private List<String> itemSaleBuyer;
    private List<String> itemSaleSellerSponsor;
    private List<String> itemSaleBuyerSponsor;
    private List<String> loreForNewspaper;
    private List<String> sellButtonLore;
    private List<String> priceButtonLore;
    private List<String> sellButtonLoreNotSet;
    private List<String> priceButtonLoreNotSet;
    private List<String> backButtonLore;
    private List<String> removeButtonLore;

    public ConfigManager(@NotNull Plugin pl) {
        Objects.requireNonNull(pl);
        File c = new File(String.valueOf(pl.getDataFolder()) + "/config.yml");
        this.config = YamlConfiguration.loadConfiguration((File)c);
        try {
            this.loadAndValidateConfig();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            RoadsideShops.INSTANCE.getServer().getPluginManager().disablePlugin((Plugin)RoadsideShops.INSTANCE);
        }
    }

    public void loadAndValidateConfig() throws ConfigurationException {
        String notSet = "is not set in config.yml";
        if (!this.config.isSet("shop-command")) {
            throw new ConfigurationException("shop-command " + notSet);
        }
        SHOPCOMMAND = Objects.requireNonNull(this.config.getString("shop-command")).replace(" ", "");
        if (!this.config.isSet("newspaper-command")) {
            throw new ConfigurationException("newspaper-command " + notSet);
        }
        NEWSPAPERCOMMAND = Objects.requireNonNull(this.config.getString("newspaper-command")).replace(" ", "");
        if (!this.config.isSet("price-message")) {
            throw new ConfigurationException("price-message " + notSet);
        }
        this.priceMessage = this.config.getString("price-message");
        if (!this.config.isSet("unlocked-slot-panel-title")) {
            throw new ConfigurationException("unlocked-slot-panel-title " + notSet);
        }
        this.unlockedSlotPanelTitle = this.config.getString("unlocked-slot-panel-title");
        if (!this.config.isSet("unlocked-slot-lore")) {
            throw new ConfigurationException("unlocked-slot-lore " + notSet);
        }
        this.unlockedSlotPanelLore = this.config.getStringList("unlocked-slot-lore");
        if (!this.config.isSet("locked-slot-panel-title")) {
            throw new ConfigurationException("locked-slot-panel-title " + notSet);
        }
        this.lockedSlotPanelTitle = this.config.getString("locked-slot-panel-title");
        if (!this.config.isSet("locked-slot-lore")) {
            throw new ConfigurationException("locked-slot-lore " + notSet);
        }
        this.lockedSlotPanelLore = this.config.getStringList("locked-slot-lore");
        if (!this.config.isSet("put-item")) {
            throw new ConfigurationException("put-item " + notSet);
        }
        this.putItem = this.config.getString("put-item");
        if (!this.config.isSet("sponsor-set")) {
            throw new ConfigurationException("sponsor-set " + notSet);
        }
        this.sponsorSet = this.config.getString("sponsor-set");
        if (!this.config.isSet("no-adv")) {
            throw new ConfigurationException("no-adv " + notSet);
        }
        this.noAdv = this.config.getString("no-adv");
        if (!this.config.isSet("remove-item")) {
            throw new ConfigurationException("remove-item " + notSet);
        }
        this.removeItem = this.config.getString("remove-item");
        if (!this.config.isSet("bought-message")) {
            throw new ConfigurationException("bought-message " + notSet);
        }
        this.boughtMessage = this.config.getString("bought-message");
        if (!this.config.isSet("seller-message")) {
            throw new ConfigurationException("seller-message " + notSet);
        }
        this.sellerMessage = this.config.getString("seller-message");
        if (!this.config.isSet("sponsor-time")) {
            throw new ConfigurationException("sponsor-time " + notSet);
        }
        SPONSORTIME = this.config.getLong("sponsor-time");
        if (SPONSORTIME < 0L) {
            throw new ConfigurationException("sponsor-time could not be negative");
        }
        if (!this.config.isSet("sponsor-button.title")) {
            throw new ConfigurationException("sponsor-button.title " + notSet);
        }
        this.sponsorButtonTitle = this.config.getString("sponsor-button.title");
        if (!this.config.isSet("sponsor-button.sponsoring")) {
            throw new ConfigurationException("sponsor-button.sponsoring " + notSet);
        }
        this.sponsoring = this.config.getStringList("sponsor-button.sponsoring");
        if (!this.config.isSet("sponsor-button.sponsoring-change")) {
            throw new ConfigurationException("sponsor-button.sponsoring-change " + notSet);
        }
        this.sponsoringChange = this.config.getStringList("sponsor-button.sponsoring-change");
        if (!this.config.isSet("sponsor-button.not-sponsoring")) {
            throw new ConfigurationException("sponsor-button.not-sponsoring " + notSet);
        }
        this.notSponsoring = this.config.getStringList("sponsor-button.not-sponsoring");
        if (!this.config.isSet("sponsor-button.not-sponsoring-change")) {
            throw new ConfigurationException("sponsor-button.not-sponsoring-change " + notSet);
        }
        this.notSponsoringChange = this.config.getStringList("sponsor-button.not-sponsoring-change");
        if (!this.config.isSet("sponsor-button.wait")) {
            throw new ConfigurationException("sponsor-button.wait " + notSet);
        }
        this.waitToSponsor = this.config.getStringList("sponsor-button.wait");
        if (!this.config.isSet("newspaper.arrows.right.lore")) {
            throw new ConfigurationException("newspaper.arrows.right.lore " + notSet);
        }
        this.rightArrowLore = this.config.getStringList("newspaper.arrows.right.lore");
        if (!this.config.isSet("newspaper.arrows.left.lore")) {
            throw new ConfigurationException("newspaper.arrows.left.lore " + notSet);
        }
        this.leftArrowLore = this.config.getStringList("newspaper.arrows.left.lore");
        if (!this.config.isSet("newspaper.arrows.left.title")) {
            throw new ConfigurationException("newspaper.arrows.left.title " + notSet);
        }
        this.leftArrowTitle = this.config.getString("newspaper.arrows.left.title");
        if (!this.config.isSet("newspaper.arrows.right.title")) {
            throw new ConfigurationException("newspaper.arrows.right.title " + notSet);
        }
        this.rightArrowTitle = this.config.getString("newspaper.arrows.right.title");
        if (!this.config.isSet("newspaper.title")) {
            throw new ConfigurationException("newspaper.title " + notSet);
        }
        this.newspaperTitle = this.config.getString("newspaper.title");
        if (!this.config.isSet("item-sale-lore.seller")) {
            throw new ConfigurationException("item-sale-lore.seller " + notSet);
        }
        this.itemSaleSeller = this.config.getStringList("item-sale-lore.seller");
        if (!this.config.isSet("item-sale-lore.buyer")) {
            throw new ConfigurationException("item-sale-lore.buyer " + notSet);
        }
        this.itemSaleBuyer = this.config.getStringList("item-sale-lore.buyer");
        if (!this.config.isSet("item-sale-lore.seller-sponsor")) {
            throw new ConfigurationException("item-sale-lore.seller-sponsor " + notSet);
        }
        this.itemSaleSellerSponsor = this.config.getStringList("item-sale-lore.seller-sponsor");
        if (!this.config.isSet("item-sale-lore.buyer-sponsor")) {
            throw new ConfigurationException("item-sale-lore.buyer-sponsor " + notSet);
        }
        this.itemSaleBuyerSponsor = this.config.getStringList("item-sale-lore.buyer-sponsor");
        if (!this.config.isSet("item-sale-lore.newspaper")) {
            throw new ConfigurationException("item-sale-lore.newspaper " + notSet);
        }
        this.loreForNewspaper = this.config.getStringList("item-sale-lore.newspaper");
        if (!this.config.isSet("shop-title")) {
            throw new ConfigurationException("shop-title " + notSet);
        }
        this.shopTitle = this.config.getString("shop-title");
        if (!this.config.isSet("item-settings.title")) {
            throw new ConfigurationException("item-settings.title " + notSet);
        }
        this.itemSettingsTitle = this.config.getString("item-settings.title");
        if (!this.config.isSet("unlocked-slot")) {
            throw new ConfigurationException("unlocked-slot " + notSet);
        }
        this.unlockedSlots = this.config.getInt("unlocked-slot");
        if (this.unlockedSlots < 0 || this.unlockedSlots > 14) {
            throw new ConfigurationException("unlocked-slot must be positive and less than 15");
        }
        if (!this.config.isSet("item-settings.sell-button-price-set.title")) {
            throw new ConfigurationException("item-settings.sell-button-price-set.title " + notSet);
        }
        this.sellButtonTitle = this.config.getString("item-settings.sell-button-price-set.title");
        if (!this.config.isSet("item-settings.sell-button-price-set.lore")) {
            throw new ConfigurationException("item-settings.sell-button-price-set.lore " + notSet);
        }
        this.sellButtonLore = this.config.getStringList("item-settings.sell-button-price-set.lore");
        if (!this.config.isSet("item-settings.price-button-set.title")) {
            throw new ConfigurationException("item-settings.price-button-set-set.title " + notSet);
        }
        this.priceButtonTitle = this.config.getString("item-settings.price-button-set.title");
        if (!this.config.isSet("item-settings.price-button-set.lore")) {
            throw new ConfigurationException("item-settings.price-button-set.lore " + notSet);
        }
        this.priceButtonLore = this.config.getStringList("item-settings.price-button-set.lore");
        if (!this.config.isSet("item-settings.sell-button-price-not-set.title")) {
            throw new ConfigurationException("item-settings.sell-button-price-not-set-set.title " + notSet);
        }
        this.sellButtonTitleNotSet = this.config.getString("item-settings.sell-button-price-not-set.title");
        if (!this.config.isSet("item-settings.sell-button-price-not-set.lore")) {
            throw new ConfigurationException("item-settings.sell-button-price-not-set.lore " + notSet);
        }
        this.sellButtonLoreNotSet = this.config.getStringList("item-settings.sell-button-price-not-set.lore");
        if (!this.config.isSet("item-settings.price-button-not-set.title")) {
            throw new ConfigurationException("item-settings.price-button-not-set-set.title " + notSet);
        }
        this.priceButtonTitleNotSet = this.config.getString("item-settings.price-button-not-set.title");
        if (!this.config.isSet("item-settings.price-button-not-set.lore")) {
            throw new ConfigurationException("item-settings.price-button-not-set.lore " + notSet);
        }
        this.priceButtonLoreNotSet = this.config.getStringList("item-settings.price-button-not-set.lore");
        if (!this.config.isSet("wrong-price")) {
            throw new ConfigurationException("wrong-price " + notSet);
        }
        this.wrongPrice = this.config.getString("wrong-price");
        if (!this.config.isSet("anvil-title")) {
            throw new ConfigurationException("anvil-title " + notSet);
        }
        this.anvilTitle = this.config.getString("anvil-title");
        if (!this.config.isSet("item-modify.title")) {
            throw new ConfigurationException("item-modify.title " + notSet);
        }
        this.itemModify = this.config.getString("item-modify.title");
        if (!this.config.isSet("item-modify.back-button.title")) {
            throw new ConfigurationException("item-modify.back-button.title " + notSet);
        }
        this.backButtonTitle = this.config.getString("item-modify.back-button.title");
        if (!this.config.isSet("item-modify.back-button.lore")) {
            throw new ConfigurationException("item-modify.back-button.lore " + notSet);
        }
        this.backButtonLore = this.config.getStringList("item-modify.back-button.lore");
        if (!this.config.isSet("item-modify.remove-button.title")) {
            throw new ConfigurationException("item-modify.remove-button.title " + notSet);
        }
        this.removeButtonTitle = this.config.getString("item-modify.remove-button.title");
        if (!this.config.isSet("item-modify.remove-button.lore")) {
            throw new ConfigurationException("item-modify.remove-button.lore " + notSet);
        }
        this.removeButtonLore = this.config.getStringList("item-modify.remove-button.lore");
        if (!this.config.isSet("item-modify.full-inv-drop")) {
            throw new ConfigurationException("item-modify.full-inv-drop " + notSet);
        }
        this.fullInvDrop = this.config.getString("item-modify.full-inv-drop");
        if (!this.config.isSet("item-modify.full-inv-no-drop")) {
            throw new ConfigurationException("item-modify.full-inv-no-drop " + notSet);
        }
        this.fullInvNoDrop = this.config.getString("item-modify.full-inv-no-drop");
        if (!this.config.isSet("no-shop")) {
            throw new ConfigurationException("no-shop " + notSet);
        }
        this.noShop = this.config.getString("no-shop");
        if (!this.config.isSet("no-money")) {
            throw new ConfigurationException("no-money " + notSet);
        }
        this.noMoney = this.config.getString("no-money");
        if (!this.config.isSet("sponsor-button.sponsored")) {
            throw new ConfigurationException("sponsor-button.sponsored " + notSet);
        }
        this.sponsoredLore = this.config.getStringList("sponsor-button.sponsored");
        if (!this.config.isSet("while-offline")) {
            throw new ConfigurationException("while-offline " + notSet);
        }
        this.whileOffline = this.config.getString("while-offline");
    }

    public String getWhileOffline() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.whileOffline);
    }

    public List<String> getSponsoredLore() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String i : this.sponsoredLore) {
            ret.add(ChatColor.translateAlternateColorCodes((char)'&', (String)i.replace("<minutes>", "" + SPONSORTIME / 60L)));
        }
        return ret;
    }

    public String getNoMoney() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.noMoney);
    }

    public String getNoShop() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.noShop);
    }

    public String getFullInvDrop() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.fullInvDrop);
    }

    public String getFullInvNoDrop() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.fullInvNoDrop);
    }

    public String getRemoveButtonTitle() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.removeButtonTitle);
    }

    public List<String> getRemoveButtonLore() {
        ArrayList<String> t = new ArrayList<String>();
        for (String s : this.removeButtonLore) {
            t.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        }
        return t;
    }

    public List<String> getBackButtonLore() {
        ArrayList<String> t = new ArrayList<String>();
        for (String s : this.backButtonLore) {
            t.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        }
        return t;
    }

    public String getBackButtonTitle() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.backButtonTitle);
    }

    public String getItemModify() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.itemModify);
    }

    public String getAnvilTitle() {
        return this.anvilTitle;
    }

    public String getWrongPrice() {
        return this.wrongPrice;
    }

    public String getSellButtonTitle() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.sellButtonTitle);
    }

    public List<String> getPriceButtonLore(double price) {
        ArrayList<String> t = new ArrayList<String>();
        for (String s : this.priceButtonLore) {
            t.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s.replace("<price-message>", InternalUtil.CONFIGMANAGER.getPriceMessage(price))));
        }
        return t;
    }

    public List<String> getSellButtonLore() {
        ArrayList<String> t = new ArrayList<String>();
        for (String s : this.sellButtonLore) {
            t.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        }
        return t;
    }

    public String getPriceButtonTitleNotSet() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.priceButtonTitleNotSet);
    }

    public String getSellButtonTitleNotSet() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.sellButtonTitleNotSet);
    }

    public List<String> getPriceButtonLoreNotSet() {
        ArrayList<String> t = new ArrayList<String>();
        for (String s : this.priceButtonLoreNotSet) {
            t.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        }
        return t;
    }

    public String getPriceButtonTitle(double price) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.priceButtonTitle.replace("<price-message>", InternalUtil.CONFIGMANAGER.getPriceMessage(price)));
    }

    public List<String> getSellButtonLoreNotSet() {
        ArrayList<String> t = new ArrayList<String>();
        for (String s : this.sellButtonLoreNotSet) {
            t.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        }
        return t;
    }

    public int getUnlockedSlots() {
        return this.unlockedSlots;
    }

    public List<String> getItemSaleBuyer(double price) {
        ArrayList<String> t = new ArrayList<String>();
        for (String s : this.itemSaleBuyer) {
            t.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s).replace("<price>", "" + price).replace("<price-message>", this.getPriceMessage(price)));
        }
        return t;
    }

    public String getItemSettingsTitle() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.itemSettingsTitle);
    }

    public List<String> getItemSaleBuyerSponsor(double price) {
        ArrayList<String> t = new ArrayList<String>();
        for (String s : this.itemSaleBuyerSponsor) {
            t.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s).replace("<price>", "" + price).replace("<price-message>", this.getPriceMessage(price)));
        }
        return t;
    }

    public List<String> getItemSaleSellerSponsor(double price) {
        ArrayList<String> t = new ArrayList<String>();
        for (String s : this.itemSaleSellerSponsor) {
            t.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s).replace("<price>", "" + price).replace("<price-message>", this.getPriceMessage(price)));
        }
        return t;
    }

    public List<String> getItemSaleSeller(double price) {
        ArrayList<String> t = new ArrayList<String>();
        for (String s : this.itemSaleSeller) {
            t.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s).replace("<price>", "" + price).replace("<price-message>", this.getPriceMessage(price)));
        }
        return t;
    }

    public List<String> getLoreForNewspaper(double price, String ownerName) {
        ArrayList<String> t = new ArrayList<String>();
        for (String s : this.loreForNewspaper) {
            t.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s).replace("<price>", "" + price).replace("<price-message>", this.getPriceMessage(price)).replace("<ownerName>", ownerName));
        }
        return t;
    }

    public List<String> getLeftArrowLore() {
        ArrayList<String> t = new ArrayList<String>();
        for (String s : this.leftArrowLore) {
            t.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        }
        return t;
    }

    public String getLeftArrowTitle() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.leftArrowTitle);
    }

    public String getNewspaperTitle() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.newspaperTitle);
    }

    public List<String> getRightArrowLore() {
        ArrayList<String> t = new ArrayList<String>();
        for (String s : this.rightArrowLore) {
            t.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        }
        return t;
    }

    public String getRightArrowTitle() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.rightArrowTitle);
    }

    public String getPriceMessage(double price) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.priceMessage.replace("<value>", "" + price));
    }

    public String getUnlockedSlotPanelTitle() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.unlockedSlotPanelTitle);
    }

    public List<String> getUnlockedSlotPanelLore() {
        ArrayList<String> t = new ArrayList<String>();
        for (String s : this.unlockedSlotPanelLore) {
            t.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        }
        return t;
    }

    public String getLockedSlotPanelTitle() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.lockedSlotPanelTitle);
    }

    public List<String> getLockedSlotPanelLore() {
        ArrayList<String> t = new ArrayList<String>();
        for (String s : this.lockedSlotPanelLore) {
            t.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        }
        return t;
    }

    public String getPutItem(double price, String type, int amount) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.putItem.replace("<price>", "" + price).replace("<type>", type.toLowerCase().replace("_", " ")).replace("<amount>", "" + amount));
    }

    public String getSponsorSet(double price, String type, int amount) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.sponsorSet.replace("<price>", "" + price).replace("<type>", type.toLowerCase().replace("_", " ")).replace("<amount>", "" + amount));
    }

    public String getNoAdv() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.noAdv);
    }

    public String getShopTitle(String owner) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.shopTitle.replace("<playerName>", owner));
    }

    public String getRemoveItem(double price, String type, int amount) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.removeItem.replace("<price>", "" + price).replace("<type>", type.toLowerCase().replace("_", " ")).replace("<amount>", "" + amount));
    }

    public String getBoughtMessage(double price, String type, int amount, String name) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.boughtMessage.replace("<price>", "" + price).replace("<type>", type.toLowerCase().replace("_", " ")).replace("<amount>", "" + amount).replace("<name>", name));
    }

    public String getSellerMessage(double price, String type, int amount, String name) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.sellerMessage.replace("<price>", "" + price).replace("<type>", type.toLowerCase().replace("_", " ")).replace("<amount>", "" + amount).replace("<name>", name));
    }

    public String getSponsorButtonTitle() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.sponsorButtonTitle);
    }

    public List<String> getNotSponsoring() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String i : this.notSponsoring) {
            ret.add(ChatColor.translateAlternateColorCodes((char)'&', (String)i.replace("<minutes>", "" + SPONSORTIME / 60L)));
        }
        return ret;
    }

    public List<String> getNotSponsoringChange() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String i : this.notSponsoringChange) {
            ret.add(ChatColor.translateAlternateColorCodes((char)'&', (String)i.replace("<minutes>", "" + SPONSORTIME / 60L)));
        }
        return ret;
    }

    public List<String> getSponsoring() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String i : this.sponsoring) {
            ret.add(ChatColor.translateAlternateColorCodes((char)'&', (String)i.replace("<minutes>", "" + SPONSORTIME / 60L)));
        }
        return ret;
    }

    public List<String> getSponsoringChange() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String i : this.sponsoringChange) {
            ret.add(ChatColor.translateAlternateColorCodes((char)'&', (String)i.replace("<minutes>", "" + SPONSORTIME / 60L)));
        }
        return ret;
    }

    public List<String> getWaitToSponsor(long minuteToSponsor) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String i : this.waitToSponsor) {
            ret.add(ChatColor.translateAlternateColorCodes((char)'&', (String)i.replace("<minutes>", "" + SPONSORTIME / 60L).replace("<missToSponsor>", "" + minuteToSponsor)));
        }
        return ret;
    }
}

