/*
 * Decompiled with CFR 0.152.
 */
package org.savekl.mknockback;

import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.savekl.mknockback.Mknockback;

public class CommandHandler
implements CommandExecutor {
    private final Mknockback plugin;

    public CommandHandler(Mknockback plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("mkb")) {
            return false;
        }
        if (args.length == 0) {
            this.showStatus(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "status": {
                this.showStatus(sender);
                break;
            }
            case "on": {
                this.enablePlugin(sender);
                break;
            }
            case "off": {
                this.disablePlugin(sender);
                break;
            }
            case "restart": {
                this.restartPlugin(sender);
                break;
            }
            default: {
                sender.sendMessage(ChatColor.RED + "\u672a\u77e5\u547d\u4ee4\uff01\u4f7f\u7528: /mkb [status|on|off|restart]");
                return false;
            }
        }
        return true;
    }

    private void showStatus(CommandSender sender) {
        sender.sendMessage(ChatColor.GOLD + "=== Mknockback \u63d2\u4ef6\u72b6\u6001 ===");
        sender.sendMessage(ChatColor.GREEN + "\u7248\u672c: " + this.plugin.getDescription().getVersion());
        sender.sendMessage(ChatColor.GREEN + "\u72b6\u6001: " + (this.plugin.isPluginEnabled() ? ChatColor.GREEN + "\u542f\u7528" : ChatColor.RED + "\u7981\u7528"));
        sender.sendMessage(ChatColor.GOLD + "========================");
        sender.sendMessage(ChatColor.YELLOW + "\u4f7f\u7528\u6307\u4ee4:");
        sender.sendMessage(ChatColor.YELLOW + "/mkb on - \u542f\u7528\u63d2\u4ef6");
        sender.sendMessage(ChatColor.YELLOW + "/mkb off - \u7981\u7528\u63d2\u4ef6");
        sender.sendMessage(ChatColor.YELLOW + "/mkb restart - \u91cd\u542f\u63d2\u4ef6");
    }

    private void enablePlugin(CommandSender sender) {
        if (this.plugin.isPluginEnabled()) {
            sender.sendMessage(ChatColor.YELLOW + "\u63d2\u4ef6\u5df2\u7ecf\u662f\u542f\u7528\u72b6\u6001\uff01");
            return;
        }
        this.plugin.setPluginEnabled(true);
        sender.sendMessage(ChatColor.GREEN + "Mknockback \u63d2\u4ef6\u5df2\u542f\u7528\uff01");
    }

    private void disablePlugin(CommandSender sender) {
        if (!this.plugin.isPluginEnabled()) {
            sender.sendMessage(ChatColor.YELLOW + "\u63d2\u4ef6\u5df2\u7ecf\u662f\u7981\u7528\u72b6\u6001\uff01");
            return;
        }
        this.plugin.setPluginEnabled(false);
        sender.sendMessage(ChatColor.RED + "Mknockback \u63d2\u4ef6\u5df2\u7981\u7528\uff01");
    }

    private void restartPlugin(CommandSender sender) {
        sender.sendMessage(ChatColor.GOLD + "\u6b63\u5728\u91cd\u542f Mknockback \u63d2\u4ef6...");
        this.plugin.setPluginEnabled(false);
        this.plugin.setPluginEnabled(true);
        sender.sendMessage(ChatColor.GREEN + "Mknockback \u63d2\u4ef6\u91cd\u542f\u5b8c\u6210\uff01");
    }
}

