/*
 * Decompiled with CFR 0.152.
 */
package org.savekl.mknockback;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.savekl.mknockback.CommandHandler;

public class Mknockback
extends JavaPlugin
implements Listener {
    private static Mknockback instance;
    private boolean pluginEnabled = true;
    private final Map<UUID, PlayerData> playerDataMap = new ConcurrentHashMap<UUID, PlayerData>();
    private final Map<UUID, Integer> violationCountMap = new ConcurrentHashMap<UUID, Integer>();
    private final Set<UUID> admins = ConcurrentHashMap.newKeySet();
    private static final String DEVELOPER_NAME = "MB_BBIT";
    private static final int MAX_VIOLATIONS = 3;
    private static final double SUSPICIOUS_DISTANCE = 8.0;
    private static final double EXTREME_DISTANCE = 15.0;

    public void onEnable() {
        instance = this;
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("mkb").setExecutor((CommandExecutor)new CommandHandler(this));
        new BukkitRunnable(){

            public void run() {
                Mknockback.this.cleanupData();
            }
        }.runTaskTimer((Plugin)this, 1200L, 1200L);
        this.getLogger().info("=====================================");
        this.getLogger().info("Mknockback Plugin Loaded!");
        this.getLogger().info("Version: " + this.getDescription().getVersion());
        this.getLogger().info("Fixing knockback issues for 1.12-1.16");
        this.getLogger().info("=====================================");
    }

    public void onDisable() {
        this.playerDataMap.clear();
        this.violationCountMap.clear();
        this.admins.clear();
        this.getLogger().info("Mknockback Plugin Disabled!");
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Location serverLocation;
        double distance;
        if (!this.pluginEnabled) {
            return;
        }
        if (!(event.getEntity() instanceof Player) || !(event.getDamager() instanceof Player)) {
            return;
        }
        Player victim = (Player)event.getEntity();
        Player attacker = (Player)event.getDamager();
        PlayerData victimData = this.getPlayerData(victim);
        Location predictedLocation = this.predictPlayerLocation(victimData);
        if (predictedLocation != null && (distance = predictedLocation.distance(serverLocation = victim.getLocation())) > 1.5) {
            victim.teleport(predictedLocation);
            this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {}, 1L);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Location to;
        if (!this.pluginEnabled) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        Location from = event.getFrom();
        if (from.distanceSquared(to = event.getTo()) < 0.01) {
            return;
        }
        PlayerData playerData = this.getPlayerData(player);
        playerData.updatePosition(to, System.currentTimeMillis());
        Vector movement = to.toVector().subtract(from.toVector());
        playerData.setMovementVector(movement);
        this.checkSuspiciousMovement(player, from, to);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        this.getPlayerData(player);
        if (player.getName().equals(DEVELOPER_NAME)) {
            this.getServer().broadcastMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "\u5f00\u53d1\u8005 " + ChatColor.AQUA + DEVELOPER_NAME + ChatColor.GOLD + "" + ChatColor.BOLD + " \u6765\u4e86\uff01");
        }
        if (player.hasPermission("mknockback.admin") || player.isOp()) {
            this.admins.add(playerUUID);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        this.playerDataMap.remove(playerUUID);
        this.violationCountMap.remove(playerUUID);
        this.admins.remove(playerUUID);
    }

    private PlayerData getPlayerData(Player player) {
        UUID playerUUID = player.getUniqueId();
        return this.playerDataMap.computeIfAbsent(playerUUID, uuid -> new PlayerData(player.getLocation(), System.currentTimeMillis()));
    }

    private Location predictPlayerLocation(PlayerData playerData) {
        if (playerData == null) {
            return null;
        }
        long timeDiff = System.currentTimeMillis() - playerData.getLastUpdateTime();
        if (timeDiff > 500L) {
            return null;
        }
        if (playerData.getMovementVector() == null) {
            return playerData.getLastLocation().clone();
        }
        double timeFactor = (double)timeDiff / 50.0;
        Vector predictedOffset = playerData.getMovementVector().clone().multiply(timeFactor);
        return playerData.getLastLocation().clone().add(predictedOffset);
    }

    private void checkSuspiciousMovement(Player player, Location from, Location to) {
        double distanceSquared = from.distanceSquared(to);
        double distance = Math.sqrt(distanceSquared);
        if (distance > 8.0) {
            int violationLevel = 1;
            if (distance > 15.0) {
                violationLevel = 2;
            }
            this.handleViolation(player, from, to, violationLevel, distance);
        }
        if (!(player.isFlying() || player.isGliding() || player.isOnGround())) {
            this.checkFallThrough(player, to);
        }
    }

    private void handleViolation(Player player, Location from, Location to, int violationLevel, double distance) {
        UUID playerUUID = player.getUniqueId();
        int currentViolations = this.violationCountMap.getOrDefault(playerUUID, 0) + violationLevel;
        this.violationCountMap.put(playerUUID, currentViolations);
        this.getLogger().warning("Player " + player.getName() + " violation detected! Distance: " + String.format("%.2f", distance) + " blocks, Level: " + violationLevel + ", Total violations: " + currentViolations);
        this.sendAdminAlert(player, from, to, violationLevel, distance, currentViolations);
        player.teleport(from);
        if (currentViolations >= 3) {
            this.getServer().getScheduler().runTask((Plugin)this, () -> player.kickPlayer(ChatColor.RED + "\u51fb\u9000\u68c0\u67e5\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002"));
            this.violationCountMap.remove(playerUUID);
        }
    }

    private void sendAdminAlert(Player player, Location from, Location to, int violationLevel, double distance, int totalViolations) {
        String alertMessage = ChatColor.RED + "[MKnockback] " + ChatColor.YELLOW + player.getName() + ChatColor.WHITE + " \u53ef\u7591\u884c\u4e3a " + ChatColor.GOLD + "(\u7b49\u7ea7: " + violationLevel + ") " + ChatColor.WHITE + "\u8ddd\u79bb: " + String.format("%.2f", distance) + "\u683c " + ChatColor.RED + "[\u70b9\u51fb\u4f20\u9001]";
        String hoverText = ChatColor.GOLD + "\u73a9\u5bb6: " + player.getName() + "\n" + ChatColor.YELLOW + "\u8fdd\u89c4\u7b49\u7ea7: " + violationLevel + "\n" + ChatColor.GREEN + "\u8ddd\u79bb: " + String.format("%.2f", distance) + "\u683c\n" + ChatColor.BLUE + "\u603b\u8fdd\u89c4: " + totalViolations + "\u6b21\n" + ChatColor.WHITE + "\u70b9\u51fb\u4f20\u9001\u81f3\u73a9\u5bb6\u4f4d\u7f6e";
        for (UUID adminUUID : this.admins) {
            Player admin = this.getServer().getPlayer(adminUUID);
            if (admin == null || !admin.isOnline()) continue;
            admin.sendMessage(alertMessage);
            admin.sendMessage(ChatColor.GRAY + "\u4f4d\u7f6e: X:" + String.format("%.1f", to.getX()) + " Y:" + String.format("%.1f", to.getY()) + " Z:" + String.format("%.1f", to.getZ()));
        }
    }

    private void checkFallThrough(Player player, Location location) {
    }

    private void cleanupData() {
        long currentTime = System.currentTimeMillis();
        this.playerDataMap.entrySet().removeIf(entry -> currentTime - ((PlayerData)entry.getValue()).getLastUpdateTime() > 300000L);
    }

    public static Mknockback getInstance() {
        return instance;
    }

    public boolean isPluginEnabled() {
        return this.pluginEnabled;
    }

    public void setPluginEnabled(boolean pluginEnabled) {
        this.pluginEnabled = pluginEnabled;
        this.getLogger().info("Mknockback plugin " + (pluginEnabled ? "enabled" : "disabled"));
    }

    public void teleportAdminToPlayer(Player admin, Player target) {
        if (admin != null && target != null && admin.isOnline() && target.isOnline()) {
            admin.teleport(target.getLocation());
            admin.sendMessage(ChatColor.GREEN + "\u5df2\u4f20\u9001\u81f3 " + target.getName() + " \u7684\u4f4d\u7f6e");
        }
    }

    private static class PlayerData {
        private Location lastLocation;
        private long lastUpdateTime;
        private Vector movementVector;

        public PlayerData(Location lastLocation, long lastUpdateTime) {
            this.lastLocation = lastLocation.clone();
            this.lastUpdateTime = lastUpdateTime;
            this.movementVector = new Vector(0, 0, 0);
        }

        public void updatePosition(Location location, long updateTime) {
            this.lastLocation = location.clone();
            this.lastUpdateTime = updateTime;
        }

        public Location getLastLocation() {
            return this.lastLocation;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public Vector getMovementVector() {
            return this.movementVector;
        }

        public void setMovementVector(Vector movementVector) {
            this.movementVector = movementVector;
        }
    }
}

