/*
 * Decompiled with CFR 0.152.
 */
package com.myname.commandmodid;

import com.myname.commandmodid.CommandMod;
import com.myname.commandmodid.PacketFlagBeam;
import com.myname.commandmodid.PhaseActionBarTimer;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class FlagPointCommand
extends CommandBase {
    public static int flagHoldTimeMinutes = 5;
    public static int flagHoldTimeSeconds = 30;
    public static int preparationTimeMinutes = 0;
    public static int preparationTimeSeconds = 0;
    public static int flagPointX = 0;
    public static int flagPointY = 0;
    public static int flagPointZ = 0;
    public static boolean flagPointSet = false;
    public static boolean preparationPhase = false;

    public String func_71517_b() {
        return "flagpoint";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.flagpoint.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if ("time".equalsIgnoreCase(args[0])) {
            this.handleTimeCommand(sender, args);
            return;
        }
        if ("prepare".equalsIgnoreCase(args[0])) {
            this.handlePrepareCommand(sender, args);
            return;
        }
        if (args.length >= 3 && this.isInteger(args[0]) && this.isInteger(args[1]) && this.isInteger(args[2])) {
            this.handleFlagPointCommand(sender, args);
            return;
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    private void handleFlagPointCommand(ICommandSender sender, String[] args) throws CommandException {
        try {
            flagPointX = FlagPointCommand.func_71526_a((ICommandSender)sender, (String)args[0]);
            flagPointY = FlagPointCommand.func_71526_a((ICommandSender)sender, (String)args[1]);
            flagPointZ = FlagPointCommand.func_71526_a((ICommandSender)sender, (String)args[2]);
            if (flagPointY < 0 || flagPointY > 255) {
                throw new CommandException("commands.flagpoint.invalidY", new Object[0]);
            }
            flagPointSet = true;
            CommandMod.network.sendToAll((IMessage)new PacketFlagBeam(flagPointX, flagPointY, flagPointZ, 0, true));
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Flag point set to: " + flagPointX + ", " + flagPointY + ", " + flagPointZ));
        }
        catch (NumberFormatException e) {
            throw new WrongUsageException("commands.generic.num.invalid", new Object[]{args[0]});
        }
    }

    private void handleTimeCommand(ICommandSender sender, String[] args) throws CommandException {
        int min;
        if (args.length != 3) {
            throw new WrongUsageException("commands.flagpoint.time.usage", new Object[0]);
        }
        flagHoldTimeMinutes = min = this.parseAndValidateTime(sender, args[1], args[2], "commands.flagpoint.time.invalid");
        flagHoldTimeSeconds = Integer.parseInt(args[2]);
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Flag hold time set to: " + flagHoldTimeMinutes + " minutes " + flagHoldTimeSeconds + " seconds"));
    }

    public void handlePrepareCommand(ICommandSender sender, String[] args) throws CommandException {
        int min;
        if (args.length != 3) {
            throw new WrongUsageException("commands.flagpoint.prepare.usage", new Object[0]);
        }
        preparationTimeMinutes = min = this.parseAndValidateTime(sender, args[1], args[2], "commands.flagpoint.prepare.invalid");
        preparationTimeSeconds = Integer.parseInt(args[2]);
        preparationPhase = true;
        PhaseActionBarTimer.start();
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Preparation time set to: " + preparationTimeMinutes + " minutes " + preparationTimeSeconds + " seconds"));
    }

    private int parseAndValidateTime(ICommandSender sender, String minArg, String secArg, String errorKey) throws CommandException {
        int sec;
        int min;
        try {
            min = FlagPointCommand.func_71526_a((ICommandSender)sender, (String)minArg);
            sec = FlagPointCommand.func_71526_a((ICommandSender)sender, (String)secArg);
        }
        catch (NumberFormatException e) {
            throw new WrongUsageException("commands.generic.num.invalid", new Object[]{minArg});
        }
        if (min < 0 || sec < 0 || sec > 59) {
            throw new CommandException(errorKey, new Object[0]);
        }
        return min;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return FlagPointCommand.func_71530_a((String[])args, (String[])new String[]{"time", "prepare"});
        }
        return null;
    }

    private boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static int getFlagPointX() {
        return flagPointX;
    }

    public static int getFlagPointY() {
        return flagPointY;
    }

    public static int getFlagPointZ() {
        return flagPointZ;
    }

    public static boolean isFlagPointSet() {
        return flagPointSet;
    }

    public static void resetFlagPointSet() {
        flagPointSet = false;
    }

    public static void resetPrepareTime() {
        flagPointSet = false;
    }
}

