/*
 * Decompiled with CFR 0.152.
 */
package com.myname.commandmodid;

import com.myname.commandmodid.CommandMod;
import com.myname.commandmodid.FlagColors;
import com.myname.commandmodid.MFlagPointCommand;
import com.myname.commandmodid.MultiFlagTimerManager;
import com.myname.commandmodid.PacketAllFlags;
import com.myname.commandmodid.PacketAnnouncement;
import com.myname.commandmodid.PacketPersonalMessage;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class MultiFlagBlockPlacementHandler {
    MFlagPointCommand.FlagData data;

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        int z;
        int y;
        int x;
        Block block;
        WorldServer world;
        if (this.data.flagplaced && (world = DimensionManager.getWorld((int)0)) != null && (block = world.func_147439_a(x = this.data.x, y = this.data.y, z = this.data.z)) != Blocks.field_150399_cn) {
            this.data.flagplaced = false;
            MFlagPointCommand.setFlagColor(this.data.name, -1);
            CommandMod.network.sendToAll((IMessage)new PacketAllFlags(MFlagPointCommand.getAllFlags()));
            ArrayList<EntityPlayerMP> playersInZone = new ArrayList<EntityPlayerMP>();
            for (Object obj : world.field_73010_i) {
                EntityPlayerMP player;
                if (!(obj instanceof EntityPlayerMP) || !this.isPlayerInFlagHemisphere(player = (EntityPlayerMP)obj, this.data, MFlagPointCommand.flagHemisphereRadius)) continue;
                playersInZone.add(player);
            }
        }
    }

    @SubscribeEvent
    public void onBlockPlace(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack itemStack = event.entityPlayer.func_71045_bC();
        if (itemStack == null) {
            return;
        }
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        int x = event.x;
        int y = event.y;
        int z = event.z;
        int colorMeta = itemStack.func_77960_j();
        switch (event.face) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
            }
        }
        for (MFlagPointCommand.FlagData flag : MFlagPointCommand.getAllFlags()) {
            if (flag.x == x && flag.y == y && flag.z == z) {
                if (block != Blocks.field_150399_cn) {
                    if (event.entityPlayer instanceof EntityPlayerMP) {
                        CommandMod.network.sendTo((IMessage)new PacketPersonalMessage("\u041d\u0430 \u043c\u0435\u0441\u0442\u0435 \u0444\u043b\u0430\u0433\u0430 \u043c\u043e\u0436\u043d\u043e \u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0446\u0432\u0435\u0442\u043d\u043e\u0435 \u0441\u0442\u0435\u043a\u043b\u043e!"), (EntityPlayerMP)event.entityPlayer);
                    }
                    event.setCanceled(true);
                    return;
                }
                MFlagPointCommand.setFlagColor(flag.name, colorMeta);
                CommandMod.network.sendToAll((IMessage)new PacketAnnouncement("\u0421\u0442\u0435\u043a\u043b\u043e \u043f\u043e\u0441\u0442\u0430\u0432\u0438\u043b\u0438 " + flag.name));
                flag.flagplaced = true;
                ArrayList<EntityPlayerMP> playersInZone = new ArrayList<EntityPlayerMP>();
                String colorCode = FlagColors.getColorCode(colorMeta);
                String colorName = FlagColors.getColorName(colorMeta);
                for (Object obj : event.entityPlayer.field_70170_p.field_73010_i) {
                    EntityPlayerMP player;
                    if (!(obj instanceof EntityPlayerMP) || !this.isPlayerInFlagHemisphere(player = (EntityPlayerMP)obj, flag, MFlagPointCommand.flagHemisphereRadius)) continue;
                    playersInZone.add(player);
                    CommandMod.network.sendTo((IMessage)new PacketPersonalMessage(colorCode + colorName + " \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u043b\u0430 \u0444\u043b\u0430\u0433 " + flag.name + "!"), player);
                }
                MultiFlagTimerManager.startFlagTimer(flag.name, MFlagPointCommand.flagCaptureTime, playersInZone, colorMeta);
                event.setCanceled(false);
                return;
            }
            if (flag.x != x || flag.z != z || y <= flag.y || y > flag.y + 10) continue;
            if (event.entityPlayer instanceof EntityPlayerMP) {
                CommandMod.network.sendTo((IMessage)new PacketPersonalMessage("\u041d\u0430\u0434 \u0444\u043b\u0430\u0433\u043e\u043c \u043d\u0435\u043b\u044c\u0437\u044f \u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0432 \u0440\u0430\u0434\u0438\u0443\u0441\u0435 10 \u0431\u043b\u043e\u043a\u043e\u0432!"), (EntityPlayerMP)event.entityPlayer);
            }
            event.setCanceled(true);
            return;
        }
    }

    private boolean isPlayerInFlagHemisphere(EntityPlayerMP player, MFlagPointCommand.FlagData flag, double radius) {
        double dx = player.field_70165_t - ((double)flag.x + 0.5);
        double dy = player.field_70163_u - ((double)flag.y + 0.5);
        double dz = player.field_70161_v - ((double)flag.z + 0.5);
        if (dy < 0.0) {
            return false;
        }
        return dx * dx + dy * dy + dz * dz <= radius * radius;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        int x = event.x;
        int y = event.y;
        int z = event.z;
        Block block = event.block;
        if (block != Blocks.field_150399_cn) {
            return;
        }
        for (MFlagPointCommand.FlagData flag : MFlagPointCommand.getAllFlags()) {
            if (flag.x != x || flag.y != y || flag.z != z) continue;
            MFlagPointCommand.setFlagColor(flag.name, -1);
            ArrayList<EntityPlayerMP> playersInZone = new ArrayList<EntityPlayerMP>();
            for (Object obj : event.world.field_73010_i) {
                EntityPlayerMP player;
                if (!(obj instanceof EntityPlayerMP) || !this.isPlayerInFlagHemisphere(player = (EntityPlayerMP)obj, flag, MFlagPointCommand.flagHemisphereRadius)) continue;
                playersInZone.add(player);
            }
            MultiFlagTimerManager.stopFlagTimer(flag.name, playersInZone);
            for (EntityPlayerMP player : playersInZone) {
                CommandMod.network.sendTo((IMessage)new PacketPersonalMessage("\u0417\u0430\u0445\u0432\u0430\u0442 \u0444\u043b\u0430\u0433\u0430 " + flag.name + " \u043f\u0440\u0435\u0440\u0432\u0430\u043d!"), player);
            }
        }
    }
}

