/*
 * Decompiled with CFR 0.152.
 */
package com.myname.commandmodid;

import com.myname.commandmodid.CommandMod;
import com.myname.commandmodid.FlagColors;
import com.myname.commandmodid.MFlagPointCommand;
import com.myname.commandmodid.PacketAnnouncement;
import com.myname.commandmodid.PacketMultiFlagTimer;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class MultiFlagTimerManager {
    private static final Map<String, FlagTimer> flagTimers = new HashMap<String, FlagTimer>();

    public static void startFlagTimer(final String flagName, int seconds, final List<EntityPlayerMP> initialPlayers, final int colorIndex) {
        MultiFlagTimerManager.stopFlagTimer(flagName, initialPlayers);
        MFlagPointCommand.FlagData flagData = MultiFlagTimerManager.getFlagData(flagName);
        if (flagData == null) {
            return;
        }
        final FlagTimer flagTimer = new FlagTimer();
        flagTimer.timeLeft = seconds;
        flagTimer.flagName = flagName;
        flagTimer.flagData = new MFlagPointCommand.FlagData(flagData.name, flagData.x, flagData.y, flagData.z, colorIndex, flagData.flagplaced);
        flagTimers.put(flagName, flagTimer);
        flagTimer.timer = new Timer();
        flagTimer.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (flagTimer.timeLeft < 0) {
                    MultiFlagTimerManager.stopFlagTimer(flagName, initialPlayers);
                    String colorCode = FlagColors.getColorCode(colorIndex);
                    String colorName = FlagColors.getColorName(colorIndex);
                    CommandMod.network.sendToAll((IMessage)new PacketAnnouncement(colorCode + colorName + " \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u0437\u0430\u0445\u0432\u0430\u0442\u0438\u043b\u0430 " + flagName + "!"));
                    for (EntityPlayerMP player : flagTimer.playersWithTimer) {
                        CommandMod.network.sendTo((IMessage)new PacketMultiFlagTimer(flagName, "", flagTimer.flagData.colorIndex), player);
                    }
                    return;
                }
                --flagTimer.timeLeft;
            }
        }, 0L, 1000L);
    }

    public static void stopFlagTimer(String flagName, List<EntityPlayerMP> initialPlayers) {
        FlagTimer flagTimer = flagTimers.remove(flagName);
        if (flagTimer != null && flagTimer.timer != null) {
            flagTimer.timer.cancel();
            for (EntityPlayerMP player : initialPlayers) {
                CommandMod.network.sendTo((IMessage)new PacketMultiFlagTimer(flagName, "", flagTimer.flagData.colorIndex), player);
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (FlagTimer flagTimer : flagTimers.values()) {
            Set<EntityPlayerMP> currentPlayers = MultiFlagTimerManager.getPlayersInHemisphere(flagTimer.flagData, MFlagPointCommand.flagHemisphereRadius);
            for (EntityPlayerMP player : currentPlayers) {
                if (flagTimer.playersWithTimer.contains(player)) continue;
                CommandMod.network.sendTo((IMessage)new PacketMultiFlagTimer(flagTimer.flagName, MultiFlagTimerManager.formatTime(flagTimer.timeLeft), flagTimer.flagData.colorIndex), player);
            }
            for (EntityPlayerMP player : new HashSet<EntityPlayerMP>(flagTimer.playersWithTimer)) {
                if (currentPlayers.contains(player)) continue;
                CommandMod.network.sendTo((IMessage)new PacketMultiFlagTimer(flagTimer.flagName, "", flagTimer.flagData.colorIndex), player);
            }
            flagTimer.playersWithTimer = currentPlayers;
            for (EntityPlayerMP player : flagTimer.playersWithTimer) {
                CommandMod.network.sendTo((IMessage)new PacketMultiFlagTimer(flagTimer.flagName, MultiFlagTimerManager.formatTime(flagTimer.timeLeft), flagTimer.flagData.colorIndex), player);
            }
        }
    }

    private static Set<EntityPlayerMP> getPlayersInHemisphere(MFlagPointCommand.FlagData flag, double radius) {
        HashSet<EntityPlayerMP> result = new HashSet<EntityPlayerMP>();
        WorldServer world = DimensionManager.getWorld((int)0);
        if (world == null) {
            return result;
        }
        for (Object obj : world.field_73010_i) {
            if (!(obj instanceof EntityPlayerMP)) continue;
            EntityPlayerMP player = (EntityPlayerMP)obj;
            double dx = player.field_70165_t - ((double)flag.x + 0.5);
            double dy = player.field_70163_u - ((double)flag.y + 0.5);
            double dz = player.field_70161_v - ((double)flag.z + 0.5);
            if (!(dy >= 0.0) || !(dx * dx + dy * dy + dz * dz <= radius * radius)) continue;
            result.add(player);
        }
        return result;
    }

    private static MFlagPointCommand.FlagData getFlagData(String flagName) {
        for (MFlagPointCommand.FlagData flag : MFlagPointCommand.getAllFlags()) {
            if (!flag.name.equals(flagName)) continue;
            return flag;
        }
        return null;
    }

    private static String formatTime(int totalSeconds) {
        int min = totalSeconds / 60;
        int sec = totalSeconds % 60;
        return String.format("%02d:%02d", min, sec);
    }

    private static class FlagTimer {
        Timer timer;
        int timeLeft;
        String flagName;
        MFlagPointCommand.FlagData flagData;
        Set<EntityPlayerMP> playersWithTimer = new HashSet<EntityPlayerMP>();

        private FlagTimer() {
        }
    }
}

