/*
 * Decompiled with CFR 0.152.
 */
package com.myname.commandmodid;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class TimerOverlay {
    public static String timerText = "";
    public static final Queue<String> announcements = new LinkedList<String>();
    public static final Queue<String> personalMessages = new LinkedList<String>();
    private static long announcementTimestamp = 0L;
    private static long personalMessageTimestamp = 0L;
    private static final long ANNOUNCEMENT_DURATION = 3000L;
    private static final long PERSONAL_DURATION = 2000L;
    public static final Map<String, String> multiFlagTimers = new HashMap<String, String>();

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int width = res.func_78326_a();
        int height = res.func_78328_b();
        long now = System.currentTimeMillis();
        if (timerText != null && !timerText.isEmpty()) {
            GL11.glPushMatrix();
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            int timerWidth = mc.field_71466_p.func_78256_a(timerText);
            mc.field_71466_p.func_78261_a(timerText, (int)((float)(width / 2 - timerWidth / 2) / 2.0f), 5, 0xFFFF55);
            GL11.glPopMatrix();
        }
        int y = 40;
        for (Map.Entry<String, String> entry : multiFlagTimers.entrySet()) {
            String flagName = entry.getKey();
            String timer = entry.getValue();
            String text = "\u0424\u043b\u0430\u0433 " + flagName + ": " + timer;
            GL11.glPushMatrix();
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            int timerWidth = mc.field_71466_p.func_78256_a(text);
            mc.field_71466_p.func_78261_a(text, (int)((float)(width / 2 - timerWidth / 2) / 1.5f), (int)((float)y / 1.5f), 0x55FF55);
            GL11.glPopMatrix();
            y += 24;
        }
        String lastAnnouncement = announcements.peek();
        if (lastAnnouncement != null && !lastAnnouncement.isEmpty()) {
            if (now - announcementTimestamp < 3000L) {
                GL11.glPushMatrix();
                GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                int msgWidth = mc.field_71466_p.func_78256_a(lastAnnouncement);
                mc.field_71466_p.func_78261_a(lastAnnouncement, (int)((float)(width / 2 - msgWidth / 2) / 2.0f), 20, 0xFFFFFF);
                GL11.glPopMatrix();
            } else {
                announcements.clear();
            }
        }
        int expBarY = height - 32;
        int msgY = expBarY - personalMessages.size() * 12;
        if (!personalMessages.isEmpty()) {
            if (now - personalMessageTimestamp < 2000L) {
                for (String msg : personalMessages) {
                    mc.field_71466_p.func_78261_a(msg, width / 2 - mc.field_71466_p.func_78256_a(msg) / 2, msgY, 0xFFFFFF);
                    msgY += 12;
                }
            } else {
                personalMessages.clear();
            }
        }
    }

    public static void addAnnouncement(String msg) {
        announcements.clear();
        announcements.offer(msg);
        announcementTimestamp = System.currentTimeMillis();
    }

    public static void addPersonalMessage(String msg) {
        if (personalMessages.size() > 3) {
            personalMessages.poll();
        }
        personalMessages.offer(msg);
        personalMessageTimestamp = System.currentTimeMillis();
    }

    public static void setMultiFlagTimer(String flagName, String timerText) {
        if (timerText == null || timerText.isEmpty()) {
            multiFlagTimers.remove(flagName);
        } else {
            multiFlagTimers.put(flagName, timerText);
        }
    }

    public static void clearMultiFlagTimers() {
        multiFlagTimers.clear();
    }
}

