/*
 * Decompiled with CFR 0.152.
 */
package net.sjhub.tt20forged.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLPaths;
import net.sjhub.tt20forged.TT20Forged;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSONConfiguration {
    private final String fileName;
    private JsonObject json;
    private final Gson gson;

    public JSONConfiguration(String fileName) {
        this.fileName = fileName;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.reload();
    }

    public void save() {
        try {
            File file = new File(this.getAbsolutePath() + this.fileName);
            file.getParentFile().mkdirs();
            file.createNewFile();
            FileWriter writer = new FileWriter(file);
            writer.write(this.gson.toJson((JsonElement)this.json));
            writer.close();
            this.reload();
        }
        catch (IOException e) {
            TT20Forged.LOGGER.error("(TT20) Failed to save JSONConfiguration '" + this.fileName + "'");
            e.printStackTrace();
            return;
        }
    }

    public void reload() {
        try {
            File file = new File(this.getAbsolutePath() + this.fileName);
            file.getParentFile().mkdirs();
            if (file.createNewFile()) {
                FileWriter writer = new FileWriter(file);
                writer.write("{}");
                writer.close();
            }
            BufferedReader reader = new BufferedReader(new FileReader(this.getAbsolutePath() + this.fileName));
            this.json = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
        }
        catch (IOException e) {
            TT20Forged.LOGGER.error("(TT20) Failed to reload JSONConfiguration '" + this.fileName + "'");
            e.printStackTrace();
        }
    }

    public boolean has(String key) {
        JsonElement element = (JsonElement)this.gson.fromJson(this.json.toString(), JsonElement.class);
        for (String part : this.splitKey(key)) {
            if (element == null || !element.getAsJsonObject().has(part)) {
                return false;
            }
            element = element.getAsJsonObject().get(part);
        }
        return element != null;
    }

    @Nullable
    private Object[] preparePut(String key, @Nullable Object value) {
        String[] parts = this.splitKey(key);
        JsonObject current = this.json;
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (!current.has(part) || !current.get(part).isJsonObject()) {
                current.add(part, (JsonElement)new JsonObject());
            }
            current = current.getAsJsonObject(part);
        }
        if (value == null) {
            current.remove(parts[parts.length - 1]);
            return null;
        }
        return new Object[]{current, parts[parts.length - 1]};
    }

    public void put(String key, @Nullable String value) {
        Object[] values = this.preparePut(key, value);
        if (values == null) {
            return;
        }
        JsonObject current = (JsonObject)values[0];
        current.addProperty((String)values[1], value);
    }

    public void put(String key, @Nullable Object[] value) {
        Object[] values = this.preparePut(key, value);
        if (values == null) {
            return;
        }
        JsonObject current = (JsonObject)values[0];
        JsonArray array = new JsonArray();
        for (Object object : value) {
            if (object instanceof String) {
                array.add((String)object);
                continue;
            }
            if (object instanceof Boolean) {
                array.add((Boolean)object);
                continue;
            }
            if (object instanceof Number) {
                array.add((Number)object);
                continue;
            }
            throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
        }
        current.add((String)values[1], (JsonElement)array);
    }

    public void put(String key, @Nullable Boolean value) {
        Object[] values = this.preparePut(key, value);
        if (values == null) {
            return;
        }
        JsonObject current = (JsonObject)values[0];
        current.addProperty((String)values[1], value);
    }

    public void putIfEmpty(String key, @NotNull String value) {
        Objects.requireNonNull(value);
        if (!this.has(key)) {
            this.put(key, value);
        }
    }

    public void putIfEmpty(String key, @NotNull Object[] value) {
        Objects.requireNonNull(value);
        if (!this.has(key)) {
            this.put(key, value);
        }
    }

    public void putIfEmpty(String key, @NotNull Boolean value) {
        Objects.requireNonNull(value);
        if (!this.has(key)) {
            this.put(key, value);
        }
    }

    public String getAsString(String key) {
        JsonObject element = this.json;
        for (String part : this.splitKey(key)) {
            if (element == null || !element.getAsJsonObject().has(part)) {
                return null;
            }
            element = element.getAsJsonObject().get(part);
        }
        return element != null && element.isJsonPrimitive() && element.getAsJsonPrimitive().isString() ? element.getAsString() : null;
    }

    public Boolean getAsBoolean(String key) {
        JsonObject element = this.json;
        for (String part : this.splitKey(key)) {
            if (element == null || !element.getAsJsonObject().has(part)) {
                return null;
            }
            element = element.getAsJsonObject().get(part);
        }
        return element != null && element.isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean() ? Boolean.valueOf(element.getAsBoolean()) : null;
    }

    public JsonArray getAsArray(String key) {
        JsonObject element = this.json;
        for (String part : this.splitKey(key)) {
            if (element == null || !element.getAsJsonObject().has(part)) {
                return null;
            }
            element = element.getAsJsonObject().get(part);
        }
        return element != null && element.isJsonArray() ? element.getAsJsonArray() : null;
    }

    public String getAsStringOrDefault(String key, String def) {
        if (!this.has(key)) {
            return def;
        }
        return this.getAsString(key);
    }

    public Boolean getAsBooleanOrDefault(String key, Boolean def) {
        if (!this.has(key)) {
            return def;
        }
        return this.getAsBoolean(key);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] keys(String key) {
        if (key.isEmpty()) {
            HashSet<String> keys = new HashSet<String>();
            this.collectStringKeys(this.json, "", keys);
            return keys.toArray(new String[0]);
        }
        JsonObject element = this.json;
        for (String part : this.splitKey(key)) {
            if (element == null || !element.getAsJsonObject().has(part)) {
                return new String[0];
            }
            element = element.getAsJsonObject().get(part);
        }
        if (element != null && element.isJsonObject()) {
            HashSet<String> keys = new HashSet<String>();
            this.collectStringKeys(element.getAsJsonObject(), "", keys);
            return keys.toArray(new String[0]);
        }
        return new String[0];
    }

    public String[] keys() {
        return this.keys("");
    }

    public String[] splitKey(String key) {
        return key.split("\\.");
    }

    public String getAbsolutePath() {
        return String.valueOf(FMLPaths.CONFIGDIR.get().toAbsolutePath()) + "/tt20/";
    }

    private void collectStringKeys(JsonObject jsonObject, String prefix, Set<String> keys) {
        for (String key : jsonObject.keySet()) {
            String fullKey;
            JsonElement element = jsonObject.get(key);
            String string = fullKey = prefix.isEmpty() ? key : prefix + "." + key;
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                keys.add(fullKey);
                continue;
            }
            if (!element.isJsonObject()) continue;
            this.collectStringKeys(element.getAsJsonObject(), fullKey, keys);
        }
    }
}

