/*
 * Decompiled with CFR 0.152.
 */
package net.sjhub.tt20forged.util;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.sjhub.tt20forged.TT20Forged;
import net.sjhub.tt20forged.config.JSONConfiguration;
import net.sjhub.tt20forged.util.MaskType;
import net.sjhub.tt20forged.util.RegistryIndex;

public class Mask {
    private final JSONConfiguration file;
    private final MaskType maskType;
    private final IForgeRegistry<?> registry;
    private final RegistryIndex index;
    private final Set<ResourceLocation> entries;

    public Mask(IForgeRegistry<?> registry, JSONConfiguration file, String maskKey) {
        this.file = file;
        this.maskType = MaskType.fromString(file.getAsString("type"));
        this.registry = registry;
        this.index = RegistryIndex.getIndex(this.registry);
        this.entries = new HashSet<ResourceLocation>();
        for (JsonElement element : file.getAsArray(maskKey)) {
            if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                TT20Forged.LOGGER.error("(TT20) Mask element '" + String.valueOf(element) + "' isn't a string");
                return;
            }
            this.entries.addAll(this.manageEntry(element.getAsString()));
        }
    }

    public List<ResourceLocation> manageEntry(String entry) {
        String[] split = entry.split(":");
        if (split.length != 2) {
            TT20Forged.LOGGER.error("(TT20) '" + entry + "' is not a valid identifier. Correct format is <namespace>:<path>");
            return new ArrayList<ResourceLocation>();
        }
        if (split[0].equals("*") && split[1].equals("*")) {
            return this.index.getIdentifiers();
        }
        if (!split[0].equals("*") && !split[1].equals("*")) {
            return List.of(ResourceLocation.m_214293_((String)split[0], (String)split[1]));
        }
        if (split[0].equals("*") && !split[1].equals("*")) {
            return this.index.getPathIndex().getOrDefault(split[1], new ArrayList());
        }
        if (!split[0].equals("*") && split[1].equals("*")) {
            return this.index.getNamespaceIndex().getOrDefault(split[0], new ArrayList());
        }
        return null;
    }

    public IForgeRegistry<?> getRegistry() {
        return this.registry;
    }

    public JSONConfiguration getFile() {
        return this.file;
    }

    public boolean matches(ResourceLocation identifier) {
        return this.entries.contains(identifier);
    }

    public boolean isOkay(ResourceLocation identifier) {
        if (this.maskType == MaskType.WHITELIST) {
            return this.entries.contains(identifier);
        }
        return !this.entries.contains(identifier);
    }
}

