/*
 * Decompiled with CFR 0.152.
 */
package net.sjhub.tt20forged.util;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;

public class TPSCalculator {
    public Long lastTick;
    public Long currentTick;
    private double allMissedTicks = 0.0;
    private final List<Double> tpsHistory = new CopyOnWriteArrayList<Double>();
    private static final int historyLimit = 40;
    public static final int MAX_TPS = 20;
    public static final int FULL_TICK = 50;

    public TPSCalculator() {
        MinecraftForge.EVENT_BUS.addListener(this::onTick);
    }

    private void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.currentTick != null) {
            this.lastTick = this.currentTick;
        }
        this.currentTick = System.currentTimeMillis();
        this.addToHistory(this.getTPS());
        this.clearMissedTicks();
        this.missedTick();
    }

    private void addToHistory(double tps) {
        if (this.tpsHistory.size() >= 40) {
            this.tpsHistory.remove(0);
        }
        this.tpsHistory.add(tps);
    }

    public long getMSPT() {
        return this.currentTick - this.lastTick;
    }

    public double getAverageTPS() {
        return this.tpsHistory.stream().mapToDouble(Double::doubleValue).average().orElse(0.1);
    }

    public double getTPS() {
        if (this.lastTick == null) {
            return -1.0;
        }
        if (this.getMSPT() <= 0L) {
            return 0.1;
        }
        double tps = 1000.0 / (double)this.getMSPT();
        return tps > 20.0 ? 20.0 : tps;
    }

    public void missedTick() {
        if (this.lastTick == null) {
            return;
        }
        long mspt = this.getMSPT() <= 0L ? 50L : this.getMSPT();
        double missedTicks = (double)mspt / 50.0 - 1.0;
        this.allMissedTicks += missedTicks <= 0.0 ? 0.0 : missedTicks;
    }

    public double getMostAccurateTPS() {
        return this.getTPS() > this.getAverageTPS() ? this.getAverageTPS() : this.getTPS();
    }

    public double getAllMissedTicks() {
        return this.allMissedTicks;
    }

    public int applicableMissedTicks() {
        return (int)Math.floor(this.allMissedTicks);
    }

    public void clearMissedTicks() {
        this.allMissedTicks -= (double)this.applicableMissedTicks();
    }

    public void resetMissedTicks() {
        this.allMissedTicks = 0.0;
    }
}

