/*
 * Decompiled with CFR 0.152.
 */
package net.scoobis;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_642;
import net.minecraft.class_746;
import net.minecraft.class_7471;
import net.scoobis.OllamaMc;
import net.scoobis.OllamaMcConfig;
import net.scoobis.ollama.OllamaChatMessage;
import net.scoobis.ollama.OllamaChatRequest;

public class Ollama {
    private static List<OllamaChatMessage> messages;
    private static String message;
    private static String username;
    private static boolean thinking;
    public static Runnable onMessageRunnable;

    public static void resetMessages() {
        messages = new ArrayList<OllamaChatMessage>();
        messages.add(new OllamaChatMessage("SYSTEM", ((OllamaMcConfig)OllamaMc.CONFIG.get()).SystemPrompt + " Do not send messages larger than 230 characters. Do not use the character \u00a7. Only use one line."));
    }

    public static void onMessage(String message, String username) {
        thinking = true;
        try {
            String line;
            OllamaMc.LOGGER.info(username + ": " + message);
            URL url = new URI(((OllamaMcConfig)OllamaMc.CONFIG.get()).Host + "api/chat").toURL();
            if (username == "") {
                messages.add(new OllamaChatMessage("USER", message));
            } else {
                messages.add(new OllamaChatMessage("USER", "[User: " + username + "] " + message));
            }
            OllamaChatRequest chatRequest = new OllamaChatRequest(((OllamaMcConfig)OllamaMc.CONFIG.get()).Model, messages);
            OllamaMc.LOGGER.info(chatRequest.toString());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json; utf-8");
            conn.setRequestProperty("Accept", "application/json");
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = chatRequest.toString().getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder response = new StringBuilder();
            while ((line = in.readLine()) != null) {
                response.append(line);
            }
            in.close();
            JsonObject jsonResponse = JsonParser.parseString((String)response.toString()).getAsJsonObject();
            String responseString = jsonResponse.get("message").getAsJsonObject().get("content").getAsString();
            OllamaMc.LOGGER.info(responseString);
            String newLine = System.getProperty("line.separator");
            OllamaMc.LOGGER.info("[" + ((OllamaMcConfig)OllamaMc.CONFIG.get()).ModelName + "]: " + responseString);
            responseString = responseString.replaceAll(newLine, "[n]");
            if (!responseString.contains("\u00a7") && !responseString.contains(newLine) && responseString.length() <= 240) {
                OllamaMc.CLIENT.field_1724.field_3944.method_45729("[" + ((OllamaMcConfig)OllamaMc.CONFIG.get()).ModelName + "]: " + responseString);
                messages.add(new OllamaChatMessage("ASSISTANT", responseString));
            } else {
                OllamaMc.CLIENT.field_1724.field_3944.method_45729("[" + ((OllamaMcConfig)OllamaMc.CONFIG.get()).ModelName + "]: [error: response didn't follow guidelines]");
            }
        }
        catch (IOException | URISyntaxException e) {
            OllamaMc.CLIENT.field_1724.field_3944.method_45729("[" + ((OllamaMcConfig)OllamaMc.CONFIG.get()).ModelName + "]: [unknown error: " + e.getMessage() + " ]");
        }
        thinking = false;
    }

    public static void onChatMessage(class_2561 message2, class_7471 signedMessage, GameProfile profile, class_2556.class_7602 params, Instant receptionTimestamp) {
        if (((OllamaMcConfig)OllamaMc.CONFIG.get()).Enabled) {
            message = signedMessage.method_44862();
            username = profile.getName();
            if (!message.contains("[" + ((OllamaMcConfig)OllamaMc.CONFIG.get()).ModelName + "]") && message.contains(((OllamaMcConfig)OllamaMc.CONFIG.get()).ModelName) && !thinking) {
                message = message.replaceAll(((OllamaMcConfig)OllamaMc.CONFIG.get()).ModelName, "");
                message = message.replaceAll("  ", " ");
                Executors.newSingleThreadExecutor().execute(onMessageRunnable);
            }
        }
    }

    public static void onChatMessage(class_2561 message2, boolean overlay) {
        class_746 playerEntity = OllamaMc.CLIENT.field_1724;
        if (playerEntity != null && playerEntity.field_3944 != null && playerEntity.field_3944.method_45734().method_55616() == class_642.class_8678.field_45611 && !playerEntity.field_3944.method_45734().method_2994() && ((OllamaMcConfig)OllamaMc.CONFIG.get()).Enabled && playerEntity.field_3944.method_48296().method_10771() && !(message = message2.getString().toLowerCase()).contains("[" + ((OllamaMcConfig)OllamaMc.CONFIG.get()).ModelName.toLowerCase() + "]") && message.contains(((OllamaMcConfig)OllamaMc.CONFIG.get()).ModelName.toLowerCase()) && !thinking) {
            if (message2.getString().contains("> ") && message2.getString().startsWith("<")) {
                message = message2.getString().replaceFirst(message2.getString().split("> ")[0], "").replaceFirst(">", "");
                username = message2.getString().split("> ")[0].replaceFirst("<", "");
                message = message.replaceAll(((OllamaMcConfig)OllamaMc.CONFIG.get()).ModelName, "");
                message = message.replaceAll("  ", " ");
                Executors.newSingleThreadExecutor().execute(onMessageRunnable);
            } else if (message2.getString().contains(": ")) {
                message = message2.getString().replaceFirst(message2.getString().split(": ")[0], "").replaceFirst(": ", "");
                username = message2.getString().split(": ")[0];
                message = message.replaceAll(((OllamaMcConfig)OllamaMc.CONFIG.get()).ModelName, "");
                message = message.replaceAll("  ", " ");
                Executors.newSingleThreadExecutor().execute(onMessageRunnable);
            } else if (message2.getString().contains(" \u00bb ")) {
                message = message2.getString().replaceFirst(message2.getString().split(" \u00bb ")[0], "").replaceFirst(" \u00bb ", "");
                username = message2.getString().split(" \u00bb ")[0];
                message = message.replaceAll(((OllamaMcConfig)OllamaMc.CONFIG.get()).ModelName, "");
                message = message.replaceAll("  ", " ");
                Executors.newSingleThreadExecutor().execute(onMessageRunnable);
            }
        }
    }

    static {
        thinking = false;
        onMessageRunnable = new Runnable(){

            @Override
            public void run() {
                Ollama.onMessage(message, username);
            }
        };
    }
}

