/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.burgermod.common.datagen;

import com.autovw.burgermod.common.core.ModItems;
import com.autovw.burgermod.common.core.util.ModTags;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ModDataGenHelper {
    public static void advancements(HolderLookup.Provider registries, Consumer<AdvancementHolder> consumer) {
        Advancement.Builder.advancement().parent(ResourceLocation.withDefaultNamespace((String)"husbandry/root")).display((ItemLike)ModItems.FRIES, (Component)Component.translatable((String)"advancements.burgermod.husbandry.obtain_fries.title"), (Component)Component.translatable((String)"advancements.burgermod.husbandry.obtain_fries.description"), null, AdvancementType.TASK, true, true, false).addCriterion("fries", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.FRIES})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"burgermod", (String)"husbandry/obtain_fries").toString());
        AdvancementHolder craftBurger = Advancement.Builder.advancement().parent(ResourceLocation.withDefaultNamespace((String)"husbandry/plant_seed")).display((ItemLike)ModItems.BEEF_BURGER, (Component)Component.translatable((String)"advancements.burgermod.husbandry.craft_burger.title"), (Component)Component.translatable((String)"advancements.burgermod.husbandry.craft_burger.description"), null, AdvancementType.TASK, true, true, false).addCriterion("burgers", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of((HolderGetter)registries.lookupOrThrow(Registries.ITEM), ModTags.BURGERS)})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"burgermod", (String)"husbandry/craft_burger").toString());
        AdvancementHolder goldenBurger = Advancement.Builder.advancement().parent(craftBurger).display((ItemLike)ModItems.GOLDEN_BEEF_BURGER, (Component)Component.translatable((String)"advancements.burgermod.husbandry.craft_golden_burger.title"), (Component)Component.translatable((String)"advancements.burgermod.husbandry.craft_golden_burger.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("golden_burgers", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of((HolderGetter)registries.lookupOrThrow(Registries.ITEM), ModTags.GOLDEN_BURGERS)})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"burgermod", (String)"husbandry/craft_golden_burger").toString());
        Advancement.Builder.advancement().parent(goldenBurger).display((ItemLike)ModItems.ENCHANTED_GOLDEN_BURGER, (Component)Component.translatable((String)"advancements.burgermod.husbandry.obtain_enchanted_golden_burger.title"), (Component)Component.translatable((String)"advancements.burgermod.husbandry.obtain_enchanted_golden_burger.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("enchanted_golden_burger", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of((HolderGetter)registries.lookupOrThrow(Registries.ITEM), new ItemLike[]{ModItems.ENCHANTED_GOLDEN_BURGER})})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"burgermod", (String)"husbandry/obtain_enchanted_golden_burger").toString());
    }

    public static void recipes(HolderLookup.Provider registries, RecipeOutput output) {
        HolderLookup.RegistryLookup registryLookup = registries.lookupOrThrow(Registries.ITEM);
        ModDataGenHelper.eggBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.BEEF_BURGER, (ItemLike)Items.COOKED_BEEF);
        ModDataGenHelper.eggBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.PORK_BURGER, (ItemLike)Items.COOKED_PORKCHOP);
        ModDataGenHelper.eggBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.MUTTON_BURGER, (ItemLike)Items.COOKED_MUTTON);
        ModDataGenHelper.eggBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.CHICKEN_BURGER, (ItemLike)Items.COOKED_CHICKEN);
        ModDataGenHelper.eggBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.SALMON_BURGER, (ItemLike)Items.COOKED_SALMON);
        ModDataGenHelper.eggBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.COD_BURGER, (ItemLike)Items.COOKED_COD);
        ModDataGenHelper.cheeseBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.BEEF_CHEESE_BURGER, (ItemLike)Items.COOKED_BEEF);
        ModDataGenHelper.cheeseBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.PORK_CHEESE_BURGER, (ItemLike)Items.COOKED_PORKCHOP);
        ModDataGenHelper.cheeseBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.MUTTON_CHEESE_BURGER, (ItemLike)Items.COOKED_MUTTON);
        ModDataGenHelper.cheeseBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.CHICKEN_CHEESE_BURGER, (ItemLike)Items.COOKED_CHICKEN);
        ModDataGenHelper.cheeseBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.SALMON_CHEESE_BURGER, (ItemLike)Items.COOKED_SALMON);
        ModDataGenHelper.cheeseBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.COD_CHEESE_BURGER, (ItemLike)Items.COOKED_COD);
        ModDataGenHelper.champignonBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.BEEF_CHAMPIGNON_BURGER, (ItemLike)Items.COOKED_BEEF);
        ModDataGenHelper.champignonBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.PORK_CHAMPIGNON_BURGER, (ItemLike)Items.COOKED_PORKCHOP);
        ModDataGenHelper.champignonBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.MUTTON_CHAMPIGNON_BURGER, (ItemLike)Items.COOKED_MUTTON);
        ModDataGenHelper.champignonBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.CHICKEN_CHAMPIGNON_BURGER, (ItemLike)Items.COOKED_CHICKEN);
        ModDataGenHelper.champignonBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.SALMON_CHAMPIGNON_BURGER, (ItemLike)Items.COOKED_SALMON);
        ModDataGenHelper.champignonBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.COD_CHAMPIGNON_BURGER, (ItemLike)Items.COOKED_COD);
        ModDataGenHelper.goldenBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.GOLDEN_BEEF_BURGER, ModTags.BEEF_BURGERS);
        ModDataGenHelper.goldenBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.GOLDEN_PORK_BURGER, ModTags.PORK_BURGERS);
        ModDataGenHelper.goldenBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.GOLDEN_MUTTON_BURGER, ModTags.MUTTON_BURGERS);
        ModDataGenHelper.goldenBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.GOLDEN_CHICKEN_BURGER, ModTags.CHICKEN_BURGERS);
        ModDataGenHelper.goldenBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.GOLDEN_SALMON_BURGER, ModTags.SALMON_BURGERS);
        ModDataGenHelper.goldenBurgerRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.GOLDEN_COD_BURGER, ModTags.COD_BURGERS);
        ModDataGenHelper.scrambledEggRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.SCRAMBLED_EGG);
        ModDataGenHelper.cookingRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.FRIED_SCRAMBLED_EGG, (ItemLike)ModItems.SCRAMBLED_EGG);
        ModDataGenHelper.cheeseRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.CHEESE);
        ModDataGenHelper.rawChampignonRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.RAW_CHAMPIGNONS);
        ModDataGenHelper.cookingRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup, (ItemLike)ModItems.COOKED_CHAMPIGNONS, (ItemLike)ModItems.RAW_CHAMPIGNONS);
        ModDataGenHelper.chickenNuggetRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup);
        ModDataGenHelper.friesRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup);
        ModDataGenHelper.hotdogRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup);
        ModDataGenHelper.sweetBerryTartRecipe(output, (HolderLookup.RegistryLookup<Item>)registryLookup);
    }

    public static void baseBurgerRecipe(RecipeOutput output, HolderLookup.RegistryLookup<Item> registryLookup, ItemLike result, int resultAmount, ItemLike mainIngredient, TagKey<Item> extraIngredient) {
        TagKey<Item> breadTag = ModTags.COMMON_FOODS_BREAD;
        ShapedRecipeBuilder.shaped(registryLookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (int)resultAmount).define(Character.valueOf('B'), breadTag).define(Character.valueOf('#'), mainIngredient).define(Character.valueOf('*'), extraIngredient).pattern(" B").pattern("*#").pattern(" B").unlockedBy("has_bread", ModDataGenHelper.has(registryLookup, breadTag)).unlockedBy("has_main_ingredient", ModDataGenHelper.has(registryLookup, mainIngredient)).unlockedBy("has_extra_ingredient", ModDataGenHelper.has(registryLookup, extraIngredient)).save(output);
    }

    public static void baseBurgerRecipe(RecipeOutput output, HolderLookup.RegistryLookup<Item> registryLookup, ItemLike result, int resultAmount, TagKey<Item> mainIngredient, TagKey<Item> extraIngredient) {
        TagKey<Item> breadTag = ModTags.COMMON_FOODS_BREAD;
        ShapedRecipeBuilder.shaped(registryLookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (int)resultAmount).define(Character.valueOf('B'), breadTag).define(Character.valueOf('#'), mainIngredient).define(Character.valueOf('*'), extraIngredient).pattern(" B").pattern("*#").pattern(" B").unlockedBy("has_bread", ModDataGenHelper.has(registryLookup, breadTag)).unlockedBy("has_main_ingredient", ModDataGenHelper.has(registryLookup, mainIngredient)).unlockedBy("has_extra_ingredient", ModDataGenHelper.has(registryLookup, extraIngredient)).save(output);
    }

    public static void eggBurgerRecipe(RecipeOutput output, HolderLookup.RegistryLookup<Item> registryLookup, ItemLike result, ItemLike ingredient) {
        TagKey<Item> friedEggTag = ModTags.COMMON_FOODS_FRIED_EGG;
        ModDataGenHelper.baseBurgerRecipe(output, registryLookup, result, 2, ingredient, friedEggTag);
    }

    public static void cheeseBurgerRecipe(RecipeOutput output, HolderLookup.RegistryLookup<Item> registryLookup, ItemLike result, ItemLike ingredient) {
        TagKey<Item> cheeseTag = ModTags.COMMON_FOODS_CHEESE;
        ModDataGenHelper.baseBurgerRecipe(output, registryLookup, result, 2, ingredient, cheeseTag);
    }

    public static void champignonBurgerRecipe(RecipeOutput output, HolderLookup.RegistryLookup<Item> registryLookup, ItemLike result, ItemLike ingredient) {
        TagKey<Item> cookedMushroomTag = ModTags.COMMON_FOODS_COOKED_MUSHROOM;
        ModDataGenHelper.baseBurgerRecipe(output, registryLookup, result, 2, ingredient, cookedMushroomTag);
    }

    public static void goldenBurgerRecipe(RecipeOutput output, HolderLookup.RegistryLookup<Item> registryLookup, ItemLike result, TagKey<Item> ingredient) {
        TagKey<Item> goldIngotTag = ModTags.COMMON_INGOTS_GOLD;
        ShapedRecipeBuilder.shaped(registryLookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result).define(Character.valueOf('G'), goldIngotTag).define(Character.valueOf('#'), ingredient).pattern("GGG").pattern("G#G").pattern("GGG").unlockedBy("has_gold", ModDataGenHelper.has(registryLookup, goldIngotTag)).unlockedBy("has_burger", ModDataGenHelper.has(registryLookup, ingredient)).save(output);
    }

    public static void baseFoodCookingRecipe(RecipeOutput output, HolderLookup.RegistryLookup<Item> registryLookup, ItemLike result, ItemLike ingredient, float experience) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)ingredient), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)200).unlockedBy("has_" + ingredient.toString(), ModDataGenHelper.has(registryLookup, ingredient)).save(output, ResourceLocation.parse((String)(String.valueOf(result) + "_from_smelting")).toString());
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike)ingredient), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)600).unlockedBy("has_" + ingredient.toString(), ModDataGenHelper.has(registryLookup, ingredient)).save(output, ResourceLocation.parse((String)(String.valueOf(result) + "_from_campfire")).toString());
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike)ingredient), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)100).unlockedBy("has_" + ingredient.toString(), ModDataGenHelper.has(registryLookup, ingredient)).save(output, ResourceLocation.parse((String)(String.valueOf(result) + "_from_smoker")).toString());
    }

    private static void cookingRecipe(RecipeOutput output, HolderLookup.RegistryLookup<Item> registryLookup, ItemLike result, ItemLike ingredient) {
        ModDataGenHelper.baseFoodCookingRecipe(output, registryLookup, result, ingredient, 0.25f);
    }

    private static void scrambledEggRecipe(RecipeOutput output, HolderLookup.RegistryLookup<Item> registryLookup, ItemLike result) {
        TagKey<Item> eggsTag = ModTags.COMMON_EGGS;
        ShapelessRecipeBuilder.shapeless(registryLookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result).requires(eggsTag).unlockedBy("has_eggs", ModDataGenHelper.has(registryLookup, eggsTag)).save(output);
    }

    private static void cheeseRecipe(RecipeOutput output, HolderLookup.RegistryLookup<Item> registryLookup, ItemLike result) {
        ModDataGenHelper.internalCheeseRecipe(output, registryLookup, result, (ItemLike)Items.MILK_BUCKET, (ItemLike)Items.SUGAR);
    }

    private static void internalCheeseRecipe(RecipeOutput output, HolderLookup.RegistryLookup<Item> registryLookup, ItemLike result, ItemLike ingredient1, ItemLike ingredient2) {
        for (int amount = 1; amount <= 8; ++amount) {
            ShapelessRecipeBuilder.shapeless(registryLookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (int)amount).requires(ingredient1).requires(ingredient2, amount).unlockedBy("has_" + ingredient1.toString(), ModDataGenHelper.has(registryLookup, ingredient1)).unlockedBy("has_" + ingredient2.toString(), ModDataGenHelper.has(registryLookup, ingredient2)).save(output, ResourceLocation.parse((String)(result.toString() + "_" + amount)).toString());
        }
    }

    private static void rawChampignonRecipe(RecipeOutput output, HolderLookup.RegistryLookup<Item> registryLookup, ItemLike result) {
        ShapelessRecipeBuilder.shapeless(registryLookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result).requires((ItemLike)Items.BROWN_MUSHROOM, 2).unlockedBy("has_brown_mushroom", ModDataGenHelper.has(registryLookup, (ItemLike)Items.BROWN_MUSHROOM)).save(output);
    }

    private static void chickenNuggetRecipe(RecipeOutput output, HolderLookup.RegistryLookup<Item> registryLookup) {
        ShapelessRecipeBuilder.shapeless(registryLookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)ModItems.COOKED_CHICKEN_NUGGET, (int)6).requires((ItemLike)Items.COOKED_CHICKEN).unlockedBy("has_cooked_chicken", ModDataGenHelper.has(registryLookup, (ItemLike)Items.COOKED_CHICKEN)).save(output);
    }

    private static void friesRecipe(RecipeOutput output, HolderLookup.RegistryLookup<Item> registryLookup) {
        ShapedRecipeBuilder.shaped(registryLookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)ModItems.FRIES, (int)2).define(Character.valueOf('P'), (ItemLike)Items.BAKED_POTATO).pattern("PPP").unlockedBy("has_baked_potato", ModDataGenHelper.has(registryLookup, (ItemLike)Items.BAKED_POTATO)).save(output);
    }

    private static void hotdogRecipe(RecipeOutput output, HolderLookup.RegistryLookup<Item> registryLookup) {
        TagKey<Item> breadTag = ModTags.COMMON_FOODS_BREAD;
        TagKey<Item> chickenNuggetsTag = ModTags.COMMON_NUGGETS_CHICKEN;
        ShapelessRecipeBuilder.shapeless(registryLookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)ModItems.HOTDOG, (int)4).requires((ItemLike)Items.COOKED_BEEF).requires((ItemLike)Items.COOKED_PORKCHOP).requires(breadTag).requires(chickenNuggetsTag).unlockedBy("has_cooked_beef", ModDataGenHelper.has(registryLookup, (ItemLike)Items.COOKED_BEEF)).unlockedBy("has_cooked_porkchop", ModDataGenHelper.has(registryLookup, (ItemLike)Items.COOKED_PORKCHOP)).unlockedBy("has_bread", ModDataGenHelper.has(registryLookup, breadTag)).unlockedBy("has_cooked_chicken_nugget", ModDataGenHelper.has(registryLookup, chickenNuggetsTag)).save(output);
    }

    private static void sweetBerryTartRecipe(RecipeOutput output, HolderLookup.RegistryLookup<Item> registryLookup) {
        ShapelessRecipeBuilder.shapeless(registryLookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)ModItems.SWEET_BERRY_TART).requires((ItemLike)Items.SWEET_BERRIES, 3).requires((ItemLike)Items.WHEAT).requires((ItemLike)Items.SUGAR).unlockedBy("has_sweet_berries", ModDataGenHelper.has(registryLookup, (ItemLike)Items.SWEET_BERRIES)).unlockedBy("has_wheat", ModDataGenHelper.has(registryLookup, (ItemLike)Items.WHEAT)).unlockedBy("has_sugar", ModDataGenHelper.has(registryLookup, (ItemLike)Items.SUGAR)).save(output);
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> has(HolderLookup.RegistryLookup<Item> registryLookup, ItemLike item) {
        return ModDataGenHelper.inventoryTrigger(ItemPredicate.Builder.item().of(registryLookup, new ItemLike[]{item}));
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> has(HolderLookup.RegistryLookup<Item> registryLookup, TagKey<Item> itemTag) {
        return ModDataGenHelper.inventoryTrigger(ItemPredicate.Builder.item().of(registryLookup, itemTag));
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate.Builder ... builder) {
        return CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.ANY, List.of((ItemPredicate[])Arrays.stream(builder).map(ItemPredicate.Builder::build).toArray(ItemPredicate[]::new))));
    }
}

