/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.burgermod.neoforge.common.loot;

import com.autovw.burgermod.common.common.loot.ChestLootAddition;
import com.autovw.burgermod.common.common.loot.LootModifierHelper;
import com.autovw.burgermod.neoforge.config.Config;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class LootAdditionModifier
extends LootModifier {
    public static final MapCodec<LootAdditionModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> LootAdditionModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)ChestLootAddition.CODEC.listOf().xmap(list -> (ChestLootAddition[])list.toArray(ChestLootAddition[]::new), List::of).fieldOf("additions").forGetter(la -> la.lootAdditions)).apply((Applicative)instance, LootAdditionModifier::new));
    private final ChestLootAddition[] lootAdditions;

    public LootAdditionModifier(LootItemCondition[] conditionsIn, ChestLootAddition[] additions) {
        super(conditionsIn);
        this.lootAdditions = additions;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation queriedTableId = context.getQueriedLootTableId();
        if (((Boolean)Config.LootConfig.generateChestLoot.get()).booleanValue()) {
            LootModifierHelper.modifiedGeneratedLoot(generatedLoot, context, this.lootAdditions, queriedTableId);
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

