/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.burgermod.neoforge.datagen;

import com.autovw.burgermod.neoforge.datagen.providers.ModAdvancementProvider;
import com.autovw.burgermod.neoforge.datagen.providers.ModItemTagsProvider;
import com.autovw.burgermod.neoforge.datagen.providers.ModLootModifierProvider;
import com.autovw.burgermod.neoforge.datagen.providers.ModModelProvider;
import com.autovw.burgermod.neoforge.datagen.providers.ModRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="burgermod", value={Dist.CLIENT})
public class ModDataGenerator {
    private ModDataGenerator() {
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        event.addProvider((DataProvider)new ModItemTagsProvider(packOutput, lookupProvider, "burgermod"));
        event.addProvider((DataProvider)new ModRecipeProvider.Runner(packOutput, lookupProvider));
        event.addProvider((DataProvider)new ModLootModifierProvider(packOutput, lookupProvider, "burgermod"));
        event.addProvider((DataProvider)new ModAdvancementProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new ModModelProvider(packOutput, "burgermod"));
    }
}

