/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.burgermod.common.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ChestLootAddition {
    public static final Codec<ChestLootAddition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("target").forGetter(ChestLootAddition::getTarget), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(ChestLootAddition::getItem), (App)Codec.INT.fieldOf("min").forGetter(ChestLootAddition::getMin), (App)Codec.INT.fieldOf("max").forGetter(ChestLootAddition::getMax), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(ChestLootAddition::getChance)).apply((Applicative)instance, ChestLootAddition::new));
    private final ResourceLocation target;
    private final Item item;
    private final int min;
    private final int max;
    private final float chance;

    public ChestLootAddition(ResourceLocation target, Item item, int min, int max, float chance) {
        this.target = target;
        this.item = item;
        this.min = min;
        this.max = max;
        this.chance = chance;
    }

    public ChestLootAddition(ResourceLocation target, Item item, int min, int max) {
        this(target, item, min, max, 1.0f);
    }

    public ResourceLocation getTarget() {
        return this.target;
    }

    public Item getItem() {
        return this.item;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public float getChance() {
        return this.chance;
    }
}

