/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.burgermod.common.datagen;

import com.autovw.burgermod.common.core.ModItems;
import com.autovw.burgermod.common.core.util.ModTags;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ModDataGenHelper {
    public static void advancements(HolderLookup.Provider registries, Consumer<AdvancementHolder> consumer) {
        Advancement.Builder.advancement().parent(ResourceLocation.withDefaultNamespace((String)"husbandry/root")).display((ItemLike)ModItems.FRIES, (Component)Component.translatable((String)"advancements.burgermod.husbandry.obtain_fries.title"), (Component)Component.translatable((String)"advancements.burgermod.husbandry.obtain_fries.description"), null, AdvancementType.TASK, true, true, false).addCriterion("fries", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.FRIES})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"burgermod", (String)"husbandry/obtain_fries").toString());
        AdvancementHolder craftBurger = Advancement.Builder.advancement().parent(ResourceLocation.withDefaultNamespace((String)"husbandry/plant_seed")).display((ItemLike)ModItems.BEEF_BURGER, (Component)Component.translatable((String)"advancements.burgermod.husbandry.craft_burger.title"), (Component)Component.translatable((String)"advancements.burgermod.husbandry.craft_burger.description"), null, AdvancementType.TASK, true, true, false).addCriterion("burgers", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(ModTags.BURGERS)})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"burgermod", (String)"husbandry/craft_burger").toString());
        AdvancementHolder goldenBurger = Advancement.Builder.advancement().parent(craftBurger).display((ItemLike)ModItems.GOLDEN_BEEF_BURGER, (Component)Component.translatable((String)"advancements.burgermod.husbandry.craft_golden_burger.title"), (Component)Component.translatable((String)"advancements.burgermod.husbandry.craft_golden_burger.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("golden_burgers", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(ModTags.GOLDEN_BURGERS)})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"burgermod", (String)"husbandry/craft_golden_burger").toString());
        Advancement.Builder.advancement().parent(goldenBurger).display((ItemLike)ModItems.ENCHANTED_GOLDEN_BURGER, (Component)Component.translatable((String)"advancements.burgermod.husbandry.obtain_enchanted_golden_burger.title"), (Component)Component.translatable((String)"advancements.burgermod.husbandry.obtain_enchanted_golden_burger.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("enchanted_golden_burger", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(new ItemLike[]{ModItems.ENCHANTED_GOLDEN_BURGER})})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"burgermod", (String)"husbandry/obtain_enchanted_golden_burger").toString());
    }

    public static void recipes(RecipeOutput output) {
        ModDataGenHelper.eggBurgerRecipe(output, (ItemLike)ModItems.BEEF_BURGER, (ItemLike)Items.COOKED_BEEF);
        ModDataGenHelper.eggBurgerRecipe(output, (ItemLike)ModItems.PORK_BURGER, (ItemLike)Items.COOKED_PORKCHOP);
        ModDataGenHelper.eggBurgerRecipe(output, (ItemLike)ModItems.MUTTON_BURGER, (ItemLike)Items.COOKED_MUTTON);
        ModDataGenHelper.eggBurgerRecipe(output, (ItemLike)ModItems.CHICKEN_BURGER, (ItemLike)Items.COOKED_CHICKEN);
        ModDataGenHelper.eggBurgerRecipe(output, (ItemLike)ModItems.SALMON_BURGER, (ItemLike)Items.COOKED_SALMON);
        ModDataGenHelper.eggBurgerRecipe(output, (ItemLike)ModItems.COD_BURGER, (ItemLike)Items.COOKED_COD);
        ModDataGenHelper.cheeseBurgerRecipe(output, (ItemLike)ModItems.BEEF_CHEESE_BURGER, (ItemLike)Items.COOKED_BEEF);
        ModDataGenHelper.cheeseBurgerRecipe(output, (ItemLike)ModItems.PORK_CHEESE_BURGER, (ItemLike)Items.COOKED_PORKCHOP);
        ModDataGenHelper.cheeseBurgerRecipe(output, (ItemLike)ModItems.MUTTON_CHEESE_BURGER, (ItemLike)Items.COOKED_MUTTON);
        ModDataGenHelper.cheeseBurgerRecipe(output, (ItemLike)ModItems.CHICKEN_CHEESE_BURGER, (ItemLike)Items.COOKED_CHICKEN);
        ModDataGenHelper.cheeseBurgerRecipe(output, (ItemLike)ModItems.SALMON_CHEESE_BURGER, (ItemLike)Items.COOKED_SALMON);
        ModDataGenHelper.cheeseBurgerRecipe(output, (ItemLike)ModItems.COD_CHEESE_BURGER, (ItemLike)Items.COOKED_COD);
        ModDataGenHelper.champignonBurgerRecipe(output, (ItemLike)ModItems.BEEF_CHAMPIGNON_BURGER, (ItemLike)Items.COOKED_BEEF);
        ModDataGenHelper.champignonBurgerRecipe(output, (ItemLike)ModItems.PORK_CHAMPIGNON_BURGER, (ItemLike)Items.COOKED_PORKCHOP);
        ModDataGenHelper.champignonBurgerRecipe(output, (ItemLike)ModItems.MUTTON_CHAMPIGNON_BURGER, (ItemLike)Items.COOKED_MUTTON);
        ModDataGenHelper.champignonBurgerRecipe(output, (ItemLike)ModItems.CHICKEN_CHAMPIGNON_BURGER, (ItemLike)Items.COOKED_CHICKEN);
        ModDataGenHelper.champignonBurgerRecipe(output, (ItemLike)ModItems.SALMON_CHAMPIGNON_BURGER, (ItemLike)Items.COOKED_SALMON);
        ModDataGenHelper.champignonBurgerRecipe(output, (ItemLike)ModItems.COD_CHAMPIGNON_BURGER, (ItemLike)Items.COOKED_COD);
        ModDataGenHelper.goldenBurgerRecipe(output, (ItemLike)ModItems.GOLDEN_BEEF_BURGER, ModTags.BEEF_BURGERS);
        ModDataGenHelper.goldenBurgerRecipe(output, (ItemLike)ModItems.GOLDEN_PORK_BURGER, ModTags.PORK_BURGERS);
        ModDataGenHelper.goldenBurgerRecipe(output, (ItemLike)ModItems.GOLDEN_MUTTON_BURGER, ModTags.MUTTON_BURGERS);
        ModDataGenHelper.goldenBurgerRecipe(output, (ItemLike)ModItems.GOLDEN_CHICKEN_BURGER, ModTags.CHICKEN_BURGERS);
        ModDataGenHelper.goldenBurgerRecipe(output, (ItemLike)ModItems.GOLDEN_SALMON_BURGER, ModTags.SALMON_BURGERS);
        ModDataGenHelper.goldenBurgerRecipe(output, (ItemLike)ModItems.GOLDEN_COD_BURGER, ModTags.COD_BURGERS);
        ModDataGenHelper.scrambledEggRecipe(output, (ItemLike)ModItems.SCRAMBLED_EGG);
        ModDataGenHelper.cookingRecipe(output, (ItemLike)ModItems.FRIED_SCRAMBLED_EGG, (ItemLike)ModItems.SCRAMBLED_EGG);
        ModDataGenHelper.cheeseRecipe(output, (ItemLike)ModItems.CHEESE);
        ModDataGenHelper.rawChampignonRecipe(output, (ItemLike)ModItems.RAW_CHAMPIGNONS);
        ModDataGenHelper.cookingRecipe(output, (ItemLike)ModItems.COOKED_CHAMPIGNONS, (ItemLike)ModItems.RAW_CHAMPIGNONS);
        ModDataGenHelper.chickenNuggetRecipe(output);
        ModDataGenHelper.friesRecipe(output);
        ModDataGenHelper.hotdogRecipe(output);
        ModDataGenHelper.sweetBerryTartRecipe(output);
    }

    public static void baseBurgerRecipe(RecipeOutput output, ItemLike result, int resultAmount, ItemLike mainIngredient, TagKey<Item> extraIngredient) {
        TagKey<Item> breadTag = ModTags.COMMON_FOODS_BREAD;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (int)resultAmount).define(Character.valueOf('B'), breadTag).define(Character.valueOf('#'), mainIngredient).define(Character.valueOf('*'), extraIngredient).pattern(" B").pattern("*#").pattern(" B").unlockedBy("has_bread", ModDataGenHelper.has(breadTag)).unlockedBy("has_main_ingredient", ModDataGenHelper.has(mainIngredient)).unlockedBy("has_extra_ingredient", ModDataGenHelper.has(extraIngredient)).save(output);
    }

    public static void baseBurgerRecipe(RecipeOutput output, ItemLike result, int resultAmount, TagKey<Item> mainIngredient, TagKey<Item> extraIngredient) {
        TagKey<Item> breadTag = ModTags.COMMON_FOODS_BREAD;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (int)resultAmount).define(Character.valueOf('B'), breadTag).define(Character.valueOf('#'), mainIngredient).define(Character.valueOf('*'), extraIngredient).pattern(" B").pattern("*#").pattern(" B").unlockedBy("has_bread", ModDataGenHelper.has(breadTag)).unlockedBy("has_main_ingredient", ModDataGenHelper.has(mainIngredient)).unlockedBy("has_extra_ingredient", ModDataGenHelper.has(extraIngredient)).save(output);
    }

    public static void eggBurgerRecipe(RecipeOutput output, ItemLike result, ItemLike ingredient) {
        ModDataGenHelper.baseBurgerRecipe(output, result, 2, ingredient, ModTags.COMMON_FOODS_FRIED_EGG);
    }

    public static void cheeseBurgerRecipe(RecipeOutput output, ItemLike result, ItemLike ingredient) {
        ModDataGenHelper.baseBurgerRecipe(output, result, 2, ingredient, ModTags.COMMON_FOODS_CHEESE);
    }

    public static void champignonBurgerRecipe(RecipeOutput output, ItemLike result, ItemLike ingredient) {
        ModDataGenHelper.baseBurgerRecipe(output, result, 2, ingredient, ModTags.COMMON_FOODS_COOKED_MUSHROOM);
    }

    public static void goldenBurgerRecipe(RecipeOutput output, ItemLike result, TagKey<Item> ingredient) {
        TagKey<Item> goldIngotTag = ModTags.COMMON_INGOTS_GOLD;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)result).define(Character.valueOf('G'), goldIngotTag).define(Character.valueOf('#'), ingredient).pattern("GGG").pattern("G#G").pattern("GGG").unlockedBy("has_gold", ModDataGenHelper.has(goldIngotTag)).unlockedBy("has_burger", ModDataGenHelper.has(ingredient)).save(output);
    }

    public static void baseFoodCookingRecipe(RecipeOutput output, ItemLike result, ItemLike ingredient, float experience) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)200).unlockedBy("has_" + ingredient.toString(), ModDataGenHelper.has(ingredient)).save(output, ResourceLocation.parse((String)(String.valueOf(result) + "_from_smelting")));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)600).unlockedBy("has_" + ingredient.toString(), ModDataGenHelper.has(ingredient)).save(output, ResourceLocation.parse((String)(String.valueOf(result) + "_from_campfire")));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)100).unlockedBy("has_" + ingredient.toString(), ModDataGenHelper.has(ingredient)).save(output, ResourceLocation.parse((String)(String.valueOf(result) + "_from_smoker")));
    }

    private static void cookingRecipe(RecipeOutput output, ItemLike result, ItemLike ingredient) {
        ModDataGenHelper.baseFoodCookingRecipe(output, result, ingredient, 0.25f);
    }

    private static void scrambledEggRecipe(RecipeOutput output, ItemLike result) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)result).requires(ModTags.COMMON_EGGS).unlockedBy("has_eggs", ModDataGenHelper.has(ModTags.COMMON_EGGS)).save(output);
    }

    private static void cheeseRecipe(RecipeOutput output, ItemLike result) {
        ModDataGenHelper.internalCheeseRecipe(output, result, (ItemLike)Items.MILK_BUCKET, (ItemLike)Items.SUGAR);
    }

    private static void internalCheeseRecipe(RecipeOutput output, ItemLike result, ItemLike ingredient1, ItemLike ingredient2) {
        for (int amount = 1; amount <= 8; ++amount) {
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (int)amount).requires(ingredient1).requires(ingredient2, amount).unlockedBy("has_" + ingredient1.toString(), ModDataGenHelper.has(ingredient1)).unlockedBy("has_" + ingredient2.toString(), ModDataGenHelper.has(ingredient2)).save(output, ResourceLocation.parse((String)(result.toString() + "_" + amount)));
        }
    }

    private static void rawChampignonRecipe(RecipeOutput output, ItemLike result) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)result).requires((ItemLike)Items.BROWN_MUSHROOM, 2).unlockedBy("has_brown_mushroom", ModDataGenHelper.has((ItemLike)Items.BROWN_MUSHROOM)).save(output);
    }

    private static void chickenNuggetRecipe(RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)ModItems.COOKED_CHICKEN_NUGGET, (int)6).requires((ItemLike)Items.COOKED_CHICKEN).unlockedBy("has_cooked_chicken", ModDataGenHelper.has((ItemLike)Items.COOKED_CHICKEN)).save(output);
    }

    private static void friesRecipe(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)ModItems.FRIES, (int)2).define(Character.valueOf('P'), (ItemLike)Items.BAKED_POTATO).pattern("PPP").unlockedBy("has_baked_potato", ModDataGenHelper.has((ItemLike)Items.BAKED_POTATO)).save(output);
    }

    private static void hotdogRecipe(RecipeOutput output) {
        TagKey<Item> breadTag = ModTags.COMMON_FOODS_BREAD;
        TagKey<Item> chickenNuggetsTag = ModTags.COMMON_NUGGETS_CHICKEN;
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)ModItems.HOTDOG, (int)4).requires((ItemLike)Items.COOKED_BEEF).requires((ItemLike)Items.COOKED_PORKCHOP).requires(breadTag).requires(chickenNuggetsTag).unlockedBy("has_cooked_beef", ModDataGenHelper.has((ItemLike)Items.COOKED_BEEF)).unlockedBy("has_cooked_porkchop", ModDataGenHelper.has((ItemLike)Items.COOKED_PORKCHOP)).unlockedBy("has_bread", ModDataGenHelper.has(breadTag)).unlockedBy("has_cooked_chicken_nugget", ModDataGenHelper.has(chickenNuggetsTag)).save(output);
    }

    private static void sweetBerryTartRecipe(RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)ModItems.SWEET_BERRY_TART).requires((ItemLike)Items.SWEET_BERRIES, 3).requires((ItemLike)Items.WHEAT).requires((ItemLike)Items.SUGAR).unlockedBy("has_sweet_berries", ModDataGenHelper.has((ItemLike)Items.SWEET_BERRIES)).unlockedBy("has_wheat", ModDataGenHelper.has((ItemLike)Items.WHEAT)).unlockedBy("has_sugar", ModDataGenHelper.has((ItemLike)Items.SUGAR)).save(output);
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemLike item) {
        return ModDataGenHelper.inventoryTrigger(ItemPredicate.Builder.item().of(new ItemLike[]{item}));
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> has(TagKey<Item> itemTag) {
        return ModDataGenHelper.inventoryTrigger(ItemPredicate.Builder.item().of(itemTag));
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate.Builder ... builder) {
        return CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.ANY, List.of((ItemPredicate[])Arrays.stream(builder).map(ItemPredicate.Builder::build).toArray(ItemPredicate[]::new))));
    }
}

