/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.burgermod.neoforge.datagen;

import com.autovw.burgermod.neoforge.datagen.providers.ModAdvancementProvider;
import com.autovw.burgermod.neoforge.datagen.providers.ModBlockTagsProvider;
import com.autovw.burgermod.neoforge.datagen.providers.ModItemModelProvider;
import com.autovw.burgermod.neoforge.datagen.providers.ModItemTagsProvider;
import com.autovw.burgermod.neoforge.datagen.providers.ModLootModifierProvider;
import com.autovw.burgermod.neoforge.datagen.providers.ModRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="burgermod", bus=EventBusSubscriber.Bus.MOD)
public class ModDataGenerator {
    private ModDataGenerator() {
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        ModBlockTagsProvider blockTagsProvider = new ModBlockTagsProvider(packOutput, lookupProvider, "burgermod", helper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), "burgermod", helper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootModifierProvider(packOutput, lookupProvider, "burgermod"));
        generator.addProvider(event.includeServer(), (DataProvider)new ModAdvancementProvider(packOutput, lookupProvider, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, "burgermod", helper));
    }
}

