/*
 * Decompiled with CFR 0.152.
 */
package de.lxca.slimeRanks;

import de.lxca.slimeRanks.commands.SlimeranksCommand;
import de.lxca.slimeRanks.listeners.AsyncChatListener;
import de.lxca.slimeRanks.listeners.ChunkLoadListener;
import de.lxca.slimeRanks.listeners.EntityAddToWorldListener;
import de.lxca.slimeRanks.listeners.EntityPotionEffectListener;
import de.lxca.slimeRanks.listeners.InventoryClickListener;
import de.lxca.slimeRanks.listeners.PlayerChangedWorldListener;
import de.lxca.slimeRanks.listeners.PlayerDeathListener;
import de.lxca.slimeRanks.listeners.PlayerGameModeChangeListener;
import de.lxca.slimeRanks.listeners.PlayerHideEntityListener;
import de.lxca.slimeRanks.listeners.PlayerJoinListener;
import de.lxca.slimeRanks.listeners.PlayerPostRespawnListener;
import de.lxca.slimeRanks.listeners.PlayerQuitListener;
import de.lxca.slimeRanks.listeners.PlayerShowEntityListener;
import de.lxca.slimeRanks.listeners.PlayerToggleSneakListener;
import de.lxca.slimeRanks.objects.Message;
import de.lxca.slimeRanks.objects.Metrics;
import de.lxca.slimeRanks.objects.Placeholder;
import de.lxca.slimeRanks.objects.PlayerNameTag;
import de.lxca.slimeRanks.objects.RankManager;
import de.lxca.slimeRanks.objects.TeamManager;
import de.lxca.slimeRanks.objects.UpdateChecker;
import de.lxca.slimeRanks.objects.configurations.ConfigYml;
import de.lxca.slimeRanks.objects.configurations.MessagesYml;
import de.lxca.slimeRanks.objects.configurations.RanksYml;
import de.lxca.slimeRanks.schedulers.NameUpdateScheduler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public final class Main
extends JavaPlugin {
    private static ConfigYml configYml;
    private static MessagesYml messagesYml;
    private static RanksYml ranksYml;
    private static Metrics metrics;
    private static BukkitTask nameUpdateTask;

    public void onEnable() {
        Main.initializeVariables();
        CommandMap commandMap = Bukkit.getCommandMap();
        commandMap.register("slimeventure", (Command)new SlimeranksCommand("slimeranks"));
        PluginManager pluginManager = Bukkit.getPluginManager();
        Listener[] listeners = new Listener[]{new AsyncChatListener(), new ChunkLoadListener(), new EntityAddToWorldListener(), new EntityPotionEffectListener(), new InventoryClickListener(), new PlayerChangedWorldListener(), new PlayerDeathListener(), new PlayerGameModeChangeListener(), new PlayerHideEntityListener(), new PlayerJoinListener(), new PlayerPostRespawnListener(), new PlayerQuitListener(), new PlayerShowEntityListener(), new PlayerToggleSneakListener()};
        for (Listener listener : listeners) {
            pluginManager.registerEvents(listener, (Plugin)this);
        }
        if (pluginManager.getPlugin("PlaceholderAPI") != null) {
            new Placeholder().register();
        }
        Main.runNameUpdateTask();
        for (World world : Bukkit.getWorlds()) {
            PlayerNameTag.clearBuggyNameTags(world);
        }
        if (!Bukkit.getOnlinePlayers().isEmpty()) {
            RankManager.getInstance().reloadDisplays();
        }
        Main.initializeMetrics();
        new UpdateChecker().notifyUpdateAvailable((CommandSender)Bukkit.getConsoleSender());
    }

    public void onDisable() {
        if (Main.isFolia()) {
            return;
        }
        for (World world : Bukkit.getWorlds()) {
            PlayerNameTag.clearBuggyNameTags(world);
        }
        TeamManager.getInstance().removeInvisibleNameTagTeam();
    }

    @NotNull
    public static Main getInstance() {
        return (Main)Main.getPlugin(Main.class);
    }

    public static Logger getLogger(Class<?> clazz) {
        return LogManager.getLogger(clazz);
    }

    public static Logger getLogger(String prefix) {
        return LogManager.getLogger((String)prefix);
    }

    public static void initializeVariables() {
        configYml = new ConfigYml();
        messagesYml = new MessagesYml();
        ranksYml = new RanksYml();
        metrics = new Metrics((Plugin)Main.getInstance(), 24715);
    }

    private static void initializeMetrics() {
        metrics.addCustomChart(new Metrics.SingleLineChart("created_ranks", () -> RankManager.getInstance().getRankCount()));
        metrics.addCustomChart(new Metrics.SimplePie("rank_count", () -> String.valueOf(RankManager.getInstance().getRankCount())));
    }

    public static ConfigYml getConfigYml() {
        return configYml;
    }

    public static MessagesYml getMessagesYml() {
        return messagesYml;
    }

    public static RanksYml getRanksYml() {
        return ranksYml;
    }

    public static void reload() {
        Message.resetPrefix();
        Main.initializeVariables();
        RankManager.getInstance().reloadRanks();
        RankManager.getInstance().reloadDisplays();
        Main.runNameUpdateTask();
    }

    public static boolean isPluginEnabled(@NotNull String pluginName) {
        return Bukkit.getPluginManager().isPluginEnabled(pluginName);
    }

    public static void runNameUpdateTask() {
        int nameUpdateInterval;
        if (nameUpdateTask != null) {
            nameUpdateTask.cancel();
        }
        if ((nameUpdateInterval = configYml.getYmlConfig().getInt("NameUpdateInterval")) > 0) {
            nameUpdateTask = Bukkit.getScheduler().runTaskTimer((Plugin)Main.getInstance(), (Runnable)new NameUpdateScheduler(), (long)nameUpdateInterval * 20L, (long)nameUpdateInterval * 20L);
        }
    }

    public static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

