/*
 * Decompiled with CFR 0.152.
 */
package de.lxca.slimeRanks.commands;

import de.lxca.slimeRanks.Main;
import de.lxca.slimeRanks.guis.RankOverviewGui;
import de.lxca.slimeRanks.objects.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SlimeranksCommand
extends Command {
    public SlimeranksCommand(@NotNull String name) {
        super(name);
        this.setAliases(List.of("sr", "rank", "ranks"));
        this.setDescription("Command to manage the SlimeRanks plugin.");
        this.setPermission("slimeranks.admin");
    }

    public boolean execute(@NotNull CommandSender commandSender, @NotNull String s, @NotNull @NotNull String @NotNull [] strings) {
        if (strings.length == 0) {
            this.sendAboutMessage(commandSender);
            return true;
        }
        if (strings.length == 1) {
            switch (strings[0]) {
                case "about": {
                    this.sendAboutMessage(commandSender);
                    return true;
                }
                case "gui": {
                    if (commandSender instanceof Player) {
                        Player player = (Player)commandSender;
                        player.openInventory(new RankOverviewGui().getInventory());
                        return true;
                    }
                    new Message(commandSender, true, "Chat.Command.OnlyPlayers");
                    return false;
                }
                case "help": {
                    new Message(commandSender, false, "Chat.Command.Help");
                    return true;
                }
                case "reload": {
                    Main.reload();
                    new Message(commandSender, true, "Chat.Command.Reload");
                    return true;
                }
            }
            this.sendUnknownMessage(commandSender, s, strings);
            return false;
        }
        this.sendUnknownMessage(commandSender, s, strings);
        return false;
    }

    private void sendAboutMessage(@NotNull CommandSender commandSender) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("author", (String)Main.getInstance().getPluginMeta().getAuthors().getFirst());
        replacements.put("description", Main.getInstance().getPluginMeta().getDescription());
        replacements.put("version", Main.getInstance().getPluginMeta().getVersion());
        new Message(commandSender, false, "Chat.Command.About", replacements);
    }

    private void sendUnknownMessage(@NotNull CommandSender commandSender, @NotNull String s, @NotNull @NotNull String @NotNull [] strings) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("command", "/" + s + " " + String.join((CharSequence)" ", strings));
        new Message(commandSender, true, "Chat.Command.Unknown", replacements);
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String @NotNull [] args) {
        if (!sender.hasPermission("slimeranks.admin")) {
            return Collections.emptyList();
        }
        ArrayList<String> completerList = new ArrayList<String>();
        if (args.length == 1) {
            completerList.add("about");
            completerList.add("gui");
            completerList.add("help");
            completerList.add("reload");
        }
        ArrayList<String> completerListFiltered = new ArrayList<String>();
        for (String loopString : completerList) {
            String loopStringLowerCase = loopString.toLowerCase();
            if (!loopStringLowerCase.startsWith(args[args.length - 1].toLowerCase())) continue;
            completerListFiltered.add(loopString);
        }
        return completerListFiltered;
    }
}

