/*
 * Decompiled with CFR 0.152.
 */
package de.lxca.slimeRanks.guis;

import de.lxca.slimeRanks.Main;
import de.lxca.slimeRanks.enums.FormatType;
import de.lxca.slimeRanks.enums.WeightType;
import de.lxca.slimeRanks.guis.RankOverviewGui;
import de.lxca.slimeRanks.items.EditItems;
import de.lxca.slimeRanks.items.GlobalItems;
import de.lxca.slimeRanks.objects.Message;
import de.lxca.slimeRanks.objects.Rank;
import de.lxca.slimeRanks.objects.dialogs.FormatDialog;
import de.lxca.slimeRanks.objects.dialogs.PermissionDialog;
import de.lxca.slimeRanks.objects.dialogs.WeightDialog;
import java.util.HashMap;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public class RankEditGui
implements InventoryHolder {
    private static final int guiSize = 54;
    private final Inventory inventory;
    private final Rank rank;

    public RankEditGui(@NotNull Rank rank) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("identifier", rank.getIdentifier());
        this.inventory = Main.getInstance().getServer().createInventory((InventoryHolder)this, 54, new Message("Gui.Edit.Title", replacements).getMessage());
        this.rank = rank;
        this.setItems();
    }

    private void setItems() {
        for (int i = 0; i < 54; ++i) {
            this.inventory.setItem(i, GlobalItems.getBackgroundItem());
        }
        this.inventory.setItem(4, GlobalItems.getRankItem(this.rank));
        this.inventory.setItem(10, EditItems.getHideOnSneakItem(this.rank));
        this.inventory.setItem(12, EditItems.getTablistItem(this.rank));
        this.inventory.setItem(13, EditItems.getChatItem(this.rank));
        this.inventory.setItem(14, EditItems.getNameTagItem(this.rank));
        this.inventory.setItem(16, EditItems.getColoredMessagesItem(this.rank));
        this.inventory.setItem(19, EditItems.getStatusItem(this.rank.hideNameTagOnSneak()));
        this.inventory.setItem(21, EditItems.getStatusItem(this.rank.tabIsActive()));
        this.inventory.setItem(22, EditItems.getStatusItem(this.rank.chatIsActive()));
        this.inventory.setItem(23, EditItems.getStatusItem(this.rank.nameTagIsActive()));
        this.inventory.setItem(25, EditItems.getStatusItem(this.rank.getColoredMessages()));
        this.inventory.setItem(38, EditItems.getRankPriorityItem(this.rank));
        this.inventory.setItem(40, EditItems.getPermissionItem(this.rank));
        this.inventory.setItem(42, EditItems.getTabPriorityItem(this.rank));
        this.inventory.setItem(45, GlobalItems.getBackItem());
        this.inventory.setItem(53, EditItems.getDeleteItem());
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void clickHandler(@NotNull InventoryClickEvent event) {
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        if (slot == 12) {
            new FormatDialog(player, this.rank, FormatType.TAB).open();
        } else if (slot == 13) {
            new FormatDialog(player, this.rank, FormatType.CHAT).open();
        } else if (slot == 14) {
            new FormatDialog(player, this.rank, FormatType.NAME_TAG).open();
        } else if (slot == 19) {
            this.rank.setHideNameTagOnSneak(!this.rank.hideNameTagOnSneak());
            this.inventory.setItem(4, GlobalItems.getRankItem(this.rank));
            this.inventory.setItem(10, EditItems.getHideOnSneakItem(this.rank));
            this.inventory.setItem(slot, EditItems.getStatusItem(this.rank.hideNameTagOnSneak()));
            player.playSound((Entity)player, Sound.BLOCK_LEVER_CLICK, 1.0f, 1.0f);
        } else if (slot == 21) {
            this.rank.setTabActive(!this.rank.tabIsActive());
            this.inventory.setItem(slot, EditItems.getStatusItem(this.rank.tabIsActive()));
            player.playSound((Entity)player, Sound.BLOCK_LEVER_CLICK, 1.0f, 1.0f);
        } else if (slot == 22) {
            this.rank.setChatActive(!this.rank.chatIsActive());
            this.inventory.setItem(slot, EditItems.getStatusItem(this.rank.chatIsActive()));
            player.playSound((Entity)player, Sound.BLOCK_LEVER_CLICK, 1.0f, 1.0f);
        } else if (slot == 23) {
            this.rank.setNameTagActive(!this.rank.nameTagIsActive());
            this.inventory.setItem(slot, EditItems.getStatusItem(this.rank.nameTagIsActive()));
            player.playSound((Entity)player, Sound.BLOCK_LEVER_CLICK, 1.0f, 1.0f);
        } else if (slot == 25) {
            this.rank.setColoredMessages(!this.rank.getColoredMessages());
            this.inventory.setItem(4, GlobalItems.getRankItem(this.rank));
            this.inventory.setItem(16, EditItems.getColoredMessagesItem(this.rank));
            this.inventory.setItem(slot, EditItems.getStatusItem(this.rank.getColoredMessages()));
            player.playSound((Entity)player, Sound.BLOCK_LEVER_CLICK, 1.0f, 1.0f);
        } else if (slot == 38) {
            new WeightDialog(player, this.rank, WeightType.RANK).open();
        } else if (slot == 40) {
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT) {
                this.rank.setPermission(null);
                this.inventory.setItem(slot, EditItems.getPermissionItem(this.rank));
                player.playSound((Entity)player, Sound.BLOCK_LAVA_POP, 1.0f, 1.0f);
            } else {
                new PermissionDialog(player, this.rank).open();
            }
        } else if (slot == 42) {
            new WeightDialog(player, this.rank, WeightType.TAB).open();
        } else if (slot == 45) {
            player.openInventory(new RankOverviewGui().getInventory());
            player.playSound((Entity)player, Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.0f);
        } else if (slot == 53 && (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT)) {
            this.rank.delete();
            player.openInventory(new RankOverviewGui().getInventory());
            player.playSound((Entity)player, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
        }
    }
}

