/*
 * Decompiled with CFR 0.152.
 */
package de.lxca.slimeRanks.guis;

import de.lxca.slimeRanks.Main;
import de.lxca.slimeRanks.guis.RankEditGui;
import de.lxca.slimeRanks.items.GlobalItems;
import de.lxca.slimeRanks.items.OverviewItems;
import de.lxca.slimeRanks.objects.Message;
import de.lxca.slimeRanks.objects.Rank;
import de.lxca.slimeRanks.objects.RankManager;
import de.lxca.slimeRanks.objects.dialogs.RankIdentifierDialog;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public class RankOverviewGui
implements InventoryHolder {
    private static final int guiSize = 36;
    private static final List<Integer> rankSlots = List.of(10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25);
    private final Inventory inventory = Main.getInstance().getServer().createInventory((InventoryHolder)this, 36, new Message("Gui.Overview.Title").getMessage());
    private ArrayList<Rank> ranks;
    private int page;

    public RankOverviewGui() {
        this.setRanks();
        this.page = 1;
        this.setItems();
    }

    private void setRanks() {
        this.ranks = RankManager.getInstance().getRanks();
    }

    private void setItems() {
        for (int i = 0; i < 36; ++i) {
            this.inventory.setItem(i, GlobalItems.getBackgroundItem());
        }
        this.inventory.setItem(4, OverviewItems.getTitleItem());
        for (Integer rankSlot : rankSlots) {
            if (this.ranks.size() > (this.page - 1) * rankSlots.size() + rankSlots.indexOf(rankSlot)) {
                Rank rank = this.ranks.get((this.page - 1) * rankSlots.size() + rankSlots.indexOf(rankSlot));
                this.inventory.setItem(rankSlot.intValue(), GlobalItems.getRankItem(rank));
                continue;
            }
            this.inventory.clear(rankSlot.intValue());
        }
        this.inventory.setItem(30, GlobalItems.getPreviousPageItem(this.page > 1));
        this.inventory.setItem(32, GlobalItems.getNextPageItem(this.ranks.size() > this.page * rankSlots.size()));
        this.inventory.setItem(34, OverviewItems.getReloadItem());
        this.inventory.setItem(35, OverviewItems.getCreateRankItem());
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void clickHandler(@NotNull InventoryClickEvent event) {
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        if (rankSlots.contains(slot)) {
            if (this.ranks.size() > (this.page - 1) * rankSlots.size() + rankSlots.indexOf(slot)) {
                Rank rank = this.ranks.get((this.page - 1) * rankSlots.size() + rankSlots.indexOf(slot));
                player.openInventory(new RankEditGui(rank).getInventory());
                player.playSound((Entity)player, Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.0f);
            }
        } else if (slot == 30) {
            if (this.page > 1) {
                --this.page;
                this.setItems();
                player.playSound((Entity)player, Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.0f);
            }
        } else if (slot == 32) {
            if (this.ranks.size() > this.page * rankSlots.size()) {
                ++this.page;
                this.setItems();
                player.playSound((Entity)player, Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.0f);
            }
        } else if (slot == 34) {
            Main.reload();
            this.setRanks();
            this.setItems();
            player.playSound((Entity)player, Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 2.0f);
        } else if (slot == 35) {
            new RankIdentifierDialog(player).open();
        }
    }
}

