/*
 * Decompiled with CFR 0.152.
 */
package de.lxca.slimeRanks.items;

import de.lxca.slimeRanks.objects.ItemBuilder;
import de.lxca.slimeRanks.objects.Rank;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GlobalItems {
    public static ItemStack getBackgroundItem() {
        ItemBuilder itemBuilder = new ItemBuilder(Material.BLACK_STAINED_GLASS_PANE);
        itemBuilder.setHideTooltip(true);
        return itemBuilder.getItemStack();
    }

    public static ItemStack getBackItem() {
        ItemBuilder itemBuilder = new ItemBuilder(Material.ARROW);
        itemBuilder.setItemName("Gui.Global.ItemName.Back");
        return itemBuilder.getItemStack();
    }

    public static ItemStack getPreviousPageItem(boolean pageAvailable) {
        ItemBuilder itemBuilder = new ItemBuilder(pageAvailable ? Material.PAPER : Material.BLACK_STAINED_GLASS_PANE);
        if (pageAvailable) {
            itemBuilder.setItemName("Gui.Global.ItemName.PreviousPage");
        } else {
            itemBuilder.setHideTooltip(true);
        }
        return itemBuilder.getItemStack();
    }

    public static ItemStack getNextPageItem(boolean pageAvailable) {
        ItemBuilder itemBuilder = new ItemBuilder(pageAvailable ? Material.PAPER : Material.BLACK_STAINED_GLASS_PANE);
        if (pageAvailable) {
            itemBuilder.setItemName("Gui.Global.ItemName.NextPage");
        } else {
            itemBuilder.setHideTooltip(true);
        }
        return itemBuilder.getItemStack();
    }

    public static ItemStack getRankItem(@NotNull Rank rank) {
        TooltipDisplay.Builder tooltipDisplayBuilder = TooltipDisplay.tooltipDisplay().addHiddenComponents(new DataComponentType[]{DataComponentTypes.ATTRIBUTE_MODIFIERS});
        ItemBuilder itemBuilder = new ItemBuilder(Material.FILLED_MAP);
        HashMap<String, String> nameReplacements = new HashMap<String, String>();
        HashMap<String, String> loreReplacements = new HashMap<String, String>();
        nameReplacements.put("identifier", rank.getIdentifier());
        loreReplacements.put("identifier", rank.getIdentifier());
        loreReplacements.put("tablist_format", rank.getRawTabFormat());
        loreReplacements.put("chat_format", rank.getRawChatFormat());
        loreReplacements.put("name_tag_format", rank.getRawNameTagFormat());
        loreReplacements.put("rank_priority", String.valueOf(rank.getRankPriority()));
        loreReplacements.put("permission", rank.getPermission() == null ? "%Placeholder.None" : rank.getPermission());
        loreReplacements.put("tab_priority", String.valueOf(rank.getTabPriority()));
        loreReplacements.put("hide_name_tag_on_sneak", rank.hideNameTagOnSneak() ? "%Placeholder.Yes" : "%Placeholder.No");
        loreReplacements.put("colored_messages", rank.getColoredMessages() ? "%Placeholder.Yes" : "%Placeholder.No");
        itemBuilder.setItemName("Gui.Global.ItemName.Rank", nameReplacements);
        itemBuilder.setLore("Gui.Global.ItemLore.Rank", loreReplacements);
        itemBuilder.setTooltipDisplay(tooltipDisplayBuilder);
        return itemBuilder.getItemStack();
    }
}

