/*
 * Decompiled with CFR 0.152.
 */
package de.lxca.slimeRanks.objects;

import de.lxca.slimeRanks.Main;
import de.lxca.slimeRanks.objects.Message;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ItemBuilder {
    private final ItemStack itemStack;
    private final ItemMeta itemMeta;

    public ItemBuilder(Material material) {
        this.itemStack = new ItemStack(material);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public ItemBuilder(Material material, int amount) {
        this.itemStack = new ItemStack(material, amount);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public void setItemName(String messageKey) {
        this.setItemName(messageKey, null);
    }

    public void setItemName(String messageKey, HashMap<String, String> replacements) {
        if (replacements == null) {
            this.itemMeta.itemName(new Message(messageKey).getMessage());
        } else {
            this.itemMeta.itemName(new Message(messageKey, replacements).getMessage());
        }
    }

    public void setLore(String messageKey) {
        this.setLore(messageKey, null);
    }

    public void setLore(String messageKey, HashMap<String, String> replacements) {
        ArrayList<Component> lore = replacements == null ? new Message(messageKey).getLore() : new Message(messageKey, replacements).getLore();
        if (lore == null) {
            return;
        }
        this.itemMeta.lore(lore);
    }

    public void addItemFlag(ItemFlag itemFlag) {
        this.itemMeta.addItemFlags(new ItemFlag[]{itemFlag});
        this.itemMeta.addAttributeModifier(Attribute.ARMOR, new AttributeModifier(new NamespacedKey((Plugin)Main.getInstance(), UUID.randomUUID().toString()), 0.0, AttributeModifier.Operation.ADD_NUMBER));
    }

    public void setHideTooltip(boolean value) {
        this.itemMeta.setHideTooltip(value);
    }

    public ItemBuilder setTooltipDisplay(@NotNull TooltipDisplay.Builder tooltipDisplayBuilder) {
        this.itemStack.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)((TooltipDisplay)tooltipDisplayBuilder.build()));
        return this;
    }

    public ItemStack getItemStack() {
        this.itemStack.setItemMeta(this.itemMeta);
        return this.itemStack;
    }
}

