/*
 * Decompiled with CFR 0.152.
 */
package de.lxca.slimeRanks.objects;

import de.lxca.slimeRanks.Main;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class Message {
    private static String prefix;
    private final CommandSender commandSender;
    private final boolean withPrefix;
    private final String messageKey;
    private final HashMap<String, String> replacements;

    public Message(@NotNull CommandSender commandSender, boolean withPrefix, @NotNull String messageKey) {
        this.commandSender = commandSender;
        this.withPrefix = withPrefix;
        this.messageKey = messageKey;
        this.replacements = new HashMap();
        this.sendMessage();
    }

    public Message(@NotNull CommandSender commandSender, boolean withPrefix, @NotNull String messageKey, @NotNull HashMap<String, String> replacements) {
        this.commandSender = commandSender;
        this.withPrefix = withPrefix;
        this.messageKey = messageKey;
        this.replacements = replacements;
        this.sendMessage();
    }

    public Message(@NotNull String messageKey) {
        this.commandSender = null;
        this.withPrefix = false;
        this.messageKey = messageKey;
        this.replacements = new HashMap();
    }

    public Message(@NotNull String messageKey, boolean withPrefix) {
        this.commandSender = null;
        this.withPrefix = withPrefix;
        this.messageKey = messageKey;
        this.replacements = new HashMap();
    }

    public Message(@NotNull String messageKey, @NotNull HashMap<String, String> replacements) {
        this.commandSender = null;
        this.withPrefix = false;
        this.messageKey = messageKey;
        this.replacements = replacements;
    }

    public String getRawMessage() {
        Object messageString = Main.getMessagesYml().getYmlConfig().getString(this.messageKey, null);
        if (messageString == null) {
            Main.getLogger("SlimeRanks").warn("Message with key {} not found in messages.yml!", (Object)this.messageKey);
            return this.messageKey;
        }
        if (this.withPrefix) {
            messageString = this.getPrefix() + (String)messageString;
        }
        HashMap<String, String> replacements = this.getReplacedReplacements();
        for (String key : replacements.keySet()) {
            String regex = "\\{" + key + "}";
            messageString = ((String)messageString).replaceAll(regex, replacements.get(key));
        }
        return messageString;
    }

    public Component getMessage() {
        return MiniMessage.miniMessage().deserialize((Object)this.getRawMessage());
    }

    public ArrayList<Component> getLore() {
        List loreLines = Main.getMessagesYml().getYmlConfig().getList(this.messageKey, null);
        if (loreLines == null || loreLines.isEmpty()) {
            Main.getLogger("SlimeRanks").warn("Message with key {} not found or is empty in messages.yml!", (Object)this.messageKey);
            return null;
        }
        HashMap<String, String> replacements = this.getReplacedReplacements();
        ArrayList<Component> loreLineComponents = new ArrayList<Component>();
        for (Object loreLine : loreLines) {
            if (!(loreLine instanceof String)) {
                Main.getLogger("SlimeRanks").warn("Message with key {} contains non-string lore line at index {} in messages.yml!", (Object)this.messageKey, (Object)String.valueOf(loreLines.indexOf(loreLine)));
                continue;
            }
            String loreLineString = (String)loreLine;
            for (String key : replacements.keySet()) {
                String regex = "\\{" + key + "}";
                loreLineString = loreLineString.replaceAll(regex, replacements.get(key));
            }
            loreLineComponents.add(MiniMessage.miniMessage().deserialize((Object)loreLineString));
        }
        return loreLineComponents;
    }

    @NotNull
    private HashMap<String, String> getReplacedReplacements() {
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.replacements.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value != null && value.startsWith("%")) {
                String valueMessage = new Message(value.substring(1)).getRawMessage();
                replacements.put(key, valueMessage);
                continue;
            }
            replacements.put(key, value);
        }
        return replacements;
    }

    public void sendMessage() {
        if (this.commandSender == null) {
            return;
        }
        this.commandSender.sendMessage(this.getMessage());
    }

    private String getPrefix() {
        if (prefix != null) {
            return prefix;
        }
        prefix = Main.getMessagesYml().getYmlConfig().getString("Chat.Brand", "Chat.Brand");
        return prefix;
    }

    public static void resetPrefix() {
        prefix = null;
    }
}

