/*
 * Decompiled with CFR 0.152.
 */
package de.lxca.slimeRanks.objects;

import de.lxca.slimeRanks.Main;
import de.lxca.slimeRanks.objects.Rank;
import de.lxca.slimeRanks.objects.RankManager;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PlayerNameTag {
    private static final HashMap<Player, PlayerNameTag> playerNameTags = new HashMap();
    private static final NamespacedKey nameTagKey = new NamespacedKey((Plugin)Main.getInstance(), "slimeranks_rank");
    private final Player player;
    private final TextDisplay nameTag;

    private PlayerNameTag(Player player) {
        if (RankManager.getInstance().getPlayerRank(player) == null) {
            this.player = null;
            this.nameTag = null;
            return;
        }
        this.player = player;
        this.nameTag = this.spawnNameTag();
        playerNameTags.put(player, this);
    }

    @NotNull
    private TextDisplay spawnNameTag() {
        TextDisplay nameTag = (TextDisplay)this.player.getWorld().spawn(PlayerNameTag.getNameTagLocation(this.player), TextDisplay.class);
        nameTag.setTransformation(new Transformation(new Vector3f(0.0f, 0.25f, 0.0f), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.0f), new Quaternionf()));
        nameTag.setBillboard(Display.Billboard.CENTER);
        nameTag.setAlignment(TextDisplay.TextAlignment.CENTER);
        nameTag.getPersistentDataContainer().set(nameTagKey, PersistentDataType.BOOLEAN, (Object)true);
        this.setText(nameTag);
        this.setSeeThrough(nameTag, !this.player.isSneaking());
        this.setVisibility(nameTag, this.player, false);
        this.mount(nameTag);
        return nameTag;
    }

    private void setText(@NotNull TextDisplay nameTag) {
        Rank rank = RankManager.getInstance().getPlayerRank(this.player);
        if (rank == null) {
            return;
        }
        nameTag.text(rank.getNameTagFormat(this.player));
    }

    public void setSeeThrough(boolean seeThrough) {
        this.setSeeThrough(this.nameTag, seeThrough);
    }

    private void setSeeThrough(@NotNull TextDisplay nameTag, boolean seeThrough) {
        nameTag.setSeeThrough(seeThrough);
    }

    public void setVisibility(Player viewer, boolean visible) {
        this.setVisibility(this.nameTag, viewer, visible);
    }

    private void setVisibility(TextDisplay nameTag, Player viewer, boolean visible) {
        if (visible) {
            viewer.showEntity((Plugin)Main.getInstance(), (Entity)nameTag);
        } else {
            viewer.hideEntity((Plugin)Main.getInstance(), (Entity)nameTag);
        }
    }

    public void mount() {
        this.mount(this.nameTag);
    }

    public void mount(@NotNull TextDisplay nameTag) {
        if (this.player.getWorld() != nameTag.getWorld()) {
            nameTag.teleportAsync(PlayerNameTag.getNameTagLocation(this.player));
        }
        this.player.getScheduler().run((Plugin)Main.getInstance(), scheduledTask -> this.player.addPassenger((Entity)nameTag), null);
    }

    public void hideForAll() {
        for (Player loopPlayer : Bukkit.getOnlinePlayers()) {
            this.setVisibility(loopPlayer, false);
        }
    }

    public void showForAllPermittedPlayers() {
        if (!PlayerNameTag.shouldDisplayPlayerNameTag(this.player, true, true)) {
            return;
        }
        for (Player loopPlayer : Bukkit.getOnlinePlayers()) {
            if (this.player == loopPlayer || !loopPlayer.canSee(this.player)) continue;
            this.setVisibility(loopPlayer, true);
        }
    }

    public void remove() {
        PlayerNameTag.removeTextDisplay(this.nameTag);
        playerNameTags.remove(this.player);
    }

    public static boolean hasNameTag(@NotNull Player player) {
        return playerNameTags.containsKey(player);
    }

    @Nullable
    public static synchronized PlayerNameTag getPlayerNameTag(@NotNull Player player) {
        if (playerNameTags.containsKey(player)) {
            return playerNameTags.get(player);
        }
        if (RankManager.getInstance().getPlayerRank(player) != null) {
            return new PlayerNameTag(player);
        }
        return null;
    }

    public static void clearPlayerNameTags() {
        HashMap<Player, PlayerNameTag> playerNameTags = new HashMap<Player, PlayerNameTag>(PlayerNameTag.playerNameTags);
        for (PlayerNameTag playerNameTag : playerNameTags.values()) {
            playerNameTag.remove();
        }
    }

    public static void clearBuggyNameTags(@NotNull World world) {
        for (Entity entity : world.getEntities()) {
            TextDisplay nameTag;
            if (!(entity instanceof TextDisplay) || !PlayerNameTag.isNameTagRemovable(nameTag = (TextDisplay)entity)) continue;
            PlayerNameTag.removeTextDisplay(nameTag);
        }
    }

    public static void clearBuggyNameTags(@NotNull Chunk chunk) {
        for (Entity entity : chunk.getEntities()) {
            TextDisplay nameTag;
            if (!(entity instanceof TextDisplay) || !PlayerNameTag.isNameTagRemovable(nameTag = (TextDisplay)entity)) continue;
            PlayerNameTag.removeTextDisplay(nameTag);
        }
    }

    public static boolean shouldDisplayPlayerNameTag(@NotNull Player player, boolean gameModeCheck, boolean invisibleCheck) {
        Rank rank = RankManager.getInstance().getPlayerRank(player);
        return !(rank == null || !rank.nameTagIsActive() || gameModeCheck && player.getGameMode() == GameMode.SPECTATOR || invisibleCheck && player.hasPotionEffect(PotionEffectType.INVISIBILITY));
    }

    private static Location getNameTagLocation(@Nullable Player player) {
        if (player == null) {
            return null;
        }
        return player.getLocation().add(0.0, 1.8, 0.0);
    }

    private static boolean isNameTagRemovable(@NotNull TextDisplay nameTag) {
        return nameTag.getPersistentDataContainer().has(nameTagKey, PersistentDataType.BOOLEAN) && playerNameTags.values().stream().noneMatch(playerNameTag -> playerNameTag.nameTag.equals((Object)nameTag));
    }

    private static void removeTextDisplay(@NotNull TextDisplay nameTag) {
        if (Main.isFolia()) {
            nameTag.getScheduler().run((Plugin)Main.getInstance(), task -> nameTag.remove(), null);
        } else {
            nameTag.remove();
        }
    }
}

