/*
 * Decompiled with CFR 0.152.
 */
package de.lxca.slimeRanks.objects;

import de.lxca.slimeRanks.Main;
import de.lxca.slimeRanks.objects.PlayerNameTag;
import de.lxca.slimeRanks.objects.Rank;
import java.util.ArrayList;
import java.util.Comparator;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RankManager {
    private static RankManager instance;
    private static final ArrayList<Rank> ranks;

    private RankManager() {
        this.reloadRanks();
    }

    public static synchronized RankManager getInstance() {
        if (instance == null) {
            instance = new RankManager();
        }
        return instance;
    }

    public void reloadRanks() {
        ranks.clear();
        YamlConfiguration ranksYml = Main.getRanksYml().getYmlConfig();
        ConfigurationSection ranksSection = ranksYml.getConfigurationSection("Ranks");
        if (ranksSection == null) {
            Main.getLogger(this.getClass()).warn("Could not find ranks section in ranks.yml. Please check the file and recreate if necessary.");
            return;
        }
        for (String identifier : ranksSection.getKeys(false)) {
            ranks.add(new Rank(identifier));
        }
        ranks.sort(Comparator.comparingInt(Rank::getRankPriority).reversed());
    }

    public ArrayList<Rank> getRanks() {
        return new ArrayList<Rank>(ranks);
    }

    public int getRankCount() {
        return ranks.size();
    }

    @Nullable
    public Rank getPlayerRank(@NotNull Player player) {
        for (Rank rank : ranks) {
            if (rank.getPermission() != null && !player.hasPermission(rank.getPermission())) continue;
            return rank;
        }
        return null;
    }

    public void reloadDisplays() {
        PlayerNameTag.clearPlayerNameTags();
        if (!Main.isFolia()) {
            for (World world : Bukkit.getWorlds()) {
                PlayerNameTag.clearBuggyNameTags(world);
            }
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            Rank rank = instance.getPlayerRank(player);
            if (rank == null) {
                player.playerListName(player.name());
                player.setPlayerListOrder(0);
                continue;
            }
            if (rank.tabIsActive()) {
                player.playerListName(rank.getTabFormat(player));
                player.setPlayerListOrder(rank.getTabPriority());
            }
            if (!rank.nameTagIsActive() || !PlayerNameTag.shouldDisplayPlayerNameTag(player, true, true)) continue;
            player.getScheduler().run((Plugin)Main.getInstance(), scheduledTask -> PlayerNameTag.getPlayerNameTag(player), null);
        }
    }

    static {
        ranks = new ArrayList();
    }
}

