/*
 * Decompiled with CFR 0.152.
 */
package de.lxca.slimeRanks.objects.configurations;

import de.lxca.slimeRanks.Main;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public class Yml {
    private final String filePath;
    private final String fileName;
    private File configFile;
    private YamlConfiguration ymlConfig;

    public Yml(String filePath, String fileName) {
        this.filePath = filePath;
        this.fileName = fileName;
        this.configFile = this.createConfigFileIfNotExists();
        this.ymlConfig = this.loadYmlConfig();
    }

    @Nullable
    private File createConfigFileIfNotExists() {
        if (!this.pathExists() && !new File(this.filePath).mkdirs()) {
            Main.getLogger(this.getClass()).warn("Failed to create directory {}.", (Object)this.filePath);
            return null;
        }
        if (!this.fileExists()) {
            try {
                if (!new File(this.filePath + this.fileName).createNewFile()) {
                    Main.getLogger(this.getClass()).warn("Failed to create file {}{}.", (Object)this.filePath, (Object)this.fileName);
                    return null;
                }
            }
            catch (IOException e) {
                Main.getLogger(this.getClass()).error("Failed to create file {}{}!", (Object)this.filePath, (Object)this.fileName);
                throw new RuntimeException(e);
            }
        }
        return new File(this.filePath + this.fileName);
    }

    public YamlConfiguration loadYmlConfig() {
        if (!this.fileExists()) {
            this.configFile = this.createConfigFileIfNotExists();
        }
        if (this.configFile == null) {
            Main.getLogger(this.getClass()).error("Failed to load file {}{}!", (Object)this.filePath, (Object)this.fileName);
            return null;
        }
        this.ymlConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
        return this.ymlConfig;
    }

    public YamlConfiguration getYmlConfig() {
        return this.ymlConfig;
    }

    public void saveYmlConfig() {
        try {
            this.ymlConfig.save(this.configFile);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void setDefaultYmlKeys() {
        this.saveYmlConfig();
    }

    protected void createConfigKey(String key, Object defaultValue) {
        if (!this.ymlConfig.getKeys(true).contains(key)) {
            this.ymlConfig.set(key, defaultValue);
        }
    }

    private boolean pathExists() {
        return new File(this.filePath).exists();
    }

    private boolean fileExists() {
        return new File(this.filePath + this.fileName).exists();
    }
}

