/*
 * Decompiled with CFR 0.152.
 */
package de.lxca.slimeRanks.objects.dialogs;

import de.lxca.slimeRanks.enums.FormatType;
import de.lxca.slimeRanks.guis.RankEditGui;
import de.lxca.slimeRanks.objects.Message;
import de.lxca.slimeRanks.objects.Rank;
import de.lxca.slimeRanks.objects.RankManager;
import de.lxca.slimeRanks.objects.dialogs.BaseDialog;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.TextDialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.time.temporal.TemporalAmount;
import java.util.HashMap;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class FormatDialog
extends BaseDialog {
    private final FormatType formatType;

    public FormatDialog(@NotNull Player player, Rank rank, FormatType formatType) {
        super(player, rank, false);
        this.formatType = formatType;
        this.dialog = this.buildDialog();
    }

    @Override
    @NotNull
    protected Dialog buildDialog() {
        return Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).base(DialogBase.builder((Component)this.getDialogTitle()).body(List.of(DialogBody.plainMessage((Component)this.getBodyDescription(), (int)300))).inputs(List.of(DialogInput.text((String)this.formatType.name(), (int)300, (Component)Component.empty(), (boolean)false, (String)this.getCurrentFormat(), (int)Integer.MAX_VALUE, (TextDialogInput.MultilineOptions)TextDialogInput.MultilineOptions.create((Integer)Integer.MAX_VALUE, (Integer)128)))).build()).type((DialogType)DialogType.confirmation((ActionButton)ActionButton.create((Component)new Message("dialog.global.back").getMessage(), null, (int)100, null), (ActionButton)ActionButton.create((Component)new Message("dialog.global.save").getMessage(), null, (int)100, (DialogAction)this.getSaveDialogAction()))));
    }

    private String getCurrentFormat() {
        if (this.formatType == FormatType.CHAT) {
            return this.rank.getRawChatFormat();
        }
        if (this.formatType == FormatType.NAME_TAG) {
            return this.rank.getRawNameTagFormat();
        }
        return this.rank.getRawTabFormat();
    }

    private Component getDialogTitle() {
        if (this.formatType == FormatType.CHAT) {
            return new Message("dialog.edit_rank.chat.title").getMessage();
        }
        if (this.formatType == FormatType.NAME_TAG) {
            return new Message("dialog.edit_rank.name_tag.title").getMessage();
        }
        return new Message("dialog.edit_rank.tab.title").getMessage();
    }

    private Component getBodyDescription() {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("rank", this.rank.getIdentifier());
        if (this.formatType == FormatType.CHAT) {
            return new Message("dialog.edit_rank.chat.description", replacements).getMessage();
        }
        if (this.formatType == FormatType.NAME_TAG) {
            return new Message("dialog.edit_rank.name_tag.description", replacements).getMessage();
        }
        return new Message("dialog.edit_rank.tab.description", replacements).getMessage();
    }

    private void setNewFormat(@NotNull String newFormat) {
        if (this.formatType == FormatType.CHAT) {
            this.rank.setChatFormat(newFormat);
        } else if (this.formatType == FormatType.NAME_TAG) {
            this.rank.setNameTagFormat(newFormat);
        } else {
            this.rank.setTabFormat(newFormat);
        }
        RankManager.getInstance().reloadDisplays();
    }

    @Contract(value=" -> new")
    @NotNull
    private DialogAction getSaveDialogAction() {
        return DialogAction.customClick((view, audience) -> {
            String newFormat = view.getText(this.formatType.name());
            this.setNewFormat(newFormat != null ? newFormat : "");
            if (audience instanceof Player) {
                Player player = (Player)audience;
                player.playSound((Entity)player, Sound.ENTITY_VILLAGER_WORK_CARTOGRAPHER, 1.0f, 1.0f);
                player.openInventory(new RankEditGui(this.rank).getInventory());
            }
        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).lifetime((TemporalAmount)ClickCallback.DEFAULT_LIFETIME).build()));
    }
}

