/*
 * Decompiled with CFR 0.152.
 */
package de.lxca.slimeRanks.objects.dialogs;

import de.lxca.slimeRanks.guis.RankEditGui;
import de.lxca.slimeRanks.objects.Message;
import de.lxca.slimeRanks.objects.Rank;
import de.lxca.slimeRanks.objects.RankManager;
import de.lxca.slimeRanks.objects.dialogs.BaseDialog;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.TextDialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.time.temporal.TemporalAmount;
import java.util.HashMap;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermissionDialog
extends BaseDialog {
    private static final String PERMISSION_KEY = "permission";

    public PermissionDialog(@NotNull Player player, Rank rank) {
        super(player, rank, false);
        this.dialog = this.buildDialog();
    }

    @Override
    @NotNull
    protected Dialog buildDialog() {
        return Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).base(DialogBase.builder((Component)this.getDialogTitle()).body(List.of(DialogBody.plainMessage((Component)this.getBodyDescription(), (int)300))).inputs(List.of(DialogInput.text((String)PERMISSION_KEY, (int)300, (Component)Component.empty(), (boolean)false, (String)(this.rank.getPermission() != null ? this.rank.getPermission() : ""), (int)128, (TextDialogInput.MultilineOptions)TextDialogInput.MultilineOptions.create((Integer)1, (Integer)17)))).build()).type((DialogType)DialogType.confirmation((ActionButton)ActionButton.create((Component)new Message("dialog.global.back").getMessage(), null, (int)100, null), (ActionButton)ActionButton.create((Component)new Message("dialog.global.save").getMessage(), null, (int)100, (DialogAction)this.getSaveDialogAction()))));
    }

    private Component getDialogTitle() {
        return new Message("dialog.edit_rank.permission.title").getMessage();
    }

    private Component getBodyDescription() {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("rank", this.rank.getIdentifier());
        return new Message("dialog.edit_rank.permission.description", replacements).getMessage();
    }

    private void setNewPermission(@Nullable String newPermission) {
        this.rank.setPermission(newPermission);
        RankManager.getInstance().reloadDisplays();
    }

    @Contract(value=" -> new")
    @NotNull
    private DialogAction getSaveDialogAction() {
        return DialogAction.customClick((view, audience) -> {
            String newPermission = view.getText(PERMISSION_KEY);
            if (newPermission == null || newPermission.isEmpty()) {
                this.setNewPermission(null);
            } else {
                this.setNewPermission(newPermission);
            }
            if (audience instanceof Player) {
                Player player = (Player)audience;
                player.playSound((Entity)player, Sound.ENTITY_VILLAGER_WORK_CARTOGRAPHER, 1.0f, 1.0f);
                player.openInventory(new RankEditGui(this.rank).getInventory());
            }
        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).lifetime((TemporalAmount)ClickCallback.DEFAULT_LIFETIME).build()));
    }
}

